/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AuthorBlameException;
import com.cenqua.fisheye.rep.AuthorBlameLines;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.TagTreeVisitor;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.util.SumMap;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorLinecountCalculator {
    private final RepositoryStatus status;
    private final RevisionCache cache;
    private final BucketGraph bucketGraph;
    private final String repoName;
    int numProcessed = 0;

    public AuthorLinecountCalculator(RepositoryEngine engine) throws DbException {
        this.cache = engine.getRevisionCache();
        this.status = engine.getStatus();
        this.bucketGraph = engine.getBucketGraph();
        this.repoName = engine.getName();
    }

    public AuthorLinecountCalculator(RevisionCache cache, RepositoryStatus status, String repositoryName) throws DbException {
        this.cache = cache;
        this.status = status;
        this.bucketGraph = new BucketGraph(cache.getInfDb(), repositoryName, cache.isCaseSensitive());
        this.repoName = repositoryName;
    }

    public void calcBlame() throws DbException {
        if (!this.cache.showAuthorLinecount()) {
            return;
        }
        try {
            _Cu revidCursor = _Cu.alloc().append(CommonSchema.RevInfo.ENTITY);
            int revidCursorPrefixLength = revidCursor.length();
            revidCursor.append(this.bucketGraph.getAuthorBlameDoneMinimum());
            _k4ui8vIDB db = this.cache.getInfDb().get();
            while (((_ItemSpace)db).next(revidCursor, revidCursorPrefixLength)) {
                if (this.status != null && this.status.isStopRequested()) {
                    return;
                }
                int revid = (int)revidCursor.longAt(revidCursorPrefixLength);
                if (!this.bucketGraph.isAuthorBlameDone(revid)) {
                    CommonFileRevision rev = (CommonFileRevision)this.cache.getFileRevision(revid);
                    if (rev == null) {
                        Logs.APP_LOG.debug((Object)(this.repoName + ": Revision is null for revid " + revid));
                    } else if (!rev.isDead() || rev.getAncestorRevision() != null) {
                        DescendVisitor vis = new DescendVisitor();
                        new TagTreeVisitor(db).visitAncestorDescendents(revid, vis);
                        this.calcBlame(vis);
                    }
                }
                this.bucketGraph.setAuthorBlameDoneMinimum(revid);
                int offsetAfterKey = revidCursor.skipLong(revidCursorPrefixLength);
                revidCursor.setLength(offsetAfterKey);
                revidCursor.incrementSuffix(revidCursorPrefixLength);
            }
            this.cache.getInfDb().commit();
            _Cu.dispose(revidCursor);
            this.status.setMessage(this.repoName + ": Finished calculating author blame, " + this.numProcessed + " revisions processed");
        }
        catch (IOException e2) {
            throw new DbException(this.repoName + ": Error reading database in linecount slurp", e2);
        }
        try {
            this.cache.getInfDb().commit();
        }
        catch (IOException e3) {
            Logs.APP_LOG.error((Object)"Problem commiting", (Throwable)e3);
        }
    }

    private void calcBlame(DescendVisitor vis) throws DbException, IOException {
        TreeMap<Integer, History> history = new TreeMap<Integer, History>();
        List<Integer> revids = vis.getProcessingList();
        while (revids.size() > 0) {
            if (this.status != null && this.status.isStopRequested()) {
                return;
            }
            int revid = revids.remove(0);
            this.calcBlame(revid, history, vis.getNumChildren(revid));
        }
    }

    private void calcBlame(int revid, Map<Integer, History> history, int numChildren) throws DbException {
        int id;
        CommonFileRevision rev = (CommonFileRevision)this.cache.getFileRevision(revid);
        CommonFileRevision ancestor = null;
        CommonFileRevision predecessor = null;
        try {
            if (rev.getAncestor() != null) {
                ancestor = (CommonFileRevision)this.cache.getFileRevision(rev.getAncestor());
            }
            if (rev.getPredecessor() != null) {
                predecessor = (CommonFileRevision)this.cache.getFileRevision(rev.getPredecessor());
            }
            if (this.isHistoryMissingRev(history, ancestor) || this.isHistoryMissingRev(history, predecessor)) {
                history.put(revid, null);
                this.updateAuthorBlameError(rev);
            } else if (this.isCvsBranch(rev)) {
                this.updateAuthorBlameCvsBranch(history, rev, ancestor, numChildren);
            } else {
                History revHistory;
                if (this.isNewlyAdded(rev) || ancestor == null) {
                    revHistory = this.getInitialHistory(rev, numChildren);
                } else if (this.isDirectDescendent(rev)) {
                    History ancestorHistory = history.get(ancestor.getRevID());
                    if (rev.isAdded()) {
                        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
                        hunks.add(new Hunk(1, 1, ancestor.getLineCount(), rev.getLineCount()));
                        revHistory = this.getAuthDiff(rev, ancestorHistory, numChildren, hunks);
                    } else {
                        revHistory = this.getAuthDiff(rev, ancestorHistory, numChildren, rev.getHunks());
                    }
                } else {
                    revHistory = ancestor.getLineCount() == rev.getLineCount() ? this.getAuthDiff(rev, history.get(ancestor.getRevID()), numChildren, new ArrayList<Hunk>()) : this.getInitialHistory(rev, numChildren);
                }
                SumMap<String> diffAdjust = this.getDifference(revHistory.authorLinecount, predecessor == null ? null : history.get((Object)Integer.valueOf((int)predecessor.getRevID())).authorLinecount);
                diffAdjust.addValue(rev.getAuthor(), rev.getLinesRemoved() - rev.getLinesAdded());
                this.updateAuthorBlameRevision(rev, diffAdjust);
                history.put(revid, revHistory);
            }
        }
        catch (RuntimeException e2) {
            this.printDebugInfo(rev, e2);
            this.updateAuthorBlameError(rev);
            history.put(revid, null);
        }
        catch (AuthorBlameException e3) {
            this.printDebugInfo(rev, e3);
            this.updateAuthorBlameError(rev);
            history.put(revid, null);
        }
        if (history.containsKey(revid) && history.get(revid) != null && history.get(revid).children == 0) {
            history.remove(revid);
        }
        if (ancestor != null && history.containsKey(id = ancestor.getRevID()) && history.get(id) != null && history.get(id).children == 0) {
            history.remove(id);
        }
        if (predecessor != null && history.containsKey(id = predecessor.getRevID()) && history.get(id) != null && history.get(id).children == 0) {
            history.remove(id);
        }
    }

    private boolean isHistoryMissingRev(Map<Integer, History> history, CommonFileRevision rev) {
        return rev != null && (!history.containsKey(rev.getRevID()) || history.get(rev.getRevID()) == null);
    }

    private boolean isDirectDescendent(CommonFileRevision rev) {
        return rev.getAncestorLink().getType() == 0;
    }

    private boolean isNewlyAdded(CommonFileRevision rev) {
        return rev.getAncestorLink() == null;
    }

    private boolean isCvsBranch(CommonFileRevision rev) {
        return this.cache.getRepositoryType().equals("cvs") && rev.getAncestorLink() != null && rev.getAncestorLink().getType() == 1;
    }

    private void updateAuthorBlameCvsBranch(Map<Integer, History> history, CommonFileRevision rev, CommonFileRevision ancestor, int numChildren) throws DbException {
        try {
            int revid = rev.getRevID();
            int ancestorId = ancestor.getRevID();
            history.put(revid, this.getAuthDiff(rev, history.get(ancestorId), numChildren, rev.getHunks()));
            SumMap<String> ancestorAuthorLinecount = history.get((Object)Integer.valueOf((int)ancestorId)).authorLinecount;
            SumMap<String> revAuthorLinediff = this.getDifference(history.get((Object)Integer.valueOf((int)revid)).authorLinecount, ancestorAuthorLinecount);
            if (!this.bucketGraph.isAuthorBlameDone(rev.getRevID())) {
                this.bucketGraph.setAuthorBlameDone(rev.getRevID());
                this.updateAuthorBlame(this.createAuthDiff(ancestorAuthorLinecount, ancestor.getAuthor(), -ancestor.getLineCount()), ancestor.getPath(), rev.getBranch(), ancestor.getDateValue(), rev.isTrunkLike(), rev.getRevInfoKey(), rev.getRevID());
                this.updateAuthorBlame(this.createAuthDiff(revAuthorLinediff, rev.getAuthor(), rev.getLinesRemoved() - rev.getLinesAdded()), rev.getPath(), rev.getBranch(), rev.getDateValue(), rev.isTrunkLike(), rev.getRevInfoKey(), rev.getRevID());
            }
        }
        catch (AuthorBlameException e2) {
            this.printDebugInfo(rev, e2);
            this.updateAuthorBlameError(rev);
        }
        this.incProcessed();
    }

    private SumMap<String> getDifference(SumMap<String> authorLinecount, SumMap<String> ancestorAuthorLinecount) {
        SumMap<String> diff = new SumMap<String>(new HashMap(authorLinecount));
        if (ancestorAuthorLinecount != null) {
            for (Map.Entry<String, Integer> entry : ancestorAuthorLinecount.entrySet()) {
                diff.addValue(entry.getKey(), -entry.getValue().intValue());
            }
        }
        return diff;
    }

    private SumMap<String> createAuthDiff(SumMap<String> diffFull, String adjustAuthor, int adjustAmount) {
        SumMap<String> diff = new SumMap<String>(new TreeMap());
        diff.addAllValues(diffFull);
        diff.addValue(adjustAuthor, adjustAmount);
        return diff;
    }

    private void updateAuthorBlameRevision(CommonFileRevision rev, SumMap<String> diff) throws DbException {
        if (!this.bucketGraph.isAuthorBlameDone(rev.getRevID())) {
            this.bucketGraph.setAuthorBlameDone(rev.getRevID());
            this.updateAuthorBlame(diff, rev.getPath(), rev.getBranch(), rev.getDateValue(), rev.isTrunkLike(), rev.getRevInfoKey(), rev.getRevID());
        }
    }

    private void updateAuthorBlame(SumMap<String> diff, Path path, String branch, Date date, boolean isTrunklike, RevInfoKey revInfoKey, int revid) throws DbException {
        int total = diff.getTotal();
        if (total != 0) {
            Logs.APP_LOG.debug((Object)(this.repoName + ": possible error adjusting author linecount for " + revInfoKey + " " + revid + ": Diff adds to " + total + " instead of 0: " + diff));
            this.printDebugInfo((CommonFileRevision)this.cache.getFileRevision(revInfoKey));
        }
        if (diff.size() != 0) {
            this.bucketGraph.updateAuthorBlame(path, branch, date, diff, isTrunklike);
        }
        this.incProcessed();
    }

    private void updateAuthorBlameError(CommonFileRevision rev) throws DbException {
        if (!this.bucketGraph.isAuthorBlameDone(rev.getRevID())) {
            this.bucketGraph.setAuthorBlameDone(rev.getRevID());
            Logs.APP_LOG.debug((Object)(this.repoName + ": " + rev.getRevID() + " " + rev.getRevInfoKey() + ": author blame not processed because there was a problem with this revision or one of its ancestors"));
        }
    }

    private void incProcessed() {
        ++this.numProcessed;
        if (this.numProcessed % 500 == 0) {
            this.status.setMessage(this.repoName + ": Processed author blame for " + this.numProcessed + " revisions");
        }
    }

    private History getInitialHistory(FileRevision rev, int children) {
        int count = rev.getLineCount();
        AuthorBlameLines mLines = new AuthorBlameLines();
        mLines.init(rev.getAuthor(), count);
        SumMap<String> authorLineCount = new SumMap<String>(new TreeMap());
        if (count > 0) {
            authorLineCount.put(rev.getAuthor(), count);
        }
        return new History(authorLineCount, mLines, children);
    }

    private void printDebugInfo(CommonFileRevision revision, Exception e2) throws DbException {
        Logs.APP_LOG.debug((Object)"Error calculating author blame");
        Logs.APP_LOG.debug((Object)e2.toString());
        for (StackTraceElement element : e2.getStackTrace()) {
            Logs.APP_LOG.debug((Object)element.toString());
        }
        this.printDebugInfo(revision);
    }

    private void printDebugInfo(CommonFileRevision revision) throws DbException {
        if (revision != null) {
            Logs.APP_LOG.debug((Object)("Revision:    " + this.commonFileRevisionToString(revision)));
            if (revision.getAncestor() != null) {
                Logs.APP_LOG.debug((Object)("Ancestor:    " + this.commonFileRevisionToString((CommonFileRevision)this.cache.getFileRevision(revision.getAncestor()))));
            }
            if (revision.getPredecessor() != null) {
                Logs.APP_LOG.debug((Object)("Predecessor: " + this.commonFileRevisionToString((CommonFileRevision)this.cache.getFileRevision(revision.getPredecessor()))));
            }
        }
    }

    private History getAuthDiff(CommonFileRevision revision, History ancestorHistory, int children, List<Hunk> hunks) throws DbException, AuthorBlameException {
        SumMap<String> authorLinecount;
        AuthorBlameLines mLines = ancestorHistory.getLines();
        if (revision.isDead()) {
            authorLinecount = new SumMap(new TreeMap());
            mLines = new AuthorBlameLines();
        } else {
            SumMap<String> authorDiff = this.applyHunksToSpans(revision, hunks, mLines);
            authorLinecount = this.getAuthorLinecount(authorDiff, ancestorHistory.authorLinecount);
        }
        if (mLines.size() != revision.getLineCount()) {
            throw new AuthorBlameException("Mlines not equal to linecount: Mlines: " + mLines.size() + ", linecount: " + revision.getLineCount() + ", difference " + (mLines.size() - revision.getLineCount()));
        }
        if (this.linecountHasNegative(authorLinecount)) {
            Logs.APP_LOG.debug((Object)("Negative author blame calculated: " + authorLinecount));
            this.printDebugInfo(revision);
        }
        return new History(authorLinecount, mLines, children);
    }

    private boolean linecountHasNegative(SumMap<String> authorLinecount) {
        for (int lines : authorLinecount.values()) {
            if (lines >= 0) continue;
            return true;
        }
        return false;
    }

    private SumMap<String> getAuthorLinecount(SumMap<String> diff, SumMap<String> prevLinecount) {
        SumMap<String> tmp = new SumMap<String>(new TreeMap());
        tmp.addAllValues(prevLinecount);
        tmp.addAllValues(diff);
        return tmp;
    }

    private SumMap<String> applyHunksToSpans(CommonFileRevision rev, List<Hunk> aHunks, AuthorBlameLines mLines) throws DbException, AuthorBlameException {
        try {
            SumMap<String> authDiff = new SumMap<String>(new TreeMap());
            if (aHunks != null) {
                Object[] hunks = new Hunk[aHunks.size()];
                aHunks.toArray(hunks);
                Arrays.sort(hunks);
                for (Object hunk : hunks) {
                    mLines.removeBlame(((Hunk)hunk).getToIndex(), ((Hunk)hunk).getFromCount(), authDiff);
                    mLines.addBlame(rev.getAuthor(), ((Hunk)hunk).getToIndex(), ((Hunk)hunk).getToCount(), authDiff);
                }
            }
            return authDiff;
        }
        catch (RuntimeException e2) {
            throw new AuthorBlameException("Runtime error while calculating author blame", e2);
        }
    }

    public String commonFileRevisionToString(CommonFileRevision rev) {
        StringBuilder sb = new StringBuilder();
        sb.append("revid: ").append(rev.getRevID());
        sb.append(", revInfoKey: ").append(rev.getRevInfoKey());
        sb.append(", branch: ").append(rev.getBranch());
        sb.append(", date: ").append(rev.getDateValue());
        sb.append(", author: ").append(rev.getAuthor());
        sb.append(", linecount: ").append(rev.getLineCount());
        sb.append(" (+").append(rev.getLinesAdded()).append(" -").append(rev.getLinesRemoved()).append(")");
        sb.append(", isBinary: ").append(rev.isBinary());
        sb.append(", isDead: ").append(rev.isDead());
        sb.append(", isAdded: ").append(rev.isAdded());
        sb.append(", isModify: ").append(rev.isModify());
        sb.append(", isCopy: ").append(rev.isCopy());
        sb.append(", isMove: ").append(rev.isMove());
        sb.append(", ancestor: ").append(rev.getAncestor());
        sb.append(", predecessor: ").append(rev.getPredecessor());
        sb.append(", branchpoint for branches: ").append(rev.getBranches());
        Pair<Integer, Integer> total = this.diffTotal(rev.getHunks());
        sb.append(", diff hunks (+").append(total.getFirst()).append(" -").append(total.getSecond()).append(") ").append(rev.getHunks());
        return sb.toString();
    }

    private Pair<Integer, Integer> diffTotal(List<Hunk> hunks) {
        int added = 0;
        int removed = 0;
        for (Hunk hunk : hunks) {
            added += hunk.getToCount();
            removed += hunk.getFromCount();
        }
        return new Pair<Integer, Integer>(added, removed);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescendVisitor
    implements TagTreeVisitor.AncestorDescendentVisitor {
        Map<Integer, Set<Integer>> parentToChildren = new HashMap<Integer, Set<Integer>>();
        Map<Integer, Set<Integer>> childToParents = new HashMap<Integer, Set<Integer>>();

        private DescendVisitor() {
        }

        @Override
        public void visitDescendent(int revidParent, int revidChild) throws DbException, IOException {
            Set<Integer> children = this.parentToChildren.get(revidParent);
            if (children == null) {
                children = new HashSet<Integer>();
                children.add(revidChild);
            } else {
                children.add(revidChild);
            }
            this.parentToChildren.put(revidParent, children);
            if (revidParent != -1) {
                Set<Integer> parents = this.childToParents.get(revidChild);
                if (parents == null) {
                    parents = new HashSet<Integer>();
                    parents.add(revidParent);
                } else {
                    parents.add(revidParent);
                }
                this.childToParents.put(revidChild, parents);
            }
        }

        public String toString() {
            return this.parentToChildren.toString();
        }

        public Set<Integer> getChildren(int parentId) {
            Set<Integer> result = this.parentToChildren.get(parentId);
            if (result == null) {
                result = new HashSet<Integer>();
            }
            return result;
        }

        public Set<Integer> getParents(int childId) {
            Set<Integer> result = this.childToParents.get(childId);
            if (result == null) {
                result = new HashSet<Integer>();
            }
            return result;
        }

        public int getNumChildren(int parentId) {
            Set<Integer> result = this.parentToChildren.get(parentId);
            if (result == null) {
                return 0;
            }
            return result.size();
        }

        public List<Integer> getProcessingList() {
            TreeSet<Integer> allRevids = new TreeSet<Integer>();
            for (Set<Integer> children : this.parentToChildren.values()) {
                allRevids.addAll(children);
            }
            return new LinkedList<Integer>(allRevids);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class History {
        public final SumMap<String> authorLinecount;
        public AuthorBlameLines mLines;
        private int children;

        public History() {
            this.authorLinecount = null;
            this.mLines = null;
        }

        public History(SumMap<String> authorLinecount, AuthorBlameLines mLines, int children) {
            this.mLines = children == 0 ? null : mLines;
            this.authorLinecount = authorLinecount;
            this.children = children;
        }

        public AuthorBlameLines getLines() {
            --this.children;
            if (this.children == 0) {
                AuthorBlameLines tmp = this.mLines;
                this.mLines = null;
                return tmp;
            }
            return this.mLines.getCopy();
        }

        public void decrementChildren() {
            --this.children;
        }

        public String toString() {
            return "line count: " + this.authorLinecount.toString() + ", mLines " + (this.mLines == null ? "null" : "length " + this.mLines.size());
        }
    }
}

