/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.FileRevision;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Blame {
    public static final int MAX_CHUNK_LENGTH = 8000;
    private final List<BlameChunk> mChunks;

    public Blame(List<BlameChunk> chunks) {
        this.mChunks = chunks;
    }

    public List<BlameChunk> getChunks() {
        return this.mChunks;
    }

    public static class BlameChunk {
        private final FileRevision mInfo;
        private final int mStart;
        private final int mOriginalStartingLine;
        private int mLength = 1;

        public BlameChunk(FileRevision info, int start, int originalStartingLine) {
            this.mInfo = info;
            this.mStart = start;
            this.mOriginalStartingLine = originalStartingLine;
        }

        public String getRevision() {
            return this.mInfo.getRevision();
        }

        public FileRevision getInfo() {
            return this.mInfo;
        }

        public int getStart() {
            return this.mStart;
        }

        public int getOriginalStartingLine() {
            return this.mOriginalStartingLine;
        }

        public int getLength() {
            return this.mLength;
        }

        public void incLength(int inc) {
            this.mLength += inc;
        }

        public String toString() {
            return this.getRevision() + " " + this.mStart + "+" + this.mLength;
        }
    }
}

