/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryIndexer {
    private LuceneConnection connection;
    private boolean failFast;

    public void forceClose() {
        this.connection.close();
    }

    public void indexContent(final FileRevision revision, final Reader content, Charset encoding) throws IOException, DbException {
        this.connection.withWriter(1, new LuceneConnection.WriterAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(IndexWriter idx) {
                try {
                    CommonIndexer indexer = new CommonIndexer();
                    indexer.indexContents(idx, revision.getRevID(), (CommonFileRevisionInput)((Object)revision), content);
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)("could not index contents of " + revision.getPath() + " " + revision.getRevision() + ". Revision contents not indexed"), (Throwable)e2);
                    if (RepositoryIndexer.this.failFast) {
                        throw new RuntimeException(e2);
                    }
                }
                finally {
                    IOHelper.close(content);
                }
            }
        });
        this.connection.flushWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexContent(FileRevision revision, File contentFile, Charset encoding) throws IOException, DbException {
        FileInputStream contents = null;
        try {
            contents = new FileInputStream(contentFile);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)contents, encoding));
            this.indexContent(revision, in, encoding);
        }
        catch (Throwable throwable) {
            IOHelper.close(contents);
            throw throwable;
        }
        IOHelper.close(contents);
    }

    public void setConnection(LuceneConnection connection) {
        this.connection = connection;
    }

    public void indexBatch(final List<? extends FileRevision> revisions) throws DbException {
        Timer timer = new Timer("Indexing metadata batch sized " + revisions.size());
        this.connection.withWriter(0, new LuceneConnection.WriterAction(){

            public void perform(IndexWriter idx0) throws DbException {
                CommonIndexer indexer = new CommonIndexer();
                for (FileRevision revInfo : revisions) {
                    indexer.insertNew(idx0, revInfo.getRevID(), (CommonFileRevisionInput)((Object)revInfo));
                }
            }
        });
        this.connection.flushWriter();
        timer.end();
    }

    public void deleteContent(SortedIntSet outdatedRevIds) throws DbException {
        this.deleteDocuments(1, outdatedRevIds);
    }

    public void deleteMetaData(SortedIntSet revids) throws DbException {
        this.deleteDocuments(0, revids);
    }

    private void deleteDocuments(int index, final SortedIntSet revids) throws DbException {
        this.connection.withReaderAndDeletes(index, new LuceneConnection.ReaderAction(){

            public void perform(IndexReader reader) throws IOException {
                CommonIndexer indexer = new CommonIndexer();
                int revid = revids.nextSetBit(0);
                while (revid >= 0) {
                    indexer.deleteDocumentsForRevid(reader, revid);
                    revid = revids.nextSetBit(revid + 1);
                }
            }
        });
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }
}

