/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.IncrementalPingRequest;
import com.cenqua.fisheye.rep.ping.PingManager;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;

public class RepositoryPinger {
    private PingRequest incrementalRequest;
    private RepositoryHandle repHandle;
    private static final long RESCHEDULE_DELAY = 60000L;
    private final Set<PingTask> queuedTasks = new HashSet<PingTask>();

    public RepositoryPinger(RepositoryHandle repHandle) {
        this.repHandle = repHandle;
        this.incrementalRequest = new IncrementalPingRequest(repHandle, new PingRequest.Callback(){

            public void done() {
                RepositoryPinger.this.scheduleIncremental();
            }
        });
    }

    public void startIncrementalIndexing(long delay) {
        this.queueRequest(this.incrementalRequest, delay);
    }

    public void processRequest(final PingRequest request) {
        Disposer.with(new Runnable(){

            public void run() {
                try {
                    RepositoryEngine engine = RepositoryPinger.this.repHandle.acquireEngine();
                    PingManager.performRequest(engine.wantInitialSlurp(), request);
                }
                catch (RejectedExecutionException e2) {
                    Logs.APP_LOG.warn((Object)"Unable to request engine ping, rescheduling", (Throwable)e2);
                    RepositoryPinger.this.queueRequest(request, 60000L);
                }
                catch (RepositoryHandle.StateException stateException) {
                    // empty catch block
                }
            }
        });
    }

    private synchronized void queueRequest(PingRequest pingRequest, long delay) {
        PingTask pingTask = new PingTask(pingRequest);
        PingManager.schedule(pingTask, delay);
        this.queuedTasks.add(pingTask);
    }

    private void scheduleIncremental() {
        long pollPeriod = this.repHandle.getEffectivePollPeriod();
        if (pollPeriod > 0L) {
            this.queueRequest(this.incrementalRequest, pollPeriod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Set<PingTask> set = this.queuedTasks;
        synchronized (set) {
            for (PingTask task : this.queuedTasks) {
                task.cancel();
            }
            this.queuedTasks.clear();
        }
    }

    private class PingTask
    extends TimerTask {
        private PingRequest request;

        private PingTask(PingRequest request) {
            this.request = request;
        }

        public PingRequest getRequest() {
            return this.request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set = RepositoryPinger.this.queuedTasks;
            synchronized (set) {
                RepositoryPinger.this.queuedTasks.remove(this);
            }
            RepositoryPinger.this.processRequest(this.request);
        }
    }
}

