/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.EavEntityCu;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.util.MinMaxLongRange;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4ui8v._Attribute;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._EntityItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSubspace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonRevInfoDAO {
    private final InfinityDbHandle dbh;
    private final CommonStringTables stringTables;
    private final boolean svnMode;
    private final boolean cvsMode;
    private final boolean caseSensitive;
    public static final String DEFAULT_AUTHOR = "no_author";
    public static final String IMPORT_COMMENT = "Created by FishEye for initial repository import";
    private static final int HUNK_BATCHSIZE = 50;
    private BucketGraph bucketGraph = null;

    public CommonRevInfoDAO(InfinityDbHandle dbh, CommonStringTables stringTables, boolean svnMode, boolean caseSensitive, boolean cvsMode) {
        this.dbh = dbh;
        this.stringTables = stringTables;
        this.svnMode = svnMode;
        this.caseSensitive = caseSensitive;
        this.cvsMode = cvsMode;
    }

    public BucketGraph getBucketGraph() throws DbException {
        if (this.bucketGraph == null) {
            this.bucketGraph = new BucketGraph(this.dbh, "", this.caseSensitive);
        }
        return this.bucketGraph;
    }

    public CommonStringTables getStringTables() {
        return this.stringTables;
    }

    public boolean exists(RevInfoKey rk) throws DbException {
        return this.getRevId(rk) != -1;
    }

    public boolean exists(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            return eav.exists();
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getRevId(RevInfoKey revInfoKey) throws DbException {
        long pathid = this.getPathId(revInfoKey.getPath());
        if (pathid == -1L) {
            return -1;
        }
        return this.getRevId(pathid, revInfoKey.getRev());
    }

    public int getRevId(long pathid, String revision) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.E_REVKEY_TO_REVID);
            cu.append(pathid).append(revision);
            int pl = cu.length();
            if (((_ItemSpace)db).next(cu, pl)) {
                return (int)cu.longAt(pl);
            }
            return -1;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addPathRevIds(SegmentedIntSet revids, int pathId) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.E_REVKEY_TO_REVID);
            cu.append(pathId);
            int pl = cu.length();
            while (((_ItemSpace)db).next(cu, pl)) {
                int revid = (int)cu.longAt(cu.skipString(pl));
                revids.set(revid);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void load(int revid, CommonFileRevision ri) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                return;
            }
            ri.setRevID(revid);
            _Cu revkey = _Cu.alloc();
            if (!eav.getValue(CommonSchema.RevInfo.A_REVKEY, revkey)) {
                throw new DbException("Unable to load key for revid " + revid);
            }
            long pathid = revkey.longAt(0);
            String revision = revkey.stringAt(revkey.skipLong(0));
            ri.setRevision(revision);
            this.fillAncestor(ri);
            this.fillPredecessor(ri);
            this.fillDescendents(ri);
            pathid = eav.getLong(CommonSchema.RevInfo.A_PATHID, pathid);
            ri.setPath(new Path(this.stringTables.pathDB.get(pathid)));
            ri.setAuthor(eav.getString(CommonSchema.RevInfo.A_AUTHOR, null));
            ri.setDate(eav.getLong(CommonSchema.RevInfo.A_DATE, 0L));
            ri.setDateEnd(eav.getLong(CommonSchema.RevInfo.A_DATE_END, 0L));
            ri.setComment(this.getStringFromTable(eav, CommonSchema.RevInfo.A_COMMENT_ID, this.stringTables.commentDB));
            ri.setBranch(eav.getString(CommonSchema.RevInfo.A_BRANCH, null));
            ri.setBinary(eav.getBoolean(CommonSchema.RevInfo.A_ISBINARY, false));
            ri.setAdded(eav.getBoolean(CommonSchema.RevInfo.A_ISADDED, false));
            ri.setDead(eav.getBoolean(CommonSchema.RevInfo.A_ISDELETED, false));
            ri.setCopy(eav.getBoolean(CommonSchema.RevInfo.A_ISCOPIED, false));
            ri.setMove(eav.getBoolean(CommonSchema.RevInfo.A_ISMOVED, false));
            ri.setModify(eav.getBoolean(CommonSchema.RevInfo.A_ISMODIFY, false));
            ri.setTrunkLike(eav.getBoolean(CommonSchema.RevInfo.A_ISTRUNKLIKE, false));
            ri.setFileType(eav.getInt(CommonSchema.RevInfo.A_FILETYPE, 1));
            _Cu cu = _Cu.alloc();
            if (eav.getValue(CommonSchema.RevInfo.A_LINEDATA, cu)) {
                int pl = 0;
                ri.setLineCount((int)cu.longAt(pl));
                pl = cu.skipLong(pl);
                ri.setLinesAdded((int)cu.longAt(pl));
                pl = cu.skipLong(pl);
                ri.setLinesRemoved((int)cu.longAt(pl));
            }
            ri.setTags(eav.getStrings(CommonSchema.E_TAGS, CommonSchema.RevInfo.A_TAGS));
            ri.setBranches(eav.getStrings(CommonSchema.RevInfo.A_BRANCH_POINTS));
            ri.setReviewIds(eav.getInts(CommonSchema.RevInfo.A_REVIEWIDS));
            ri.setHunks(this.getHunks(revid));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void fillPredecessor(CommonFileRevision ri) throws IOException, DbException {
        Integer predecessor = this.getPredecessorOf(ri.getRevID());
        if (predecessor != null) {
            ri.setPredecessor(this.getKey(predecessor));
        }
    }

    private void fillAncestor(CommonFileRevision ri) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.RevInfo.ENTITY).append(ri.getRevID());
            cu.append(CommonSchema.RevInfo.A_ANCESTOR_LINK);
            int pl = cu.length();
            if (!((_ItemSpace)db).next(cu, pl)) {
                return;
            }
            AncestorLink link = AncestorLink.fromCu(cu, pl);
            ri.setAncestorLink(link);
            RevInfoKey ancestorKey = this.getKey(link.getRevid());
            if (ancestorKey == null) {
                Logs.APP_LOG.warn((Object)("Could not find ancestor for " + ri.getRevID()));
                return;
            }
            ri.setAncestor(ancestorKey);
            if (link.isCopy()) {
                ri.setCopySource(ancestorKey);
            }
            if (link.isMove()) {
                ri.setMoveSource(ancestorKey);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void fillDescendents(CommonFileRevision ri) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.E_ANCESTORLINK_TO_REVID);
            int p0 = cu.length();
            cu.append(ri.getRevID());
            int pl = cu.length();
            while (((_ItemSpace)db).next(cu, pl)) {
                AncestorLink link = AncestorLink.fromCu(cu, p0);
                int descendantid = (int)cu.longAt(cu.skipLong(pl));
                if (link.isCopy()) {
                    ri.addCopyDestination(this.getKey(descendantid));
                }
                if (!link.isMove()) continue;
                ri.setMoveDest(this.getKey(descendantid));
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public RevInfoKey getKey(int revid) throws DbException {
        try {
            if (revid == -1) {
                Logs.APP_LOG.warn((Object)"Attempt to load key for invalid revision");
                return null;
            }
            EavEntityCu eav = this.makeEav(revid);
            _Cu revkey = _Cu.alloc();
            eav.getValue(CommonSchema.RevInfo.A_REVKEY, revkey);
            long pathid = revkey.longAt(0);
            String revision = revkey.stringAt(revkey.skipLong(0));
            return new RevInfoKey(new Path(this.stringTables.pathDB.get(pathid)), revision);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private String getStringFromTable(EavEntityCu eav, _Attribute atr, UniqueStringTable table) throws IOException, DbException {
        long pathid = eav.getLong(atr, 0L);
        return table.get(pathid);
    }

    public int insertNew(CommonFileRevisionInput ri, AncestorLink ancestorLink, boolean storeHunks) throws DbException {
        try {
            boolean unmodOnBranch;
            boolean modifiedOnBranch;
            Integer predecessor;
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            int revid = this.allocateNewRevID();
            String branch = ri.getBranch();
            if (ancestorLink != null && ancestorLink.isBranchPoint()) {
                int aid = ancestorLink.getRevid();
                this.addBranchpoints(aid, this.getAncestorOf(aid), Collections.singleton(branch), ri);
            }
            long pathid = this.stringTables.pathDB.add(ri.getPath().getPath());
            long fullpathid = this.addPathId(ri.getPath());
            long dirid = this.addPathId(ri.getPath().getParent());
            long lcfilenameid = this.stringTables.lcfilenameDB.add(ri.getPath().getName().toLowerCase(Locale.US));
            long cmtid = this.stringTables.commentDB.add(ri.getComment());
            EavEntityCu eav = this.makeEav(revid);
            _Cu revkey = _Cu.alloc().append(fullpathid).append(ri.getRevision());
            eav.updateValueIndex(CommonSchema.RevInfoIndexes.I_REVKEY, revkey);
            cu.clear();
            cu.append(CommonSchema.E_PATH_ID_TO_REVID).append(fullpathid).append(revid);
            ((_ItemSpace)db).insert(cu);
            cu.clear();
            cu.append(CommonSchema.E_LCFILENAMEID_TO_REVID).append(lcfilenameid).append(revid);
            ((_ItemSpace)db).insert(cu);
            if (ancestorLink != null) {
                cu.clear();
                cu.append(ancestorLink.getRevid()).append(ancestorLink.getType());
                eav.updateValueIndex(CommonSchema.RevInfoIndexes.I_ANCESTORLINK, cu);
            }
            if ((predecessor = ancestorLink == null || !ancestorLink.isDirect() ? this.findBestPredecessor(revid, fullpathid, branch) : Integer.valueOf(ancestorLink.getRevid())) != null) {
                int preid = predecessor;
                eav.updateInt(CommonSchema.RevInfo.A_PREDECESSOR, preid);
                EavEntityCu preEav = this.makeEav(preid);
                preEav.updateInt(CommonSchema.RevInfo.A_SUCCESSOR, revid);
            }
            this.insertAuthor(revid, ri.getAuthor());
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_DATE, ri.getDate());
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_DATE_END, Long.MAX_VALUE);
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_COMMENT, cmtid);
            eav.updateString(CommonSchema.RevInfo.A_BRANCH, branch);
            eav.updateLong(CommonSchema.RevInfo.A_FULLDIR, dirid);
            eav.updateLong(CommonSchema.RevInfo.A_PATHID, pathid);
            eav.updateBoolean(CommonSchema.RevInfo.A_ISBINARY, ri.isBinary());
            boolean isAdded = ri.isAdded() && !ri.isDead();
            boolean isDeleted = ri.isDead();
            eav.updateBoolean(CommonSchema.RevInfo.A_ISADDED, isAdded);
            this.updateBooleanIndex(CommonSchema.E_ISADDED_TO_REVID, isAdded, revid);
            eav.updateBoolean(CommonSchema.RevInfo.A_ISDELETED, isDeleted);
            this.updateBooleanIndex(CommonSchema.E_ISDELETED_TO_REVID, isDeleted, revid);
            eav.updateBoolean(CommonSchema.RevInfo.A_ISMOVED, ri.isMove());
            eav.updateBoolean(CommonSchema.RevInfo.A_ISCOPIED, ri.isCopy());
            eav.updateBoolean(CommonSchema.RevInfo.A_ISMODIFY, ri.isModify());
            eav.updateBoolean(CommonSchema.RevInfo.A_ISTRUNKLIKE, ri.isTrunkLike());
            this.updateBooleanIndex(CommonSchema.E_ISTRUNKLIKE_TO_REVID, ri.isTrunkLike(), revid);
            eav.updateInt(CommonSchema.RevInfo.A_FILETYPE, ri.getFileType());
            cu.clear();
            if (ri.isBinary()) {
                if (predecessor != null) {
                    cu.append(0L).append(0L).append(this.getLineCount(predecessor));
                } else {
                    cu.append(0L).append(0L).append(ri.getLinesRemoved());
                }
            } else {
                cu.append(ri.getLineCount()).append(ri.getLinesAdded()).append(ri.getLinesRemoved());
            }
            eav.updateValue(CommonSchema.RevInfo.A_LINEDATA, cu);
            String csid = ri.getChangeSetId();
            if (csid != null) {
                eav.updateStringIndex(CommonSchema.RevInfoIndexes.I_CSID, csid);
            }
            cu.clear();
            cu.append(CommonSchema.E_FULLDIR_TO_REVID);
            cu.append(dirid).append(revid);
            ((_ItemSpace)db).insert(cu);
            this.updateParentPaths(ri, revid);
            CommonDirInfoDAO diDao = new CommonDirInfoDAO(this.dbh, this.stringTables, this.caseSensitive);
            if (ri.getFileType() == 1) {
                diDao.addFileToParent(ri.getPath());
            } else if (ri.getFileType() == 2) {
                diDao.addDirToParent(ri.getPath());
            }
            if (this.svnMode) {
                if (ancestorLink != null && ancestorLink.isBranchPoint() && !ri.isModify()) {
                    modifiedOnBranch = false;
                    unmodOnBranch = true;
                } else {
                    modifiedOnBranch = true;
                    unmodOnBranch = false;
                }
            } else {
                modifiedOnBranch = true;
                unmodOnBranch = false;
            }
            if (modifiedOnBranch) {
                cu.clear().append(CommonSchema.E_MOD_ON_BRANCH_TO_REVID);
                cu.append(branch).append(revid);
                ((_ItemSpace)db).insert(cu);
            } else if (unmodOnBranch) {
                cu.clear().append(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID);
                cu.append(branch).append(revid);
                ((_ItemSpace)db).insert(cu);
            }
            this.updateBranchHead(revid, ancestorLink, predecessor, branch);
            boolean isAddedOnBranch = ancestorLink != null ? (this.svnMode ? isAdded && ancestorLink.isDirect() : isAdded) : isAdded;
            if (isAddedOnBranch) {
                this.copyBranchWithXBackward(CommonSchema.E_BRANCH_WITH_ADDS_TO_REVID, revid, branch);
            }
            if (isDeleted) {
                this.copyBranchWithXBackward(CommonSchema.E_BRANCH_WITH_DELETES_TO_REVID, revid, branch);
            }
            this.updateExtantDate(predecessor, ancestorLink, branch, ri.getDate());
            if (predecessor != null) {
                int aid = predecessor;
                this.copyBranchWithXForward(CommonSchema.E_BRANCH_WITH_ADDS_TO_REVID, revid, aid, branch);
                this.copyBranchWithXForward(CommonSchema.E_BRANCH_WITH_DELETES_TO_REVID, revid, aid, branch);
            }
            this.insertIntoBucketData(ri, ri.getBranch(), false, ri.getAuthor());
            if (storeHunks) {
                this.setHunks(revid, ri.getHunks());
            }
            return revid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setHunks(int revid, List<Hunk> hunks) throws IOException, DbException {
        if (hunks != null) {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            for (int index = 0; index < hunks.size(); index += 50) {
                int endIndex = Math.min(hunks.size(), index + 50);
                List<Hunk> subList = hunks.subList(index, endIndex);
                cu.clear().append(CommonSchema.E_DIFFHUNKS).append(revid).append(subList.size());
                for (Hunk hunk : subList) {
                    cu.append(hunk.getFrom()).append(hunk.getFromCount()).append(hunk.getTo()).append(hunk.getToCount());
                }
                ((_ItemSpace)db).insert(cu);
            }
        }
    }

    public List<Hunk> getHunks(int revid) throws DbException {
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        try {
            cu.append(CommonSchema.E_DIFFHUNKS).append(revid);
            int pk = cu.length();
            while (((_ItemSpace)db).next(cu, pk)) {
                int length = (int)cu.longAt(pk);
                int offset = cu.skipLong(pk);
                for (int i2 = 0; i2 < length; ++i2) {
                    int from = (int)cu.longAt(offset);
                    offset = cu.skipLong(offset);
                    int fromCount = (int)cu.longAt(offset);
                    offset = cu.skipLong(offset);
                    int to = (int)cu.longAt(offset);
                    offset = cu.skipLong(offset);
                    int toCount = (int)cu.longAt(offset);
                    offset = cu.skipLong(offset);
                    Hunk hunk = new Hunk(from, to, fromCount, toCount);
                    hunks.add(hunk);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return hunks;
    }

    private void updateBucketData(CommonFileRevision ri, int linecountAdjustment) throws DbException {
        this.updateBucketData(ri.getPath(), ri.getBranch(), new Date(ri.getDate()), linecountAdjustment, ri.getAuthor(), ri.isTrunkLike());
    }

    private void insertIntoBucketData(CommonFileRevisionInput ri, String branch, boolean branchPoint, String commitAuthor) throws DbException {
        Date date = new Date(ri.getDate());
        if (branchPoint) {
            this.insertIntoBucketData(ri.getPath(), branch, date, ri.getLineCount(), commitAuthor, false);
        } else {
            int linecount = ri.getLinesAdded() - ri.getLinesRemoved();
            this.insertIntoBucketData(ri.getPath(), branch, date, linecount, commitAuthor, ri.isTrunkLike());
        }
    }

    private void insertIntoBucketData(Path path, String branch, Date date, int lineChange, String commitAuthor, boolean isTrunklike) throws DbException {
        this.getBucketGraph().addRevision(path, branch, date, lineChange, commitAuthor, isTrunklike);
    }

    private void updateBucketData(Path path, String branch, Date date, int lineChange, String commitAuthor, boolean isTrunklike) throws DbException {
        this.getBucketGraph().updateRevision(path, branch, date, lineChange, commitAuthor, isTrunklike);
    }

    private EavEntityCu getUpdateEAV(RevInfoKey key) throws DbException {
        try {
            int revid = this.getRevId(key);
            if (revid == -1) {
                throw new DbException("Unable to update revision " + key + " because it is not currently in the database");
            }
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Unable to update revision " + key + " because it does not exist");
            }
            return eav;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateAuthor(RevInfoKey key, String newAuthor) throws DbException {
        try {
            EavEntityCu eav = this.getUpdateEAV(key);
            String oldAuthor = eav.getString(CommonSchema.RevInfo.A_AUTHOR, null);
            int revid = (int)eav.getPk().longAt(0);
            this.updateAuthorField(revid, oldAuthor, newAuthor);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateAuthorField(int revid, String oldAuthor, String newAuthor) throws DbException {
        if (oldAuthor == null) {
            oldAuthor = DEFAULT_AUTHOR;
        }
        if (newAuthor == null) {
            newAuthor = DEFAULT_AUTHOR;
        }
        if (oldAuthor.equals(newAuthor)) {
            return;
        }
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
            cu.append(CommonSchema.RevInfo.A_AUTHOR);
            int len = cu.length();
            cu.append(newAuthor);
            ((_ItemSpace)db).update(cu, len);
            cu.clear();
            cu.append(CommonSchema.E_AUTHOR_TO_REVID);
            cu.append(oldAuthor.toLowerCase(Locale.US));
            cu.append(revid);
            ((_ItemSpace)db).delete(cu);
            cu.clear();
            cu.append(CommonSchema.E_AUTHOR_TO_REVID);
            cu.append(newAuthor.toLowerCase(Locale.US));
            cu.append(revid);
            ((_ItemSpace)db).insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateComment(RevInfoKey key, String newComment) throws DbException {
        try {
            EavEntityCu eav = this.getUpdateEAV(key);
            long cmtid = this.stringTables.commentDB.add(newComment);
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_COMMENT, cmtid);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateLineCount(RevInfoKey key, CommonFileRevision revInfo, int lineCount, int linesAdded, int linesRemoved) throws DbException {
        try {
            EavEntityCu eav = this.getUpdateEAV(key);
            _Cu cu = _Cu.alloc();
            cu.append(lineCount).append(linesAdded).append(linesRemoved);
            eav.updateValue(CommonSchema.RevInfo.A_LINEDATA, cu);
            this.updateBucketData(revInfo, linesAdded - linesRemoved - (revInfo.getLinesAdded() - revInfo.getLinesRemoved()));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateDate(RevInfoKey key, long newDate) throws DbException {
        try {
            EavEntityCu eav = this.getUpdateEAV(key);
            int revid = (int)eav.getPk().longAt(0);
            eav.updateLongIndex(CommonSchema.RevInfoIndexes.I_DATE, newDate);
            AncestorLink ancestorLink = this.getAncestorOf(revid);
            Integer predecessor = this.getPredecessorOf(revid);
            String branch = eav.getString(CommonSchema.RevInfo.A_BRANCH, null);
            this.updateExtantDate(predecessor, ancestorLink, branch, newDate);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateCSID(int revid, String csid) throws DbException {
        try {
            if (csid != null) {
                EavEntityCu eav = this.makeEav(revid);
                eav.updateStringIndex(CommonSchema.RevInfoIndexes.I_CSID, csid);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateParentPaths(CommonFileRevisionInput ri, int revid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        long fullpathid = this.getPathId(ri.getPath());
        Path path = ri.getPath();
        if (ri.getFileType() != 2) {
            path = path.getParent();
        }
        long date = ri.getDate();
        MinMaxLongRange minmax = new MinMaxLongRange();
        do {
            long parentid = this.addPathId(path);
            cu.clear();
            cu.append(CommonSchema.E_PARENTPATHS_TO_REVID);
            cu.append(parentid).append(revid);
            ((_ItemSpace)db).insert(cu);
            cu.clear();
            cu.append(CommonSchema.E_PARENTPATHS_TO_PATHID);
            cu.append(parentid).append(fullpathid);
            ((_ItemSpace)db).insert(cu);
            cu.clear();
            cu.append(CommonSchema.DirInfo.ENTITY).append(parentid);
            cu.append(CommonSchema.DirInfo.A_SUBTREE_DATERANGE);
            int pl = cu.length();
            if (((_ItemSpace)db).next(cu, pl)) {
                minmax.readFromCursor(cu, pl);
            } else {
                minmax.reset();
            }
            if (!minmax.add(date)) continue;
            cu.setLength(pl);
            minmax.writeToCursor(cu);
            ((_ItemSpace)db).update(cu, pl);
        } while ((path = path.isRoot() ? null : path.getParent()) != null);
    }

    private Integer findBestPredecessor(int revid, long pathid, String branch) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            AndQuery3 q = new AndQuery3();
            q.addClause(new TermQuery3(CommonSchema.E_PATH_ID_TO_REVID, pathid, null));
            OrQuery3 onBranch = new OrQuery3();
            onBranch.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, branch, null));
            onBranch.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, branch, null));
            q.addClause(onBranch);
            _ItemSpace revids = q.asItemSpace((_ItemSpace)db, (LuceneConnection)null);
            _Cu cu2 = _Cu.alloc();
            _Cu cu = _Cu.alloc().appendInfinity();
            while (revids.previous(cu)) {
                int predecessorId = (int)cu.longAt(0);
                if (predecessorId == revid) continue;
                cu2.clear().append(CommonSchema.RevInfo.ENTITY).append(predecessorId);
                cu2.append(CommonSchema.RevInfo.A_SUCCESSOR);
                int pl = cu2.length();
                if (((_ItemSpace)db).next(cu2, pl)) continue;
                return predecessorId;
            }
            return null;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateExtantDate(Integer predecessor, AncestorLink ancestorLink, String branch, long date) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        if (predecessor != null) {
            EavEntityCu aEav = this.makeEav(predecessor);
            aEav.updateLongIndex(CommonSchema.RevInfoIndexes.I_DATE_END, date);
        }
        if (ancestorLink != null && ancestorLink.isBranchPoint()) {
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.RevInfo.ENTITY).append(ancestorLink.getRevid());
            cu.append(CommonSchema.RevInfo.A_BRANCH_POINT_EXTENT);
            cu.append(branch);
            int pl = cu.length();
            cu.append(date);
            ((_ItemSpace)db).update(cu, pl);
        }
    }

    private void insertAuthor(int revid, String author) throws IOException, DbException {
        if (author == null) {
            author = DEFAULT_AUTHOR;
        }
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
        cu.append(CommonSchema.RevInfo.A_AUTHOR).append(author);
        ((_ItemSpace)db).insert(cu);
        cu.clear();
        cu.append(CommonSchema.E_AUTHOR_TO_REVID);
        cu.append(author.toLowerCase(Locale.US));
        cu.append(revid);
        ((_ItemSpace)db).insert(cu);
    }

    private void copyBranchWithXBackward(_EntityClass entity, int revid, String branch) throws IOException, DbException {
        _Cu cu = _Cu.alloc();
        while (revid != -1) {
            _k4ui8vIDB db = this.dbh.get();
            cu.clear();
            cu.append(entity).append(branch).append(revid);
            ((_ItemSpace)db).insert(cu);
            Integer preid = this.getPredecessorOf(revid);
            if (preid == null) break;
            revid = preid;
        }
    }

    public String getBranchOf(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            return eav.getString(CommonSchema.RevInfo.A_BRANCH, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public AncestorLink getAncestorOf(int revid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
        cu.append(CommonSchema.RevInfo.A_ANCESTOR_LINK);
        int pl = cu.length();
        if (((_ItemSpace)db).next(cu, pl)) {
            return AncestorLink.fromCu(cu, pl);
        }
        return null;
    }

    public Integer getPredecessorOf(int revid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
        cu.append(CommonSchema.RevInfo.A_PREDECESSOR);
        int pl = cu.length();
        if (((_ItemSpace)db).next(cu, pl)) {
            int preid = (int)cu.longAt(pl);
            return preid;
        }
        return null;
    }

    private void copyBranchWithXForward(_EntityClass entity, int revid, int aid, String branch) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        cu.append(entity).append(branch).append(aid);
        if (db.exists(cu)) {
            cu.clear();
            cu.append(entity).append(branch).append(revid);
            ((_ItemSpace)db).insert(cu);
        }
    }

    public void addBranchpoints(int revid, AncestorLink ancestorLink, Collection branchpoints, CommonFileRevisionInput ri) throws DbException {
        try {
            Integer predecessor = this.getPredecessorOf(revid);
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            _Cu cu2 = _Cu.alloc();
            cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
            cu.append(CommonSchema.RevInfo.A_BRANCH_POINTS);
            int pl = cu.length();
            for (String bp : branchpoints) {
                cu.setLength(pl);
                cu.append(bp);
                if (db.exists(cu)) continue;
                ((_ItemSpace)db).insert(cu);
                cu2.clear();
                cu2.append(CommonSchema.RevInfo.ENTITY).append(revid);
                cu2.append(CommonSchema.RevInfo.A_BRANCH_POINT_EXTENT);
                cu2.append(bp).append(Long.MAX_VALUE);
                ((_ItemSpace)db).insert(cu2);
                if (!this.svnMode) {
                    cu2.clear();
                    cu2.append(CommonSchema.E_BP_ON_BRANCH_TO_REVID).append(bp);
                    cu2.append(revid);
                    ((_ItemSpace)db).insert(cu2);
                    this.updateBranchHead(revid, ancestorLink, predecessor, bp);
                }
                if (!this.cvsMode) continue;
                this.insertIntoBucketData(ri, bp, true, ri.getAuthor());
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateBranchHead(int revid, AncestorLink ancestorLink, Integer predecessor, String branch) throws IOException, DbException {
        if (predecessor != null) {
            this.deleteBranchHeadInfo(predecessor, branch);
        }
        if (ancestorLink != null && (ancestorLink.isDirect() || ancestorLink.isBranchPoint())) {
            boolean alreadyDone;
            int aid = ancestorLink.getRevid();
            boolean bl = alreadyDone = predecessor != null && aid == predecessor;
            if (!alreadyDone) {
                this.deleteBranchHeadInfo(aid, branch);
            }
        }
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID);
        cu.append(branch);
        cu.append(revid);
        ((_ItemSpace)db).insert(cu);
        cu.clear().append(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).append(revid);
        ((_ItemSpace)db).insert(cu);
    }

    private void deleteBranchHeadInfo(int revid, String branch) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID);
        cu.append(branch);
        cu.append(revid);
        if (db.exists(cu)) {
            ((_ItemSpace)db).delete(cu);
            if (!this.isHeadInAnyBranch(revid)) {
                cu.clear().append(CommonSchema.E_HEAD_IN_ANY_BRANCH_REVIDS).append(revid);
                ((_ItemSpace)db).delete(cu);
            }
        }
    }

    private boolean isHeadInAnyBranch(int revid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        _Cu cu = _Cu.alloc();
        _Cu cu2 = _Cu.alloc();
        cu.append(CommonSchema.RevInfo.ENTITY).append(revid).append(CommonSchema.RevInfo.A_BRANCH);
        int cupl = cu.length();
        if (((_ItemSpace)db).next(cu, cupl)) {
            String br = cu.stringAt(cupl);
            cu2.clear().append(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).append(br).append(revid);
            if (db.exists(cu2)) {
                return true;
            }
        }
        cu.clear();
        cu.append(CommonSchema.RevInfo.ENTITY).append(revid).append(CommonSchema.RevInfo.A_BRANCH_POINTS);
        cupl = cu.length();
        while (((_ItemSpace)db).next(cu, cupl)) {
            String pb = cu.stringAt(cupl);
            cu2.clear().append(CommonSchema.E_HEAD_IN_BRANCH_TO_REVID).append(pb).append(revid);
            if (!db.exists(cu2)) continue;
            return true;
        }
        return false;
    }

    private void updateBooleanIndex(_EntityClass idx, boolean val, int revid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        if (val) {
            _Cu cu = _Cu.alloc();
            cu.append(idx).append(revid);
            ((_ItemSpace)db).insert(cu);
        }
    }

    public void addTagData(int revid, String tag) throws DbException {
        _k4ui8vIDB db = this.dbh.get();
        try {
            long tagid = this.stringTables.tagDB.add(tag);
            _Cu cu = _Cu.alloc();
            cu.clear();
            cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
            cu.append(CommonSchema.RevInfo.A_TAGS).append(tagid);
            ((_ItemSpace)db).insert(cu);
            cu.clear().append(CommonSchema.E_TAG_TO_REVID).append(tagid).append(revid);
            ((_ItemSpace)db).insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeTagData(int revid, String tag) throws DbException {
        _k4ui8vIDB db = this.dbh.get();
        try {
            long tagid = this.stringTables.tagDB.add(tag);
            _Cu cu = _Cu.alloc();
            cu.clear().append(CommonSchema.E_TAG_TO_REVID).append(tagid).append(revid);
            ((_ItemSpace)db).delete(cu);
            cu.clear();
            cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
            cu.append(CommonSchema.RevInfo.A_TAGS).append(tagid);
            ((_ItemSpace)db).delete(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeTag(String tag) throws DbException {
        _k4ui8vIDB db = this.dbh.get();
        try {
            long tagid = this.stringTables.tagDB.find(tag);
            if (tagid == -1L) {
                return;
            }
            _Cu cu = _Cu.alloc();
            cu.append(CommonSchema.E_TAG_TO_REVID).append(tagid);
            int pl = cu.length();
            _Cu cu2 = _Cu.alloc();
            while (((_ItemSpace)db).next(cu, pl)) {
                int revid = (int)cu.longAt(pl);
                cu2.clear().append(CommonSchema.RevInfo.ENTITY).append(revid);
                cu2.append(CommonSchema.RevInfo.A_TAGS).append(tagid);
                ((_ItemSpace)db).delete(cu2);
                ((_ItemSpace)db).delete(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateTagData(int revid, Collection tags) throws DbException {
        try {
            long tagid;
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            TLongHashSet tagids = new TLongHashSet();
            for (String tag : tags) {
                tagid = this.stringTables.tagDB.add(tag);
                tagids.add(tagid);
                cu.clear();
                cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
                cu.append(CommonSchema.RevInfo.A_TAGS).append(tagid);
                if (db.exists(cu)) continue;
                ((_ItemSpace)db).insert(cu);
                cu.clear().append(CommonSchema.E_TAG_TO_REVID).append(tagid).append(revid);
                ((_ItemSpace)db).insert(cu);
            }
            _Cu cu2 = _Cu.alloc();
            cu.clear();
            cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
            cu.append(CommonSchema.RevInfo.A_TAGS);
            int pl = cu.length();
            while (((_ItemSpace)db).next(cu, pl)) {
                tagid = cu.longAt(pl);
                if (tagids.contains(tagid)) continue;
                ((_ItemSpace)db).delete(cu);
                cu2.clear().append(CommonSchema.E_TAG_TO_REVID).append(tagid).append(revid);
                ((_ItemSpace)db).delete(cu2);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public EavEntityCu makeEav(int revid) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        return new EavEntityCu((_ItemSpace)db, CommonSchema.RevInfo.ENTITY, revid);
    }

    private int allocateNewRevID() throws IOException, DbException {
        _Cu cu = _Cu.alloc();
        cu.append(CommonSchema.RevInfo.ENTITY);
        int id = this.allocateId(cu);
        cu.clear().append(CommonSchema.RevInfo.ENTITY).append(id);
        _k4ui8vIDB db = this.dbh.get();
        ((_ItemSpace)db).insert(cu);
        return id;
    }

    private int allocateId(_Cu cu) throws DbException, IOException {
        _k4ui8vIDB db = this.dbh.get();
        int p1 = cu.length();
        cu.appendInfinity();
        long id = ((_ItemSpace)db).previous(cu, p1) ? cu.longAt(p1) + 1L : 1L;
        return (int)id;
    }

    public void addRevidLongIndex(_EntityClass entityClass, long indexValue, int revid) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            ((_ItemSpace)db).insert(_Cu.alloc().append(entityClass).append(indexValue).append(revid));
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedIntSet getRevidsInLongIndexRange(_EntityClass entityClass, long fromValue, long toValue) throws DbException {
        try {
            long value;
            _k4ui8vIDB db = this.dbh.get();
            SegmentedIntSet result = new SegmentedIntSet();
            _Cu cu = _Cu.alloc().append(entityClass);
            int keyLength = cu.length();
            cu.append(fromValue);
            while (((_ItemSpace)db).next(cu, keyLength) && (value = cu.longAt(keyLength)) <= toValue) {
                int revid = (int)cu.longAt(cu.skipLong(keyLength));
                result.set(revid);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public TLongHashSet getLongIndexKeyRange(_EntityClass entityClass, long fromValue, long toValue) throws DbException {
        try {
            long value;
            _k4ui8vIDB db = this.dbh.get();
            TLongHashSet result = new TLongHashSet();
            _Cu cu = _Cu.alloc().append(entityClass);
            int keyLength = cu.length();
            cu.append(fromValue);
            while (((_ItemSpace)db).next(cu, keyLength) && (value = cu.longAt(keyLength)) <= toValue) {
                result.add(value);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public TIntArrayList getIndexedRevIds(_EntityClass entityClass, long indexValue) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            TIntArrayList result = new TIntArrayList();
            _Cu index = _Cu.alloc().append(entityClass).append(indexValue);
            int pl = index.length();
            while (((_ItemSpace)db).next(index, pl)) {
                int revid = (int)index.longAt(pl);
                result.add(revid);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addPathLongProperty(_EntityClass entityClass, Path path, long value) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long pathId = this.getPathId(path);
            if (pathId == -1L) {
                throw new DbException("Unable to find path " + path + ", not in database");
            }
            _Cu cu = _Cu.alloc().append(entityClass);
            cu.append(pathId).append(value);
            ((_ItemSpace)db).insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getPathLargestProperty(_EntityClass entityClass, Path path, long limitValue, long defaultValue) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long value = defaultValue;
            long pathId = this.getPathId(path);
            if (pathId != -1L) {
                _Cu pathIndex = _Cu.alloc().append(entityClass).append(pathId);
                int pl = pathIndex.length();
                if (limitValue != -1L) {
                    pathIndex.append(limitValue + 1L);
                } else {
                    pathIndex.appendInfinity();
                }
                if (((_ItemSpace)db).previous(pathIndex, pl)) {
                    value = pathIndex.longAt(pl);
                }
            }
            return value;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addRevIdLongProperty(_EntityClass propertyClass, int revid, long value) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc().append(propertyClass);
            cu.append(revid).append(value);
            ((_ItemSpace)db).insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getLongProperty(_EntityClass propertyClass, int revid, long defaultValue) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            int length = cu.clear().append(propertyClass).append(revid).length();
            long value = defaultValue;
            if (((_ItemSpace)db).next(cu, length)) {
                value = cu.longAt(length);
            }
            return value;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedIntSet getLongProperySet(_EntityClass propertyClass, SortedIntSet revids) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            SegmentedIntSet result = new SegmentedIntSet();
            _Cu cu = _Cu.alloc();
            int revid = revids.nextSetBit(0);
            while (revid >= 0) {
                int length = cu.clear().append(propertyClass).append(revid).length();
                if (((_ItemSpace)db).next(cu, length)) {
                    long value = cu.longAt(length);
                    result.set((int)value);
                }
                revid = revids.nextSetBit(revid + 1);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getFileType(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load file type from non existent revid = " + revid);
            }
            return eav.getInt(CommonSchema.RevInfo.A_FILETYPE, 1);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public boolean isDeleted(int revid) throws DbException {
        try {
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load isDeleted from non existent revid = " + revid);
            }
            return eav.getBoolean(CommonSchema.RevInfo.A_ISDELETED, true);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getLineCount(int revid) throws DbException {
        try {
            int lineCount = 0;
            EavEntityCu eav = this.makeEav(revid);
            if (!eav.exists()) {
                throw new DbException("Attempt to load line count from non existent revid = " + revid);
            }
            _Cu cu = _Cu.alloc();
            if (eav.getValue(CommonSchema.RevInfo.A_LINEDATA, cu)) {
                int pl = 0;
                lineCount = (int)cu.longAt(pl);
            }
            return lineCount;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitRevisionTree(Path path, _EntityClass selectorClass, long selectorValue, DirectoryTreeVisitor v) throws DbException {
        try {
            long fileId;
            _k4ui8vIDB db = this.dbh.get();
            _ItemSubspace pathids = null;
            long dirId = this.getPathId(path);
            if (dirId != -1L) {
                pathids = new _ItemSubspace(db, _Cu.alloc().append(CommonSchema.E_PARENTPATHS_TO_PATHID).append(dirId));
                this.visitDirectoryTree(pathids, selectorClass, selectorValue, v);
            }
            if ((fileId = this.getPathId(path)) != -1L) {
                boolean alreadyVisited;
                _Cu cu = _Cu.alloc().append(fileId);
                boolean bl = alreadyVisited = pathids != null && pathids.exists(cu);
                if (!alreadyVisited) {
                    this.visitPathInTree(cu, fileId, selectorClass, selectorValue, v);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void visitDirectoryTree(_ItemSpace pathids, _EntityClass selectorClass, long selectorValue, DirectoryTreeVisitor v) throws IOException, DbException {
        _Cu cu = _Cu.alloc();
        _Cu cu2 = _Cu.alloc();
        while (pathids.next(cu)) {
            long pathId = cu.longAt(0);
            this.visitPathInTree(cu2, pathId, selectorClass, selectorValue, v);
        }
    }

    private void visitPathInTree(_Cu cu, long pathId, _EntityClass selectorClass, long selectorValue, DirectoryTreeVisitor v) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        cu.clear().append(selectorClass).append(pathId);
        int pl = cu.length();
        cu.append(selectorValue);
        if (((_ItemSpace)db).last(cu, pl)) {
            long csid = cu.longAt(pl);
            v.visit(pathId, csid);
        }
    }

    public SortedMap<Long, Integer> getPathRevisions(Path path) throws DbException {
        _k4ui8vIDB db = this.dbh.get();
        TreeMap<Long, Integer> result = new TreeMap<Long, Integer>();
        try {
            long pathId = this.getPathId(path);
            if (pathId != -1L) {
                _Cu cu = _Cu.alloc();
                cu.append(CommonSchema.E_REVKEY_TO_REVID);
                cu.append(pathId);
                int pl = cu.length();
                while (((_ItemSpace)db).next(cu, pl)) {
                    String revision = cu.stringAt(pl);
                    int revid = (int)cu.longAt(cu.skipString(pl));
                    result.put(Long.valueOf(revision), revid);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public Set getReviewsForRevids(TIntArrayList revids) throws DbException {
        try {
            LinkedHashSet<Integer> reviews = new LinkedHashSet<Integer>();
            _Cu cu = _Cu.alloc();
            _k4ui8vIDB db = this.dbh.get();
            for (int i2 = 0; i2 < revids.size(); ++i2) {
                int revid = revids.get(i2);
                cu.clear().append(CommonSchema.RevInfo.ENTITY).append(revid).append(CommonSchema.RevInfo.A_REVIEWIDS);
                int pl = cu.length();
                while (db.next(cu, pl)) {
                    int reviewid = (int)cu.longAt(pl);
                    reviews.add(reviewid);
                }
            }
            return reviews;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void deleteAttribteOnAllRevisions(_Attribute attr) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _EntityItemSpace revs = new _EntityItemSpace(db, _Cu.alloc(CommonSchema.RevInfo.ENTITY));
            _Cu cu = _Cu.alloc();
            _Cu row = _Cu.alloc();
            while (revs.next(cu)) {
                int revid = (int)cu.longAt(0);
                row.clear().append(CommonSchema.RevInfo.ENTITY).append(revid).append(attr);
                db.deleteSubspace(row);
                db.delete(row);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getPathId(Path path) throws DbException {
        long pathId = this.caseSensitive ? this.stringTables.pathDB.find(path.getPath()) : this.stringTables.pathDB.find(path.getPath().toLowerCase(Locale.US));
        return pathId;
    }

    public long addPathId(Path path) throws DbException {
        long pathId = this.caseSensitive ? this.stringTables.pathDB.add(path.getPath()) : this.stringTables.pathDB.add(path.getPath().toLowerCase(Locale.US));
        return pathId;
    }

    public static interface DirectoryTreeVisitor {
        public void visit(long var1, long var3) throws DbException;
    }
}

