/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.util.HashSet;

public class TagTreeVisitor {
    private final _ItemSpace db;
    private final TIntArrayList pending = new TIntArrayList();

    public TagTreeVisitor(_ItemSpace db) {
        this.db = db;
    }

    public void visitTree(int startid, final boolean skipOthers, final TreeVisitor v) throws DbException {
        try {
            v.visitStart(startid);
            this.visitPredecessors(startid, new AncestorVisitor(){

                public boolean visitAncestor(int ancestorid, int descendantid) throws DbException, IOException {
                    v.visitAncestor(ancestorid, descendantid);
                    if (!skipOthers) {
                        TagTreeVisitor.this.visitDescendents(ancestorid, descendantid, null, v);
                    }
                    return true;
                }
            });
            this.visitDescendents(startid, startid, v, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitDescendents(int startid, DescendentVisitor v) throws DbException {
        try {
            this.visitDescendents(startid, -1, v, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitAncestorDescendents(int startid, AncestorDescendentVisitor v) throws DbException {
        try {
            this.visitAncestorDescendents(startid, -1, v, null);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void visitPredecessors(int startid, AncestorVisitor v) throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            int revid = startid;
            while (true) {
                AncestorLink link;
                cu.clear();
                cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
                cu.append(CommonSchema.RevInfo.A_PREDECESSOR);
                int pl = cu.length();
                if (this.db.next(cu, pl)) {
                    int predecessorId = (int)cu.longAt(pl);
                    boolean cont = v.visitAncestor(predecessorId, revid);
                    if (!cont) {
                        return;
                    }
                    revid = predecessorId;
                    continue;
                }
                cu.clear();
                cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
                cu.append(CommonSchema.RevInfo.A_ANCESTOR_LINK);
                pl = cu.length();
                if (this.db.next(cu, pl) && (link = AncestorLink.fromCu(cu, pl)).isBranchPoint()) {
                    int ancestorId = link.getRevid();
                    boolean cont = v.visitAncestor(ancestorId, revid);
                    if (!cont) {
                        return;
                    }
                    revid = ancestorId;
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int findLastSuccessor(int revid) throws DbException {
        try {
            _Cu cu = _Cu.alloc();
            while (true) {
                cu.clear();
                cu.append(CommonSchema.RevInfo.ENTITY).append(revid);
                cu.append(CommonSchema.RevInfo.A_SUCCESSOR);
                int pl = cu.length();
                if (!this.db.next(cu, pl)) break;
                revid = (int)cu.longAt(pl);
            }
            return revid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void visitDescendents(int startid, int excludeid, DescendentVisitor dv, OtherVisitor ov) throws IOException, DbException {
        this.pending.clear();
        this.pending.add(startid);
        _Cu cu = _Cu.alloc();
        while (!this.pending.isEmpty()) {
            int successor;
            int current = this.pending.remove(this.pending.size() - 1);
            cu.clear();
            cu.append(CommonSchema.RevInfo.ENTITY).append(current);
            cu.append(CommonSchema.RevInfo.A_SUCCESSOR);
            int pl = cu.length();
            if (this.db.next(cu, pl) && excludeid != (successor = (int)cu.longAt(pl))) {
                if (dv != null) {
                    dv.visitDescendent(successor);
                }
                if (ov != null) {
                    ov.visitOther(successor);
                }
                this.pending.add(successor);
            }
            cu.clear();
            cu.append(CommonSchema.E_ANCESTORLINK_TO_REVID);
            cu.append(current);
            pl = cu.length();
            while (this.db.next(cu, pl)) {
                int descendent;
                int type = (int)cu.longAt(pl);
                if (type != 1 || excludeid == (descendent = (int)cu.longAt(cu.skipLong(pl)))) continue;
                if (dv != null) {
                    dv.visitDescendent(descendent);
                }
                if (ov != null) {
                    ov.visitOther(descendent);
                }
                this.pending.add(descendent);
            }
        }
    }

    private void visitAncestorDescendents(int startid, int excludeid, AncestorDescendentVisitor dv, OtherVisitor ov) throws IOException, DbException {
        HashSet<Integer> visitedSet = new HashSet<Integer>();
        this.pending.clear();
        this.pending.add(startid);
        _Cu cu = _Cu.alloc();
        while (!this.pending.isEmpty()) {
            int current = this.pending.remove(this.pending.size() - 1);
            cu.clear();
            cu.append(CommonSchema.E_ANCESTORLINK_TO_REVID);
            cu.append(current);
            int pl = cu.length();
            while (this.db.next(cu, pl)) {
                int type = (int)cu.longAt(pl);
                int descendent = (int)cu.longAt(cu.skipLong(pl));
                if (dv != null) {
                    dv.visitDescendent(current, descendent);
                }
                if (ov != null) {
                    ov.visitOther(descendent);
                }
                this.pending.add(descendent);
            }
            visitedSet.add(current);
            cu.clear();
            cu.append(CommonSchema.RevInfo.ENTITY).append(current).append(CommonSchema.RevInfo.A_PREDECESSOR);
            pl = cu.length();
            if (!this.db.next(cu, pl)) continue;
            int predecessor = (int)cu.longAt(pl);
            dv.visitDescendent(predecessor, current);
            if (this.pending.contains(predecessor) || visitedSet.contains(predecessor)) continue;
            this.visitDirectAncestors(predecessor, dv);
        }
        this.visitDirectAncestors(startid, dv);
    }

    private void visitDirectAncestors(int startid, AncestorDescendentVisitor dv) throws IOException, DbException {
        int id = startid;
        _Cu cu = _Cu.alloc();
        while (true) {
            cu.clear();
            cu.append(CommonSchema.RevInfo.ENTITY).append(id);
            cu.append(CommonSchema.RevInfo.A_ANCESTOR_LINK);
            int pl = cu.length();
            if (!this.db.next(cu, pl)) break;
            AncestorLink link = AncestorLink.fromCu(cu, pl);
            dv.visitDescendent(link.getRevid(), id);
            id = link.getRevid();
        }
        dv.visitDescendent(-1, id);
    }

    public static interface TreeVisitor
    extends AncestorVisitor,
    DescendentVisitor,
    OtherVisitor {
        public void visitStart(int var1) throws DbException, IOException;
    }

    public static interface OtherVisitor {
        public void visitOther(int var1) throws DbException, IOException;
    }

    public static interface AncestorDescendentVisitor {
        public void visitDescendent(int var1, int var2) throws DbException, IOException;
    }

    public static interface DescendentVisitor {
        public void visitDescendent(int var1) throws DbException, IOException;
    }

    public static interface AncestorVisitor {
        public boolean visitAncestor(int var1, int var2) throws DbException, IOException;
    }
}

