/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.ping;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.util.Disposer;

public class RescanRequest
extends PingRequest {
    private String start;
    private String end;

    public RescanRequest(RepositoryHandle handle, String startRev, String endRev) {
        super(handle, 2);
        String repoType = handle.getCfg().getRepositoryType();
        if (!repoType.equals("svn")) {
            throw new UnsupportedOperationException("Rescan is not supported on " + repoType + " repositories");
        }
        this.start = startRev;
        this.end = endRev;
    }

    public boolean canCombine(PingRequest request) {
        boolean canCombine = false;
        if (request.getClass() == this.getClass()) {
            RescanRequest rescanRequest = (RescanRequest)request;
            canCombine = rescanRequest.getStart().equals(this.start) && rescanRequest.getEnd().equals(this.end);
        }
        return canCombine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest() {
        RepositoryHandle handle = this.getHandle();
        if (handle.isRunning()) {
            Disposer.pushThreadInstance();
            try {
                RepositoryEngine eng = handle.acquireEngine();
                eng.rescan(this.start, this.end);
            }
            catch (Throwable e2) {
                Logs.APP_LOG.error((Object)"Exception during rescan", e2);
            }
            finally {
                Disposer.popThreadInstance();
            }
        }
    }

    public String getDescription() {
        return "Rescan from " + this.start + " to " + this.end;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }
}

