/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.db;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.svn.util.ChangePathUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.tigris.subversion.javahl.PropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRevInfo
extends CommonFileRevision
implements CommonFileRevisionInput {
    private long svnRevision;
    private Path logicalPath;
    private Map<String, String> properties = new HashMap<String, String>();
    private boolean annotatable = true;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnRevInfo revInfo = (SvnRevInfo)o;
        if (this.svnRevision != revInfo.svnRevision) {
            return false;
        }
        return this.getPath().equals(revInfo.getPath());
    }

    public int hashCode() {
        int result = (int)(this.svnRevision ^ this.svnRevision >>> 32);
        result = 31 * result + this.getPath().hashCode();
        return result;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
        this.setBinary(this.isBinary());
    }

    public void setProperties(PropertyData[] properties) {
        if (properties != null) {
            for (PropertyData property : properties) {
                this.properties.put(property.getName(), property.getValue());
            }
            this.setBinary(this.isBinary());
        }
    }

    public void setSVNRevision(long revision) {
        this.svnRevision = revision;
        super.setRevision(Long.toString(revision));
    }

    @Override
    public boolean isAnnotatable() {
        return this.annotatable;
    }

    public void setAnnotatable(boolean annotatable) {
        this.annotatable = annotatable;
    }

    @Override
    public void setRevision(String revision) {
        super.setRevision(revision);
        this.svnRevision = Long.parseLong(revision);
    }

    public long getSvnRevision() {
        return this.svnRevision;
    }

    public Path getLogicalPath() {
        return this.logicalPath;
    }

    public void setLogicalPath(Path logicalPath) {
        this.logicalPath = logicalPath;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Collection<String> getPropertyKeys() {
        ArrayList<String> l = new ArrayList<String>(this.properties.keySet());
        Collections.sort(l);
        return l;
    }

    @Override
    public boolean isBinary() {
        String mimeType = this.properties.get("svn:mime-type");
        return ChangePathUtil.isBinaryMimeType(mimeType);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        pw.println("  Revision for item " + this.getPath() + "@" + this.getRevision());
        pw.println("    revid: " + this.getRevID());
        pw.println("    Author: " + this.getAuthor());
        pw.println("    isAdded: " + this.isAdded());
        pw.println("    isDeleted: " + this.isDead());
        pw.println("    isCopy: " + this.isCopy());
        pw.println("    isMove: " + this.isMove());
        pw.println("    Copy Source: " + this.getCopySource());
        pw.println("    Branch: " + this.getBranch());
        pw.println("    AncestorRevision: " + this.getAncestorRevision());
        pw.println("    Date: " + this.getDateValue());
        pw.println("    Branches from here: ");
        for (String branchPoint : this.getBranches()) {
            pw.println("      " + branchPoint);
        }
        pw.println("  ------");
        pw.flush();
        return writer.toString();
    }
}

