/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.db;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.svn.db.SvnSchema;
import com.cenqua.fisheye.svn.db.SvnStringTables;
import com.cenqua.fisheye.util.SortedMultiMap;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idbk4ui8v._AndOrSpace;
import com.cenqua.obfuscate.idbk4ui8v._AndSpace;
import com.cenqua.obfuscate.idbk4ui8v._Cu;
import com.cenqua.obfuscate.idbk4ui8v._EntityClass;
import com.cenqua.obfuscate.idbk4ui8v._ItemSpace;
import com.cenqua.obfuscate.idbk4ui8v._ItemSubspace;
import com.cenqua.obfuscate.idbk4ui8v._k4ui8vIDB;
import gnu.trove.TIntArrayList;
import gnu.trove.TLongHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnRevInfoDAO {
    private SvnStringTables svnStringTables;
    private InfinityDbHandle dbh;
    private CommonStringTables commonStringTables;
    private CommonRevInfoDAO commonDAO;
    private SvnLogicalPathMatcher pathMatcher;

    public SvnRevInfoDAO(InfinityDbHandle dbh, SvnStringTables svnStringTables, CommonStringTables stringTables, SvnLogicalPathMatcher pathMatcher) {
        this.dbh = dbh;
        this.svnStringTables = svnStringTables;
        this.commonStringTables = stringTables;
        this.pathMatcher = pathMatcher;
        this.commonDAO = new CommonRevInfoDAO(dbh, stringTables, true, true, false);
    }

    public CommonRevInfoDAO getCommonRevInfoDAO() {
        return this.commonDAO;
    }

    public int insertNew(SvnRevInfo revision, AncestorLink ancestorLink, boolean storeDiffs) throws DbException {
        int revid = this.commonDAO.insertNew(revision, ancestorLink, storeDiffs);
        this.storeSvnProperties(revid, revision);
        this.commonDAO.addRevidLongIndex(SvnSchema.I_CHANGESETID_REVID, revision.getSvnRevision(), revid);
        this.commonDAO.addPathLongProperty(SvnSchema.I_PATHID_CHANGESETID, revision.getPath(), revision.getSvnRevision());
        long pathId = this.commonDAO.getPathId(revision.getPath());
        this.commonDAO.addRevIdLongProperty(SvnSchema.I_REVID_TO_PATHID, revid, pathId);
        if (revision.getLogicalPath() != null) {
            this.updateLogicalPathInfo(revision, revid);
        }
        return revid;
    }

    private void storeSvnProperties(int revid, SvnRevInfo revision) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            Map<String, String> revisionProperties = revision.getProperties();
            for (Map.Entry<String, String> entry : revisionProperties.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                long keyId = this.svnStringTables.propertyKeyDB.add(key);
                long valueId = this.svnStringTables.propertyValueDB.add(value);
                _Cu cu = _Cu.alloc().append(SvnSchema.E_PROPERTIES);
                cu.append(revid).append(keyId);
                int pl = cu.length();
                cu.append(valueId);
                ((_ItemSpace)db).update(cu, pl);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void storeTagRevision(String tag, Path tagPath, long taggingRevNumber, Path taggedPath, long taggedRevNumber) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long tagPathId = this.svnStringTables.tagPathDB.add(tagPath.getPath());
            _Cu cu = _Cu.alloc().append(SvnSchema.I_TAGPATHID_CHANGESETID);
            cu.append(tagPathId).append(taggingRevNumber);
            ((_ItemSpace)db).insert(cu);
            cu.clear();
            cu.append(SvnSchema.I_TAGGEDPATHID_TAGGEDCHANGESET_TAGGINGCHANGESET);
            long taggedPathId = this.commonStringTables.pathDB.find(taggedPath.getPath());
            long tagId = this.commonStringTables.tagDB.find(tag);
            cu.append(taggedPathId).append(tagId).append(taggedRevNumber).append(taggingRevNumber);
            ((_ItemSpace)db).insert(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long getTaggingChangeSet(String tag, Path path, long taggedChangeset) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            long result = -1L;
            long taggedPathId = this.commonStringTables.pathDB.find(path.getPath());
            long tagId = this.commonStringTables.tagDB.find(tag);
            _Cu cu = _Cu.alloc().append(SvnSchema.I_TAGGEDPATHID_TAGGEDCHANGESET_TAGGINGCHANGESET);
            cu.append(taggedPathId).append(tagId).append(taggedChangeset);
            int keyLength = cu.length();
            if (((_ItemSpace)db).next(cu, keyLength)) {
                result = cu.longAt(keyLength);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateLogicalPathInfo(SvnRevInfo revision, int revid) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            Path logicalPath = revision.getLogicalPath();
            long logicalPathId = this.svnStringTables.logicalPathDB.add(logicalPath.getPath());
            _Cu cu = _Cu.alloc().append(SvnSchema.I_LOGICALPATHID_CSID_REVID);
            cu.append(logicalPathId).append(revision.getSvnRevision()).append(revid);
            ((_ItemSpace)db).insert(cu);
            cu.clear().append(SvnSchema.I_LOGICALPATHID_REVID);
            cu.append(logicalPathId).append(revid);
            ((_ItemSpace)db).insert(cu);
            long parentDirId = this.svnStringTables.logicalPathDB.add(logicalPath.getParent().getPath());
            cu.clear().append(SvnSchema.I_LOGICALDIRID_REVID);
            cu.append(parentDirId).append(revid);
            ((_ItemSpace)db).insert(cu);
            ((_ItemSpace)db).insert(cu.clear().append(SvnSchema.I_LOGICALPARENTPATHS_TO_REVID).append(logicalPathId).append(revid));
            if (!logicalPath.isRoot()) {
                Path parent = logicalPath.getParent();
                long parentPathId = this.svnStringTables.logicalPathDB.add(parent.getPath());
                cu.clear().append(SvnSchema.I_LOGICALDIR_FILETYPE_REVID);
                cu.append(parentPathId).append(revision.getFileType()).append(revid);
                ((_ItemSpace)db).insert(cu);
                parent = logicalPath;
                do {
                    parent = parent.getParent();
                    long parentid = this.svnStringTables.logicalPathDB.add(parent.getPath());
                    cu.clear().append(SvnSchema.I_LOGICALPARENTPATHS_TO_REVID);
                    cu.append(parentid).append(revid);
                    ((_ItemSpace)db).insert(cu);
                } while (!parent.isRoot());
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedMultiMap getLogicalPathRevisions(Path logicalPath) throws DbException {
        SortedMultiMap<Long, Integer> result = new SortedMultiMap<Long, Integer>();
        try {
            _k4ui8vIDB db = this.dbh.get();
            long logicalPathId = this.svnStringTables.logicalPathDB.find(logicalPath.getPath());
            if (logicalPathId != -1L) {
                _Cu cu = _Cu.alloc();
                cu.append(SvnSchema.I_LOGICALPATHID_CSID_REVID);
                cu.append(logicalPathId);
                int pl = cu.length();
                while (((_ItemSpace)db).next(cu, pl)) {
                    long csid = cu.longAt(pl);
                    int revid = (int)cu.longAt(cu.skipLong(pl));
                    result.add(csid, revid);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public List<Integer> getTaggedDirEntries(Path logicalDir, int filetype, String tag, long changesetLimit) throws DbException {
        ArrayList<Integer> revids;
        block4: {
            revids = new ArrayList<Integer>();
            try {
                _k4ui8vIDB db = this.dbh.get();
                long logicalDirId = this.svnStringTables.logicalPathDB.find(logicalDir.getPath());
                long tagId = this.commonStringTables.tagDB.find(tag);
                if (logicalDirId == -1L || tagId == -1L) break block4;
                _Cu cu1 = _Cu.alloc().append(SvnSchema.I_LOGICALDIR_FILETYPE_REVID).append(logicalDirId).append(filetype);
                _ItemSubspace logicalRevids = new _ItemSubspace(db, cu1);
                _Cu cu2 = _Cu.alloc().append(CommonSchema.E_TAG_TO_REVID).append(tagId);
                _ItemSubspace taggedRevids = new _ItemSubspace(db, cu2);
                _AndOrSpace andSpace = new _AndSpace().add(logicalRevids).add(taggedRevids);
                _Cu cu = _Cu.alloc();
                while (andSpace.next(cu)) {
                    int revid = (int)cu.longAt(0);
                    RevInfoKey key = this.getKey(revid);
                    long changeset = Long.parseLong(key.getRev());
                    if (changesetLimit == -1L || changeset < changesetLimit) {
                        revids.add(revid);
                    }
                    if (changesetLimit == -1L || changeset < changesetLimit) continue;
                    break;
                }
            }
            catch (IOException e2) {
                throw new DbException(e2);
            }
        }
        return revids;
    }

    private void visitTaggedTree(Path physicalPath, long changesetLimit, CommonRevInfoDAO.DirectoryTreeVisitor visitor) throws DbException {
        long tagCSID;
        String tag = this.pathMatcher.getTag(physicalPath);
        Path logicalPath = this.pathMatcher.getLogicalPath(physicalPath);
        Path tagRoot = this.pathMatcher.getTagRoot(physicalPath);
        int tagRootRevid = this.getRevId(tagRoot, tagCSID = this.getLatestPathChangeUpto(tagRoot, changesetLimit));
        if (tagRootRevid == -1) {
            return;
        }
        RevInfoKey tagRootKey = this.getKey(tagRootRevid);
        long tagRootCSID = Long.parseLong(tagRootKey.getRev());
        try {
            _k4ui8vIDB db = this.dbh.get();
            long logicalPathId = this.svnStringTables.logicalPathDB.find(logicalPath.getPath());
            long tagId = this.commonStringTables.tagDB.find(tag);
            if (logicalPathId != -1L && tagId != -1L) {
                _Cu cu1 = _Cu.alloc().append(SvnSchema.I_LOGICALPARENTPATHS_TO_REVID).append(logicalPathId);
                _ItemSubspace treeRevids = new _ItemSubspace(db, cu1);
                _Cu cu2 = _Cu.alloc().append(CommonSchema.E_TAG_TO_REVID).append(tagId);
                _ItemSubspace taggedRevids = new _ItemSubspace(db, cu2);
                _AndOrSpace andSpace = new _AndSpace().add(treeRevids).add(taggedRevids);
                _Cu cu = _Cu.alloc();
                while (andSpace.next(cu)) {
                    int revid = (int)cu.longAt(0);
                    RevInfoKey key = this.getKey(revid);
                    long changeset = Long.parseLong(key.getRev());
                    if (changesetLimit != -1L && changeset > changesetLimit) continue;
                    Path realPath = key.getPath();
                    Path realLogicalPath = this.pathMatcher.getLogicalTail(realPath);
                    Path rebased = new Path(tagRoot, realLogicalPath);
                    long rebasedPathId = this.commonStringTables.pathDB.add(rebased.getPath());
                    long latest = this.getLatestPathUpTo(this.commonStringTables.pathDB, SvnSchema.I_PATHID_CHANGESETID, rebased, changesetLimit);
                    if (latest != -1L) {
                        if (latest != changeset) continue;
                        visitor.visit(rebasedPathId, changeset);
                        continue;
                    }
                    visitor.visit(rebasedPathId, tagRootCSID);
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getTaggedPathRevid(Path logicalPath, String tag, long changesetLimit) throws DbException {
        int result = -1;
        try {
            _k4ui8vIDB db = this.dbh.get();
            long logicalPathId = this.svnStringTables.logicalPathDB.find(logicalPath.getPath());
            long tagId = this.commonStringTables.tagDB.find(tag);
            if (logicalPathId != -1L && tagId != -1L) {
                _Cu cu1 = _Cu.alloc().append(SvnSchema.I_LOGICALPATHID_REVID).append(logicalPathId);
                _ItemSubspace logicalRevids = new _ItemSubspace(db, cu1);
                _Cu cu2 = _Cu.alloc().append(CommonSchema.E_TAG_TO_REVID).append(tagId);
                _ItemSubspace taggedRevids = new _ItemSubspace(db, cu2);
                _AndOrSpace andSpace = new _AndSpace().add(logicalRevids).add(taggedRevids);
                _Cu cu = _Cu.alloc();
                while (andSpace.next(cu)) {
                    int revid = (int)cu.longAt(0);
                    RevInfoKey key = this.getKey(revid);
                    long taggedChangeset = Long.parseLong(key.getRev());
                    long taggingChangeset = this.getTaggingChangeSet(tag, key.getPath(), taggedChangeset);
                    if (taggingChangeset == -1L) {
                        taggingChangeset = taggedChangeset;
                    }
                    if (changesetLimit != -1L && taggingChangeset > changesetLimit) continue;
                    result = revid;
                }
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return result;
    }

    public long getLatestPathChangeUpto(Path physicalPath, long limitRevision) throws DbException {
        try {
            long tagcsid;
            long csid = this.getLatestPathUpTo(this.commonStringTables.pathDB, SvnSchema.I_PATHID_CHANGESETID, physicalPath, limitRevision);
            if (this.pathMatcher.getContainerId(physicalPath).startsWith("tag:") && (tagcsid = this.getLatestPathUpTo(this.svnStringTables.tagPathDB, SvnSchema.I_TAGPATHID_CHANGESETID, physicalPath, limitRevision)) > csid) {
                csid = tagcsid;
            }
            return csid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public long getLatestLogicalPathChangeUpto(Path logicalPath, long limitRevision) throws DbException {
        try {
            return this.getLatestPathUpTo(this.svnStringTables.logicalPathDB, SvnSchema.I_LOGICALPATHID_CSID_REVID, logicalPath, limitRevision);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long getLatestPathUpTo(UniqueStringTable pathTable, _EntityClass pathIndexTable, Path path, long limitRevision) throws IOException, DbException {
        _k4ui8vIDB db = this.dbh.get();
        long csid = -1L;
        long pathId = pathTable.find(path.getPath());
        if (pathId != -1L) {
            _Cu pathIndex = _Cu.alloc().append(pathIndexTable).append(pathId);
            int pl = pathIndex.length();
            if (limitRevision != -1L) {
                pathIndex.append(limitRevision + 1L);
            } else {
                pathIndex.appendInfinity();
            }
            if (((_ItemSpace)db).previous(pathIndex, pl)) {
                csid = pathIndex.longAt(pl);
            }
        }
        return csid;
    }

    public long getLatestPathChange(Path physicalPath) throws DbException {
        return this.getLatestPathChangeUpto(physicalPath, -1L);
    }

    public long getLatestLogicalPathChange(Path logicalPath) throws DbException {
        return this.getLatestLogicalPathChangeUpto(logicalPath, -1L);
    }

    public int getRevId(Path path, long changesetId) throws DbException {
        int revid = this.getPureRevId(path, changesetId);
        if (revid == -1 && this.pathMatcher.getContainerId(path).startsWith("tag:")) {
            String tag = this.pathMatcher.getTag(path);
            Path logicalPath = this.pathMatcher.getLogicalPath(path);
            revid = this.getTaggedPathRevid(logicalPath, tag, changesetId);
        }
        return revid;
    }

    public int getPureRevId(Path path, long changesetId) throws DbException {
        int revid = -1;
        long pathId = this.commonDAO.getPathId(path);
        if (pathId != -1L) {
            revid = this.commonDAO.getRevId(pathId, Long.toString(changesetId));
        }
        return revid;
    }

    public void addPathRevIds(SegmentedIntSet revids, int pathId) throws DbException {
        this.commonDAO.addPathRevIds(revids, pathId);
    }

    public SortedMap getPathRevisions(Path physicalPath) throws DbException {
        return this.commonDAO.getPathRevisions(physicalPath);
    }

    public void visitDirectoryTree(Path physicalPath, long changesetId, final CommonRevInfoDAO.DirectoryTreeVisitor visitor) throws DbException {
        String container = this.pathMatcher.getContainerId(physicalPath);
        CommonRevInfoDAO.DirectoryTreeVisitor deletedFilter = new CommonRevInfoDAO.DirectoryTreeVisitor(){

            public void visit(long pathId, long csid) throws DbException {
                int revid = SvnRevInfoDAO.this.commonDAO.getRevId(pathId, Long.toString(csid));
                if (revid == -1 || !SvnRevInfoDAO.this.isDeleted(revid)) {
                    visitor.visit(pathId, csid);
                }
            }
        };
        if (container.startsWith("tag:")) {
            this.visitTaggedTree(physicalPath, changesetId, deletedFilter);
        } else {
            this.commonDAO.visitRevisionTree(physicalPath, SvnSchema.I_PATHID_CHANGESETID, changesetId, deletedFilter);
        }
    }

    public Path getPath(long pathId) throws DbException {
        Path path = null;
        String pathStr = this.commonStringTables.pathDB.get(pathId);
        if (pathStr != null) {
            path = new Path(pathStr);
        }
        return path;
    }

    public SvnRevInfo loadRevision(int revId) throws DbException {
        SvnRevInfo revInfo = null;
        if (this.commonDAO.exists(revId)) {
            try {
                revInfo = new SvnRevInfo();
                this.commonDAO.load(revId, revInfo);
                revInfo.setProperties(this.loadSvnProperties(revId));
                revInfo.setLogicalPath(this.pathMatcher.getLogicalPath(revInfo.getPath()));
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)e2);
                revInfo = null;
            }
        }
        return revInfo;
    }

    public Map<String, String> loadSvnProperties(int revId) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            HashMap<String, String> result = new HashMap<String, String>();
            _Cu cu = _Cu.alloc().append(SvnSchema.E_PROPERTIES).append(revId);
            int keyLength = cu.length();
            while (((_ItemSpace)db).next(cu, keyLength)) {
                long keyId = cu.longAt(keyLength);
                int offset = cu.skipLong(keyLength);
                long valueId = cu.longAt(offset);
                String key = this.svnStringTables.propertyKeyDB.get(keyId);
                String value = this.svnStringTables.propertyValueDB.get(valueId);
                result.put(key, value);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public String getSvnProperty(int revid, String key) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            String result = null;
            _Cu cu = _Cu.alloc().append(SvnSchema.E_PROPERTIES).append(revid);
            long keyId = this.svnStringTables.propertyKeyDB.add(key);
            cu.append(keyId);
            int keyLength = cu.length();
            while (((_ItemSpace)db).next(cu, keyLength)) {
                long valueId = cu.longAt(keyLength);
                result = this.svnStringTables.propertyValueDB.get(valueId);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public RevInfoKey getKey(int revid) throws DbException {
        return this.commonDAO.getKey(revid);
    }

    public boolean exists(Path path, long revisionNumber) throws DbException {
        return this.commonDAO.exists(this.getRevId(path, revisionNumber));
    }

    public void addTag(int taggedRevId, String tag) throws DbException {
        this.commonDAO.addTagData(taggedRevId, tag);
    }

    public void removeTag(int taggedRevId, String tag) throws DbException {
        this.commonDAO.removeTagData(taggedRevId, tag);
    }

    public SvnChangeSet loadChangeSet(long csid) throws DbException {
        TIntArrayList revids = this.commonDAO.getIndexedRevIds(SvnSchema.I_CHANGESETID_REVID, csid);
        SvnChangeSet changeSet = null;
        if (revids.size() != 0) {
            changeSet = new SvnChangeSet(this);
            changeSet.init(revids);
            changeSet.setRevProps(this.getRevProps(csid));
        }
        return changeSet;
    }

    public int getFileType(int revid) throws DbException {
        return this.commonDAO.getFileType(revid);
    }

    public boolean isDeleted(int revid) throws DbException {
        return this.commonDAO.isDeleted(revid);
    }

    public SortedIntSet getRevidsInChangeSetRange(long fromCSID, long toCSID) throws DbException {
        return this.commonDAO.getRevidsInLongIndexRange(SvnSchema.I_CHANGESETID_REVID, fromCSID, toCSID);
    }

    public SortedIntSet getPhysicalPaths(SortedIntSet revids) throws DbException {
        return this.commonDAO.getLongProperySet(SvnSchema.I_REVID_TO_PATHID, revids);
    }

    public Path getPhysicalPath(long physicalPathId) throws DbException {
        return new Path(this.commonStringTables.pathDB.get(physicalPathId));
    }

    public int getLineCount(int revid) throws DbException {
        return this.commonDAO.getLineCount(revid);
    }

    public TLongHashSet getChangeSets(long start, long end) throws DbException {
        return this.commonDAO.getLongIndexKeyRange(SvnSchema.I_CHANGESETID_REVID, start, end);
    }

    public void storeRevProps(long csid, Map<String, String> revProps) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            for (Map.Entry<String, String> entry : revProps.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                long keyId = this.svnStringTables.propertyKeyDB.add(key);
                long valueId = this.svnStringTables.propertyValueDB.add(value);
                _Cu cu = _Cu.alloc().append(SvnSchema.E_REV_PROPERTIES);
                cu.append(csid).append(keyId);
                int keyLength = cu.length();
                cu.append(valueId);
                ((_ItemSpace)db).update(cu, keyLength);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public Map<String, String> getRevProps(long csid) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            HashMap<String, String> result = new HashMap<String, String>();
            _Cu cu = _Cu.alloc().append(SvnSchema.E_REV_PROPERTIES).append(csid);
            int keyLength = cu.length();
            while (((_ItemSpace)db).next(cu, keyLength)) {
                long keyId = cu.longAt(keyLength);
                int offset = cu.skipLong(keyLength);
                long valueId = cu.longAt(offset);
                String key = this.svnStringTables.propertyKeyDB.get(keyId);
                String value = this.svnStringTables.propertyValueDB.get(valueId);
                result.put(key, value);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void removeRevProps(long csid, Set<String> set) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            for (String key : set) {
                long keyId = this.svnStringTables.propertyKeyDB.find(key);
                if (keyId == -1L) continue;
                cu.clear().append(SvnSchema.E_REV_PROPERTIES).append(csid).append(keyId);
                int keyLength = cu.length();
                if (!((_ItemSpace)db).next(cu, keyLength)) continue;
                ((_ItemSpace)db).delete(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateRevProp(long csid, String key, String value) throws DbException {
        try {
            _k4ui8vIDB db = this.dbh.get();
            _Cu cu = _Cu.alloc();
            long keyId = this.svnStringTables.propertyKeyDB.add(key);
            long valueId = this.svnStringTables.propertyValueDB.add(value);
            cu.clear().append(SvnSchema.E_REV_PROPERTIES).append(csid).append(keyId);
            int keyLength = cu.length();
            cu.append(valueId);
            ((_ItemSpace)db).update(cu, keyLength);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateComment(RevInfoKey key, String comment) throws DbException {
        this.commonDAO.updateComment(key, comment);
    }

    public void updateAuthor(RevInfoKey key, String author) throws DbException {
        this.commonDAO.updateAuthor(key, author);
    }

    public void updateDate(RevInfoKey key, long date) throws DbException {
        this.commonDAO.updateDate(key, date);
    }
}

