/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn.diff;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.diff.DiffProcessor;
import com.cenqua.fisheye.svn.diff.MessageInfo;
import com.cenqua.fisheye.svn.diff.SvnDiffException;
import java.util.HashMap;
import java.util.Map;
import org.tigris.subversion.javahl.LogMessage;

public class DiffFetcher
implements Runnable {
    private int maxWaiting = 150;
    private final Object newMessagesEvent = new Object();
    private LogMessage[] messages;
    private final Map<LogMessage, Object> results = new HashMap<LogMessage, Object>();
    private volatile boolean isRunning = true;
    private DiffProcessor processor;
    private static final int EVENT_TIMEOUT = 10000;
    private static final int MAX_DIFF_PROCESSAHEAD = 150;

    public void setProcessor(DiffProcessor processor) {
        this.processor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object = this.newMessagesEvent;
            synchronized (object) {
                while (this.isRunning) {
                    if (this.messages == null) {
                        this.newMessagesEvent.wait(10000L);
                        continue;
                    }
                    Map<LogMessage, Object> map = this.results;
                    synchronized (map) {
                        this.results.clear();
                    }
                    this.process();
                    this.messages = null;
                }
            }
        }
        catch (InterruptedException e2) {
            this.stopProcessing();
        }
        catch (Throwable e3) {
            Logs.APP_LOG.error((Object)("Diff Processor exiting due to exception - " + e3.getClass() + ":" + e3.getMessage()), e3);
            this.stopProcessing();
        }
    }

    private void process() {
        for (LogMessage message : this.messages) {
            try {
                Logs.APP_LOG.debug((Object)("Starting diff processing of " + message.getRevisionNumber()));
                MessageInfo messageInfo = this.processor.processMessage(message);
                this.addResult(message, messageInfo);
            }
            catch (Throwable e2) {
                this.addResult(message, e2);
                break;
            }
            if (!this.isRunning) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResult(LogMessage message, Object result) {
        if (this.isRunning) {
            Map<LogMessage, Object> map = this.results;
            synchronized (map) {
                while (this.results.size() > this.maxWaiting) {
                    try {
                        Logs.APP_LOG.debug((Object)"Max diffs processd - waiting to add result");
                        this.results.wait(10000L);
                    }
                    catch (InterruptedException e2) {}
                }
                Logs.APP_LOG.debug((Object)"Adding diff result");
                this.results.put(message, result);
                this.results.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages(LogMessage[] messages) {
        Object object = this.newMessagesEvent;
        synchronized (object) {
            if (!this.isRunning) {
                throw new IllegalStateException("Attempted to fetch diffs but diff fetcher thread is no longer running");
            }
            this.messages = messages;
            this.newMessagesEvent.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageInfo getMessageInfo(LogMessage message) throws SvnDiffException {
        MessageInfo result = null;
        try {
            Map<LogMessage, Object> map = this.results;
            synchronized (map) {
                if (!this.isRunning) {
                    throw new IllegalStateException("Attempted to access diffs but diff fetcher thread is no longer running");
                }
                while (this.isRunning) {
                    if (this.results.containsKey(message)) {
                        Logs.APP_LOG.debug((Object)("Getting diff result for " + message.getRevisionNumber()));
                        Object entry = this.results.remove(message);
                        this.results.notify();
                        if (entry instanceof Throwable) {
                            if (entry instanceof SvnDiffException) {
                                throw (SvnDiffException)entry;
                            }
                            throw new SvnDiffException(message.getRevisionNumber(), (Throwable)entry);
                        }
                        result = (MessageInfo)entry;
                        break;
                    }
                    Logs.APP_LOG.debug((Object)("Diff result not available yet for " + message.getRevisionNumber()));
                    this.results.wait(10000L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcessing() {
        this.isRunning = false;
        Map<LogMessage, Object> map = this.results;
        synchronized (map) {
            this.results.notifyAll();
        }
    }
}

