/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.syntax.ContextReference;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchRule;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ContextDefinition {
    private final String name;
    private List matchRules = new ArrayList();
    private Map contexts = new HashMap();
    private static final int MAX_REGIONS = 200000;

    public ContextDefinition(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addContextDef(String name, ContextDefinition child) {
        this.contexts.put(name, child);
    }

    public ContextDefinition getContextDef(ContextReference ref) {
        ContextDefinition cd = (ContextDefinition)this.contexts.get(ref.getName());
        return cd;
    }

    public void addMatchRule(MatchRule m) {
        this.matchRules.add(m);
    }

    public void resolveRefs() {
        for (String name : this.contexts.keySet()) {
            ContextDefinition cd = (ContextDefinition)this.contexts.get(name);
            cd.resolveRefs();
        }
        for (MatchRule matcher : this.matchRules) {
            matcher.resolveRefs(this);
        }
    }

    public void generateRegions(InputState input, RegionList outputRegions) {
        while (input.hasMoreChars()) {
            boolean exitContext = false;
            int offset = input.getOffset();
            for (MatchRule matcher : this.matchRules) {
                if (matcher.process(input, outputRegions)) continue;
                exitContext = true;
            }
            if (exitContext || outputRegions.size() > 200000 || input.isOverTime()) {
                return;
            }
            if (offset != input.getOffset()) continue;
            input.consume();
        }
    }

    public String toString() {
        String res = "ContextDef{name=" + this.name + ";subcontexts={";
        String sep = "";
        Iterator it = this.contexts.entrySet().iterator();
        while (it.hasNext()) {
            res = res + sep + it.next();
            sep = ",";
        }
        res = res + "};matchRules={";
        sep = "";
        it = this.matchRules.iterator();
        while (it.hasNext()) {
            res = res + sep + it.next();
            sep = ",";
        }
        res = res + "}}";
        return res;
    }
}

