/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.syntax;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.syntax.InputState;
import com.cenqua.fisheye.syntax.MatchRule;
import com.cenqua.fisheye.syntax.Region;
import com.cenqua.fisheye.syntax.RegionList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpMatchRule
extends MatchRule {
    private final Pattern pattern;

    public RegexpMatchRule(String regexp) {
        this(regexp, 0);
    }

    public RegexpMatchRule(String regexp, int opts) {
        if (regexp == null || regexp.length() == 0) {
            throw new IllegalArgumentException("Invalid Regexp");
        }
        regexp = RegexpMatchRule.processEscapes(regexp);
        this.pattern = Pattern.compile(regexp, opts);
    }

    private static String processEscapes(String re) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < re.length() - 1; ++i2) {
            if (re.charAt(i2) == '\\' && re.charAt(i2 + 1) == '/') continue;
            buf.append(re.charAt(i2));
        }
        buf.append(re.charAt(re.length() - 1));
        return buf.toString();
    }

    public boolean process(InputState input, RegionList outputRegions) {
        boolean result;
        CharSequence chars = input.getFullChars();
        int offset = input.getOffset();
        Matcher matcher = this.pattern.matcher(chars);
        try {
            result = RegexpMatchRule.lookingAt(matcher, offset, input.length());
        }
        catch (StackOverflowError e2) {
            input.setParserOverflowOccured();
            CharSequence errorPart = chars.subSequence(offset, Math.min(offset + 10, chars.length()));
            Logs.APP_LOG.warn((Object)("error parsing file with regexp " + this.pattern.pattern() + " on file " + input.getFileName() + " offset " + offset + ", starting with: " + errorPart), (Throwable)e2);
            return true;
        }
        if (result) {
            HashMap<String, Region> matchRegions = new HashMap<String, Region>();
            for (int i2 = 0; i2 <= matcher.groupCount(); ++i2) {
                if (matcher.start(i2) < 0 || matcher.start(i2) == matcher.end(i2)) continue;
                matchRegions.put("" + i2, new Region(matcher.start(i2), matcher.end(i2)));
            }
            input.consume(matcher.end() - offset);
            return this.performAction(input, matchRegions, outputRegions);
        }
        return true;
    }

    public String toString() {
        return "RegexpMatchRule{regexp=" + this.pattern.toString() + ";action=" + this.action + "}";
    }

    public static boolean lookingAt(Matcher matcher, int regionStart, int regionEnd) {
        matcher.useTransparentBounds(true);
        matcher.useAnchoringBounds(false);
        matcher.region(regionStart, regionEnd);
        return matcher.lookingAt();
    }
}

