/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.user.ldap;

import com.cenqua.fisheye.config1.LdapConfigType;
import com.cenqua.fisheye.config1.LdapRepositoryConfigType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.util.VariableSubstituter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LDAPAuth
extends BaseAuth {
    private static String ATTR_MATCH_TYPE_ANY = "any";
    private static String ATTR_MATCH_TYPE_USER = "user";
    private final Hashtable initialEnv = new Hashtable();
    private final String baseDN;
    private final String userFilter;
    private final String emailAttr;
    private final String displayNameAttr;
    private final String[] returnedAttrIDs;
    private final boolean initialBind;
    private final boolean autoAdd;

    public LDAPAuth(LdapConfigType cfg) {
        this(cfg, Logs.APP_LOG, Logs.PERF_LOG);
    }

    public LDAPAuth(LdapConfigType cfg, Logger appLog, Logger perfLog) {
        super(appLog, perfLog);
        this.autoAdd = cfg.getAutoAdd();
        this.initialEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.initialEnv.put("java.naming.provider.url", cfg.getUrl());
        this.initialEnv.put("java.naming.security.authentication", "none");
        this.initialEnv.put("java.naming.referral", "follow");
        this.baseDN = cfg.getBaseDn();
        this.userFilter = cfg.getFilter();
        String uidAttr = cfg.getUidAttr();
        this.emailAttr = cfg.getEmailAttr();
        this.displayNameAttr = cfg.getDisplaynameAttr();
        ArrayList<String> attrIDs = new ArrayList<String>();
        attrIDs.add(uidAttr);
        if (this.emailAttr != null) {
            attrIDs.add(this.emailAttr);
        }
        if (this.displayNameAttr != null) {
            attrIDs.add(this.displayNameAttr);
        }
        this.returnedAttrIDs = attrIDs.toArray(new String[0]);
        this.initialBind = cfg.isSetInitialDn();
        if (this.initialBind) {
            this.initialEnv.put("java.naming.security.principal", cfg.getInitialDn());
            this.initialEnv.put("java.naming.security.credentials", cfg.getInitialSecret());
            this.initialEnv.put("java.naming.security.authentication", "simple");
        }
        this.setPermCacheTTL(cfg.getPositiveCacheTtl());
    }

    public void close() {
    }

    public boolean getAutoAdd() {
        return this.autoAdd;
    }

    public int getAuthType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseAuth.AuthTok checkPassword(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        if (username == null || "".equals(username)) {
            this.appLog.debug((Object)"LDAP: can't check an empty username");
            return null;
        }
        if (password == null || "".equals(password)) {
            this.appLog.debug((Object)"LDAP: can't check an empty password");
            return null;
        }
        InitialDirContext ctx = null;
        try {
            String dn;
            ctx = this.makeContext();
            if (ctx == null) {
                BaseAuth.AuthTok authTok = null;
                return authTok;
            }
            long t0 = System.currentTimeMillis();
            HashMap<String, String> filterVars = new HashMap<String, String>();
            filterVars.put("USERNAME", username);
            String filter = VariableSubstituter.substituteRefs((CharSequence)this.userFilter, filterVars);
            SearchResult sr = this.doSearch(ctx, filter);
            LdapAuthTok result = null;
            if (sr != null && this.checkPassword(ctx, filter, dn = sr.getName() + "," + this.baseDN, password)) {
                String email = this.extractEmailAddress(sr);
                String displayName = this.extractDisplayName(sr);
                result = new LdapAuthTok(username, email, displayName, dn);
            }
            long t1 = System.currentTimeMillis();
            if (this.perfLog.isInfoEnabled()) {
                this.perfLog.info((Object)("LDAP password check for " + username + " in " + (t1 - t0) + "ms"));
            }
            LdapAuthTok ldapAuthTok = result;
            return ldapAuthTok;
        }
        finally {
            this.close(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseAuth.AuthTok recreateAuth(String username) {
        InitialDirContext ctx = null;
        try {
            ctx = this.makeContext();
            if (ctx == null) {
                BaseAuth.AuthTok authTok = null;
                return authTok;
            }
            HashMap<String, String> filterVars = new HashMap<String, String>();
            filterVars.put("USERNAME", username);
            String filter = VariableSubstituter.substituteRefs((CharSequence)this.userFilter, filterVars);
            SearchResult sr = this.doSearch(ctx, filter);
            if (sr != null) {
                String dn = sr.getName() + "," + this.baseDN;
                String email = this.extractEmailAddress(sr);
                String displayName = this.extractDisplayName(sr);
                LdapAuthTok ldapAuthTok = new LdapAuthTok(username, email, displayName, dn);
                return ldapAuthTok;
            }
            BaseAuth.AuthTok authTok = null;
            return authTok;
        }
        finally {
            this.close(ctx);
        }
    }

    private String extractEmailAddress(SearchResult sr) {
        try {
            Attribute attr;
            if (this.emailAttr != null && (attr = sr.getAttributes().get(this.emailAttr)) != null) {
                Object o = attr.get();
                return o == null ? null : o.toString();
            }
        }
        catch (NamingException e2) {
            this.appLog.warn((Object)"problem extracting email", (Throwable)e2);
        }
        return null;
    }

    private String extractDisplayName(SearchResult sr) {
        try {
            Attribute attr;
            if (this.displayNameAttr != null && (attr = sr.getAttributes().get(this.displayNameAttr)) != null) {
                Object o = attr.get();
                return o == null ? null : o.toString();
            }
        }
        catch (NamingException e2) {
            this.appLog.warn((Object)"problem extracting display name", (Throwable)e2);
        }
        return null;
    }

    private void close(InitialDirContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e2) {
            this.appLog.warn((Object)"problem closing LDAP connection", (Throwable)e2);
        }
    }

    private InitialDirContext makeContext() {
        try {
            return new InitialDirContext(this.initialEnv);
        }
        catch (NamingException e2) {
            this.appLog.warn((Object)"problem getting initial LDAP context", (Throwable)e2);
            return null;
        }
    }

    private SearchResult doSearch(InitialDirContext ctx, String filter) {
        SearchResult sr;
        NamingEnumeration<SearchResult> results;
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(this.returnedAttrIDs);
        ctls.setSearchScope(2);
        try {
            if (this.appLog.isDebugEnabled()) {
                this.appLog.debug((Object)("performing search: " + filter + " on " + this.baseDN + " (" + (this.initialBind ? "authenticated" : "anonymous") + ")"));
            }
            results = ctx.search(this.baseDN, filter, ctls);
        }
        catch (NamingException e2) {
            this.appLog.warn((Object)("LDAP: could not list users using " + filter + " on " + this.baseDN + " (" + (this.initialBind ? "authenticated" : "anonymous") + ")"), (Throwable)e2);
            return null;
        }
        try {
            if (results == null || !results.hasMore()) {
                if (this.appLog.isDebugEnabled()) {
                    this.appLog.debug((Object)("LDAP: could not find user using " + filter + " on " + this.baseDN));
                }
                return null;
            }
            sr = results.next();
        }
        catch (NamingException e3) {
            this.appLog.warn((Object)"LDAP: problem retrieving results", (Throwable)e3);
            return null;
        }
        return sr;
    }

    private boolean checkPassword(InitialDirContext ctx, String filter, String dn, String password) {
        try {
            ctx.removeFromEnvironment("java.naming.security.principal");
            ctx.removeFromEnvironment("java.naming.security.credentials");
            ctx.removeFromEnvironment("java.naming.security.authentication");
            ctx.addToEnvironment("java.naming.security.authentication", "simple");
            ctx.addToEnvironment("java.naming.security.principal", dn);
            ctx.addToEnvironment("java.naming.security.credentials", password);
        }
        catch (NamingException e2) {
            this.appLog.warn((Object)("LDAP: problem authenticating user " + dn), (Throwable)e2);
            return false;
        }
        SearchControls userSearch = new SearchControls();
        userSearch.setReturningAttributes(new String[0]);
        userSearch.setSearchScope(0);
        try {
            ctx.search(dn, filter, userSearch);
        }
        catch (AuthenticationException e3) {
            this.appLog.debug((Object)("LDAP: password failed for " + dn + ": " + e3.getMessage()));
            return false;
        }
        catch (NamingException e4) {
            this.appLog.warn((Object)("LDAP: failed to connect as " + dn), (Throwable)e4);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPermissionToAccess(BaseAuth.AuthTok atok, boolean defaultResult, RepositoryHandle rcfg) {
        LdapRepositoryConfigType constraint = rcfg.getCfg().getLdapConstraint();
        if (constraint == null) {
            return defaultResult;
        }
        if (!(atok instanceof LdapAuthTok)) {
            return false;
        }
        LdapAuthTok tok = (LdapAuthTok)atok;
        String repname = rcfg.getName();
        Boolean cacheResult = this.checkCache(tok, repname);
        if (cacheResult != null) {
            if (this.appLog.isDebugEnabled()) {
                this.appLog.debug((Object)("LDAP: got perm check from the cache, " + tok.username + " against rep " + repname));
            }
            return cacheResult;
        }
        String repFilter = constraint.getFilter();
        InitialDirContext ctx = null;
        try {
            ctx = this.makeContext();
            if (ctx == null) {
                boolean bl = false;
                return bl;
            }
            long t0 = System.currentTimeMillis();
            HashMap<String, String> filterVars = new HashMap<String, String>();
            filterVars.put("USERNAME", tok.username);
            filterVars.put("DN", tok.dn);
            filterVars.put("REP", repname);
            String filter = VariableSubstituter.substituteRefs((CharSequence)repFilter, filterVars);
            SearchResult sr = this.doSearch(ctx, filter);
            boolean result = false;
            if (sr != null) {
                String matchOn;
                String string = matchOn = constraint.getMatchType() == null ? ATTR_MATCH_TYPE_USER : constraint.getMatchType();
                if (ATTR_MATCH_TYPE_ANY.equalsIgnoreCase(matchOn)) {
                    result = true;
                } else {
                    String dn = sr.getName() + "," + this.baseDN;
                    if (dn.equals(tok.dn)) {
                        result = true;
                    } else {
                        this.appLog.warn((Object)("LDAP: for some reason, permission check returned different dn: " + tok.dn + " vs " + dn));
                    }
                }
            }
            long t1 = System.currentTimeMillis();
            if (this.perfLog.isInfoEnabled()) {
                this.perfLog.info((Object)("LDAP permission check for " + tok.username + " on " + repname + " in " + (t1 - t0) + "ms"));
            }
            this.setCache(tok, repname, result);
            boolean bl = result;
            return bl;
        }
        finally {
            this.close(ctx);
        }
    }

    public BaseAuth.AuthTok checkRequest(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public static class LdapAuthTok
    extends BaseAuth.AuthTok {
        final String username;
        final String email;
        final String displayName;
        final String dn;

        public LdapAuthTok(String username, String email, String displayName, String dn) {
            this.username = username;
            this.email = email;
            this.displayName = displayName;
            this.dn = dn;
        }

        public String getDn() {
            return this.dn;
        }

        public String getEmail() {
            return this.email;
        }

        public String getUsername() {
            return this.username;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getAuthType() {
            return 2;
        }
    }
}

