/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Disposable;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedList;

public class Disposer {
    private static final ThreadLocal mPerThreadStack = new ThreadLocal(){

        protected Object initialValue() {
            return new LinkedList();
        }
    };
    private final LinkedList mDisposables = new LinkedList();

    public void deleteFileOnDispose(final File file) {
        this.add(new Disposable(){

            public void dispose() throws Exception {
                file.delete();
            }
        });
    }

    public void closeOnDispose(final InputStream in) {
        this.add(new Disposable(){

            public void dispose() throws Exception {
                in.close();
            }
        });
    }

    public void disposeOnDispose(final Disposer disposer) {
        this.add(new Disposable(){

            public void dispose() throws Exception {
                disposer.disposeAll();
            }
        });
    }

    public void add(Disposable d2) {
        this.mDisposables.addFirst(d2);
    }

    public void disposeAll() {
        for (Disposable d2 : this.mDisposables) {
            try {
                d2.dispose();
            }
            catch (Exception e2) {
                Logs.APP_LOG.warn((Object)"error during disposal", (Throwable)e2);
            }
        }
        this.mDisposables.clear();
    }

    protected void finalize() throws Throwable {
        this.disposeAll();
        super.finalize();
    }

    public static Disposer threadInstance() {
        LinkedList stack = (LinkedList)mPerThreadStack.get();
        if (stack.isEmpty()) {
            throw new IllegalStateException("a disposer has not been initialized for this thread");
        }
        return (Disposer)stack.getLast();
    }

    public static Disposer pushThreadInstance() {
        LinkedList stack = (LinkedList)mPerThreadStack.get();
        Disposer d2 = new Disposer();
        stack.addLast(d2);
        return d2;
    }

    public static void popThreadInstance() {
        LinkedList stack = (LinkedList)mPerThreadStack.get();
        if (stack.isEmpty()) {
            throw new IllegalStateException("a disposer has not been initialized for this thread");
        }
        Disposer disposer = (Disposer)stack.removeLast();
        disposer.disposeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void with(Runnable runnable) {
        Disposer.pushThreadInstance();
        try {
            runnable.run();
        }
        finally {
            Disposer.popThreadInstance();
        }
    }
}

