/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitOutputStream
extends FilterOutputStream {
    private long sizeLimit;
    private int bytesWritten;

    public LimitOutputStream(long sizeLimit, OutputStream out) {
        super(out);
        this.sizeLimit = sizeLimit;
    }

    public void write(int b2) throws IOException {
        super.write(b2);
        ++this.bytesWritten;
        this.checkLimit();
    }

    public void write(byte[] b2) throws IOException {
        super.write(b2);
        this.bytesWritten += b2.length;
        this.checkLimit();
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        super.write(b2, off, len);
        this.bytesWritten += len;
        this.checkLimit();
    }

    private void checkLimit() throws IOException {
        if ((long)this.bytesWritten > this.sizeLimit) {
            throw new IOException("Size limit of stream exceeded");
        }
    }
}

