/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

import gnu.trove.TLongObjectHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LongLockMap {
    private final SyncFactory syncFactory;
    private final TLongObjectHashMap locks = new TLongObjectHashMap();

    public LongLockMap(SyncFactory syncFactory) {
        this.syncFactory = syncFactory;
    }

    public LongLockMap() {
        this(new SyncFactory(){

            public Lock newInstance() {
                return new ReentrantLock();
            }
        });
    }

    public void acquire(long id) throws InterruptedException {
        Node node = this.grab(id);
        node.sync.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attempt(long id, long msecs) throws InterruptedException {
        boolean needsRelease = false;
        try {
            Node node = this.grab(id);
            needsRelease = true;
            boolean success = node.sync.tryLock(msecs, TimeUnit.MILLISECONDS);
            needsRelease = !success;
            boolean bl = success;
            return bl;
        }
        finally {
            if (needsRelease) {
                this.release(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(long id) {
        TLongObjectHashMap tLongObjectHashMap = this.locks;
        synchronized (tLongObjectHashMap) {
            Node node = (Node)this.locks.get(id);
            if (node == null) {
                return;
            }
            node.sync.unlock();
            --node.count;
            if (node.count == 0) {
                this.locks.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node grab(long id) {
        TLongObjectHashMap tLongObjectHashMap = this.locks;
        synchronized (tLongObjectHashMap) {
            Node node = (Node)this.locks.get(id);
            if (node == null) {
                node = new Node(this.syncFactory.newInstance());
                this.locks.put(id, (Object)node);
            }
            ++node.count;
            return node;
        }
    }

    private static class Node {
        final Lock sync;
        int count = 0;

        public Node(Lock sync) {
            this.sync = sync;
        }
    }

    public static interface SyncFactory {
        public Lock newInstance();
    }
}

