/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.bitset;

import com.cenqua.fisheye.util.bitset.BiDiBitSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.util.SortedSet;
import java.util.TreeSet;

public class SegmentedIntSet
implements SortedIntSet {
    static final int SEGMENT_BITSIZE = 8192;
    static final int SEGMENT_HIMASK = -8192;
    private final TIntObjectHashMap segments = new TIntObjectHashMap();
    private final TreeSet segmentKeys = new TreeSet();

    public boolean get(int idx) {
        int segment = idx & 0xFFFFE000;
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        if (bs == null) {
            return false;
        }
        int idxOffset = idx - segment;
        return bs.get(idxOffset);
    }

    public void set(int idx) {
        int segment = idx & 0xFFFFE000;
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        if (bs == null) {
            bs = new BiDiBitSet(8192);
            this.segments.put(segment, (Object)bs);
            this.segmentKeys.add(segment);
        }
        int idxOffset = idx - segment;
        bs.set(idxOffset);
    }

    public void clear(int idx) {
        int segment = idx & 0xFFFFE000;
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        if (bs != null) {
            int idxOffset = idx - segment;
            bs.clear(idxOffset);
        }
    }

    public int nextSetBit(int idx) {
        int segment = idx & 0xFFFFE000;
        int idxOffset = idx - segment;
        do {
            int nextOffset;
            BiDiBitSet bs;
            if ((bs = (BiDiBitSet)this.segments.get(segment)) != null && (nextOffset = bs.nextSetBit(idxOffset)) != -1) {
                return nextOffset + segment;
            }
            segment = this.nextSegment(segment);
            idxOffset = 0;
        } while (segment != -1);
        return -1;
    }

    public int prevSetBit(int idx) {
        int segment = idx & 0xFFFFE000;
        int idxOffset = idx - segment;
        do {
            int prevOffset;
            BiDiBitSet bs;
            if ((bs = (BiDiBitSet)this.segments.get(segment)) != null && (prevOffset = bs.prevSetBit(idxOffset)) != -1) {
                return prevOffset + segment;
            }
            segment = this.prevSegment(segment);
            idxOffset = 8192;
        } while (segment != -1);
        return -1;
    }

    public int length() {
        int segment = this.prevSegment(Integer.MAX_VALUE);
        if (segment == -1) {
            return 0;
        }
        BiDiBitSet bs = (BiDiBitSet)this.segments.get(segment);
        return bs.length() + segment;
    }

    public int cardinality() {
        class Counter
        implements TObjectProcedure {
            int count = 0;

            Counter() {
            }

            public boolean execute(Object object) {
                BiDiBitSet bs = (BiDiBitSet)object;
                this.count += bs.cardinality();
                return true;
            }
        }
        Counter counter = new Counter();
        this.segments.forEachValue((TObjectProcedure)counter);
        return counter.count;
    }

    private int nextSegment(int segment) {
        SortedSet<Integer> nextSet = this.segmentKeys.tailSet(segment + 1);
        if (nextSet.isEmpty()) {
            return -1;
        }
        Integer next = nextSet.first();
        return next;
    }

    private int prevSegment(int segment) {
        SortedSet<Integer> prevSet = this.segmentKeys.headSet(segment);
        if (prevSet.isEmpty()) {
            return -1;
        }
        Integer prev = prevSet.last();
        return prev;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        buffer.append('{');
        int i2 = this.nextSetBit(0);
        while (i2 >= 0) {
            buffer.append(separator);
            separator = ", ";
            buffer.append(i2);
            i2 = this.nextSetBit(i2 + 1);
        }
        buffer.append('}');
        return buffer.toString();
    }
}

