/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.vis.BranchTable;
import com.cenqua.fisheye.vis.DrawContext;
import com.cenqua.fisheye.vis.DrawContextMetrics;
import com.cenqua.fisheye.vis.Graph;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HistoryRenderer {
    private DrawContext g;
    private final Graph mGraph;
    private final BranchTable mTable;
    private final DrawContextMetrics mMetrics;
    private final FileHistory mHist;
    private int[] mColWidths;

    public HistoryRenderer(FileHistory hist, Graph graph, BranchTable table, DrawContextMetrics metrics) {
        this.mGraph = graph;
        this.mTable = table;
        this.mMetrics = metrics;
        this.mHist = hist;
    }

    public void draw(DrawContext ctx) {
        this.g = ctx;
        Dimension bounds = this.computeBounds();
        this.g.drawBackground(bounds.width, bounds.height);
        this.mGraph.visitSpudOrder(new Graph.Visitor(){
            private final Set visited = new HashSet();

            public void visitingBranch(String br) {
                if (this.visited.contains(br)) {
                    return;
                }
                this.visited.add(br);
                if (!br.equals(HistoryRenderer.this.mHist.getMainBranch())) {
                    HistoryRenderer.this.drawBranchEdge(br);
                }
                int col = HistoryRenderer.this.mTable.getBranchColPos(br);
                int x = HistoryRenderer.this.getColumnX(col);
                int w = HistoryRenderer.this.mColWidths[col];
                String label = br;
                HistoryRenderer.this.g.drawBranchLabel(label, x, HistoryRenderer.this.getBranchLabelY(br), w);
                BranchTable.BranchInfo info = HistoryRenderer.this.mTable.getInfo(br);
                for (int i2 = 0; i2 < info.getNumRevisions(); ++i2) {
                    String rev = info.getRevision(i2);
                    int y = HistoryRenderer.this.getNodeY(rev);
                    if (i2 != 0) {
                        String lastRev = info.getRevision(i2 - 1);
                        int lasty = HistoryRenderer.this.getNodeY(lastRev);
                        if (info.doesSkipPreceed(i2)) {
                            HistoryRenderer.this.g.drawSkippedNodeEdge(lastRev, x, lasty, w, rev, y);
                        } else {
                            HistoryRenderer.this.g.drawNodeEdge(lastRev, x, lasty, w, rev, y);
                        }
                    }
                    FileRevision ri = HistoryRenderer.this.mHist.getRevision(rev);
                    HistoryRenderer.this.g.drawNode(HistoryRenderer.this.mHist, ri, x, y, w);
                }
            }
        });
    }

    private int getBranchY(String br) {
        float row = this.mTable.getBranchFirstPos(br);
        int y = (int)(row * (float)this.mMetrics.getRowHeight());
        y = 10 + y;
        return y;
    }

    private int getColumnX(int col) {
        int x = 10;
        for (int i2 = 0; i2 < col; ++i2) {
            x += this.mColWidths[i2] + this.mMetrics.getColumnGap();
        }
        return x;
    }

    private int getNodeY(String rev) {
        float row = this.mTable.getNodeRowPos(rev);
        int y = (int)(10.0f + row * (float)this.mMetrics.getRowHeight());
        return y;
    }

    private int getBranchLabelY(String rev) {
        float row = this.mTable.getBranchTop(rev);
        int y = (int)(10.0f + row * (float)this.mMetrics.getRowHeight());
        return y;
    }

    private void drawBranchEdge(String br) {
        String rev = this.mGraph.getBranchPoint(br);
        if (rev != null) {
            int col = this.mTable.getBranchColPos(this.mGraph.getBranchOf(rev));
            int x0 = this.getColumnX(col);
            int w0 = this.mColWidths[col];
            int y0 = this.getNodeY(rev);
            int col1 = this.mTable.getBranchColPos(br);
            int x1 = this.getColumnX(col1);
            int w1 = this.mColWidths[col1];
            int y1 = this.getBranchY(br);
            this.g.drawBranchEdge(rev, x0, y0, w0, br, x1, y1, w1);
        }
    }

    public int computeWidth(BranchTable.BranchInfo info) {
        int width = this.mMetrics.getStringWidth(info.getBr());
        for (int i2 = 0; i2 < info.getNumRevisions(); ++i2) {
            String r = info.getRevision(i2);
            FileRevision ri = this.mHist.getRevision(r);
            int w = this.mMetrics.computeWidth(ri);
            width = Math.max(width, w);
        }
        return this.mMetrics.getColumnPad() * 2 + width;
    }

    public Dimension computeBounds() {
        int maxBrY = 0;
        Collection brs = this.mGraph.getBranchNames();
        for (String br : brs) {
            if (br == null || br.equals("")) continue;
            BranchTable.BranchInfo info = this.mTable.getInfo(br);
            if (info == null) {
                Logs.APP_LOG.error((Object)("Unable to get branch info for branch: " + br));
                Logs.APP_LOG.error((Object)this.mHist.toString());
                continue;
            }
            String lastRev = info.getRevision(info.getNumRevisions() - 1);
            int y = this.getNodeY(lastRev) + this.mMetrics.getRowHeight();
            if (y <= maxBrY) continue;
            maxBrY = y;
        }
        this.mColWidths = new int[this.mTable.getNumColumns()];
        int width = 0;
        int gap = 0;
        for (int i2 = 0; i2 < this.mTable.getNumColumns(); ++i2) {
            List col = this.mTable.getColumn(i2);
            int maxW = 0;
            for (BranchTable.BranchInfo info : col) {
                int w = this.computeWidth(info);
                maxW = Math.max(w, maxW);
            }
            this.mColWidths[i2] = maxW;
            width += maxW + gap;
            gap = this.mMetrics.getColumnGap();
        }
        width = 10 + width + 10;
        return new Dimension(width, maxBrY);
    }
}

