/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.impl.LocCacheDAO;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.IntSequence;
import com.cenqua.fisheye.util.LRUCache;
import com.cenqua.fisheye.vis.AgeBlameColourer;
import com.cenqua.fisheye.vis.AnnotationColourer;
import com.cenqua.fisheye.vis.LegendValue;
import com.cenqua.fisheye.vis.LinecountCalculator;
import com.cenqua.fisheye.vis.LinecountCollator;
import com.cenqua.fisheye.vis.QueryParams;
import gnu.trove.TObjectLongHashMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineCountDatasetProducer {
    private final RepositoryEngine mRep;
    private LocCacheDAO mDao;
    private final LRUCache mQueryCache;
    private final IntSequence mSeq;
    private static final int MAX_CACHE_ENTRIES = 1000;

    public LineCountDatasetProducer(RepositoryEngine repCfg) {
        this.mRep = repCfg;
        File cacheDir = LineCountDatasetProducer.getCacheDir(repCfg);
        try {
            IOHelper.mkdirs(cacheDir);
            this.mDao = new LocCacheDAO(cacheDir);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)("Could not create cache dir: " + cacheDir), (Throwable)e2);
        }
        this.mQueryCache = new LRUCache(1000, false, new FileSystemCacheListener());
        this.mSeq = new IntSequence();
    }

    public void clear() {
        if (this.mDao != null) {
            this.mDao.deleteAll();
        }
    }

    private static File getCacheDir(RepositoryEngine rep) {
        return new File(AppConfig.getVarDir(), "cache/" + rep.getName() + "/locdata");
    }

    public PieDataset produceAuthorLineCountDataset(AnnotationColourer data) {
        TObjectLongHashMap map = new TObjectLongHashMap();
        List<LegendValue> legend = data.getLegend();
        for (LegendValue value : legend) {
            map.put((Object)value.getName(), (long)value.getLinesOfCode());
        }
        DefaultPieDataset pie = new DefaultPieDataset();
        this.consolidatePieData(map, pie);
        return pie;
    }

    public XYDataset produceAgeLineCountDataset(AnnotationColourer data) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        List<LegendValue> legend = data.getLegend();
        XYSeries series = new XYSeries((Comparable)((Object)"LOC"));
        for (LegendValue value : legend) {
            series.add((double)value.getKey(), (double)value.getLinesOfCode());
        }
        dataset.addSeries(series);
        return dataset;
    }

    public CategoryDataset produceAgeBlameLineCountDataset(AnnotationColourer colouer) {
        AgeBlameColourer producer = (AgeBlameColourer)colouer;
        return producer.getDataset();
    }

    public XYSeriesCollection produceAuthorLineCountDataset(Path dir, List<String> authors, String branch) {
        XYSeriesCollection linecounts = new XYSeriesCollection();
        for (String author : authors) {
            LinecountCollator value = this.getCachedCollator(dir, author, branch);
            if (value == null) continue;
            linecounts.addSeries(value.createLineCountSeries(author));
        }
        return linecounts;
    }

    public XYSeriesCollection produceLineCountDataset(Path dir, String branch) {
        XYSeriesCollection linecounts = new XYSeriesCollection();
        String title = branch == null ? "(trunk)" : branch;
        LinecountCollator value = this.getCachedCollator(dir, null, branch);
        if (value != null) {
            linecounts.addSeries(value.createLineCountSeries(title));
        }
        return linecounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinecountCollator getCachedCollator(Path dir, String author, String branch) {
        try {
            LinecountCollator collator;
            if (branch == null) {
                LinecountCalculator calc = new LinecountCalculator();
                LineCountValueFactory factory = new LineCountValueFactory(calc);
                QueryParams params = new QueryParams();
                params.setPath(dir);
                params.addAuthor(author);
                calc.setParams(params);
                LRUCache lRUCache = this.mQueryCache;
                synchronized (lRUCache) {
                    CacheValue value = (CacheValue)this.mQueryCache.get(params, factory);
                    collator = this.lazyLoadCollator(value);
                }
            }
            LRUCache calc = this.mQueryCache;
            synchronized (calc) {
                CacheValue value = this.getBranchCollator(dir, branch);
                collator = this.lazyLoadCollator(value);
            }
            return collator;
        }
        catch (LRUCache.ValueFactoryException e2) {
            Logs.APP_LOG.warn((Object)e2.getException().getMessage(), (Throwable)e2.getException());
        }
        catch (DbException e3) {
            Logs.APP_LOG.warn((Object)e3.getMessage(), (Throwable)e3);
        }
        return null;
    }

    private LinecountCollator lazyLoadCollator(CacheValue value) throws DbException {
        if (this.mDao == null) {
            return value.tmpCollator;
        }
        LinecountCollator collator = value.tmpCollator != null ? value.tmpCollator : this.mDao.read(value.valueKey);
        value.tmpCollator = null;
        return collator;
    }

    private CacheValue getBranchCollator(Path dir, String branch) throws LRUCache.ValueFactoryException {
        LinecountCalculator calc = new LinecountCalculator();
        QueryParams branchParams = new QueryParams();
        branchParams.setPath(dir);
        branchParams.setBranch(branch);
        calc.setParams(branchParams);
        LineCountValueFactory factory = new LineCountValueFactory(calc);
        return (CacheValue)this.mQueryCache.get(branchParams, factory);
    }

    private void consolidatePieData(TObjectLongHashMap map, DefaultPieDataset dataset) {
        final long[] vals = new long[map.size()];
        final String[] authors = new String[map.size()];
        long grandTotal = 0L;
        Object[] keys = map.keys();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            long total;
            String author = (String)keys[i2];
            vals[i2] = total = map.get((Object)author);
            grandTotal += total;
            authors[i2] = author;
        }
        IntComparator comp = new IntComparator(){

            public int compare(int i2, int j) {
                long a2 = vals[i2];
                long b2 = vals[j];
                return CompareUtil.compareTo(b2, a2);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int a2, int b2) {
                String tmp = authors[a2];
                authors[a2] = authors[b2];
                authors[b2] = tmp;
                long tmpLong = vals[a2];
                vals[a2] = vals[b2];
                vals[b2] = tmpLong;
            }
        };
        GenericSorting.mergeSort((int)0, (int)map.size(), (IntComparator)comp, (Swapper)swapper);
        grandTotal = Math.max(1L, grandTotal);
        int OTHER_THRESH = 92;
        int OTHER_THRESH1 = 12;
        boolean throwIntoOther = false;
        long other = 0L;
        long total = 0L;
        for (int i3 = 0; i3 < vals.length; ++i3) {
            String author = authors[i3];
            long val = vals[i3];
            total += val;
            if (throwIntoOther) {
                other += val;
                continue;
            }
            dataset.setValue((Comparable)((Object)author), (double)val);
            throwIntoOther = total * 100L / grandTotal > 92L || i3 >= 12;
        }
        if (other != 0L) {
            dataset.setValue((Comparable)((Object)"other"), (double)other);
        }
    }

    private class FileSystemCacheListener
    implements LRUCache.CacheListener {
        private FileSystemCacheListener() {
        }

        public void removedValue(Object key, Object val) {
            CacheValue value = (CacheValue)val;
            if (value != null && LineCountDatasetProducer.this.mDao != null) {
                LineCountDatasetProducer.this.mDao.delete(value.valueKey);
            }
        }

        public void addedValue(Object key, Object val) {
            if (val == null || LineCountDatasetProducer.this.mDao == null) {
                return;
            }
            CacheValue cacheValue = (CacheValue)val;
            try {
                cacheValue.valueKey = LineCountDatasetProducer.this.mDao.save(cacheValue.valueKey, cacheValue.tmpCollator);
            }
            catch (DbException e2) {
                Logs.APP_LOG.debug((Object)("Error writing collator to filestore." + e2.getMessage()), (Throwable)e2);
            }
        }

        public void removedAll() {
            LineCountDatasetProducer.this.clear();
        }
    }

    private class LineCountValueFactory
    implements LRUCache.ValueFactory {
        private final LinecountCalculator mCalc;

        public LineCountValueFactory(LinecountCalculator calc) {
            this.mCalc = calc;
        }

        public Object createValue() throws Exception {
            long serial = LineCountDatasetProducer.this.mRep.getRevisionCache().getLastModifiedDate();
            LinecountCollator lc = this.createLinecount();
            CacheValue value = new CacheValue(serial, LineCountDatasetProducer.this.mSeq.next());
            value.tmpCollator = lc;
            return value;
        }

        public void updateValue(Object key, Object newval) throws Exception {
            CacheValue value = (CacheValue)newval;
            long currentSerial = LineCountDatasetProducer.this.mRep.getRevisionCache().getLastModifiedDate();
            if (currentSerial == value.repLastModDate) {
                return;
            }
            this.updateOrCreateCollator(key, value);
            value.reset(currentSerial, value.valueKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateOrCreateCollator(Object key, CacheValue value) throws DbException {
            if (this.mCalc.incrementalUpdateSupported() && LineCountDatasetProducer.this.mRep.getStatus().isDoneFullSlurp()) {
                this.updateLinecount(value);
            } else {
                CacheValue cacheValue = value;
                synchronized (cacheValue) {
                    LineCountDatasetProducer.this.mQueryCache.expire(key);
                    value.tmpCollator = this.createLinecount();
                }
            }
        }

        private LinecountCollator createLinecount() throws DbException {
            long t0 = System.currentTimeMillis();
            LinecountCollator lc = new LinecountCollator();
            this.mCalc.collectLineCounts(LineCountDatasetProducer.this.mRep, new LinecountCalculator.StandardVisitor(lc));
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.debug((Object)("line counts collected in " + (t1 - t0) + "ms. " + this.mCalc.getParams()));
            return lc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLinecount(CacheValue value) throws DbException {
            long t0 = System.currentTimeMillis();
            CacheValue cacheValue = value;
            synchronized (cacheValue) {
                if (LineCountDatasetProducer.this.mDao == null) {
                    this.mCalc.updateLineCounts(LineCountDatasetProducer.this.mRep, value.tmpCollator.getMaxDomain(), new LinecountCalculator.StandardVisitor(value.tmpCollator));
                } else {
                    LinecountCollator lc = LineCountDatasetProducer.this.mDao.read(value.valueKey);
                    this.mCalc.updateLineCounts(LineCountDatasetProducer.this.mRep, lc.getMaxDomain(), new LinecountCalculator.StandardVisitor(lc));
                    LineCountDatasetProducer.this.mDao.save(value.valueKey, lc);
                    value.tmpCollator = lc;
                }
            }
            long t1 = System.currentTimeMillis();
            Logs.PERF_LOG.debug((Object)("line counts updated in " + (t1 - t0) + "ms. " + this.mCalc.getParams()));
        }
    }

    static class CacheValue {
        long repLastModDate;
        int valueKey;
        LinecountCollator tmpCollator = null;

        public CacheValue(long dateCreated, int id) {
            this.reset(dateCreated, id);
        }

        public void reset(long dateCreated, int id) {
            this.repLastModDate = dateCreated;
            this.valueKey = id;
        }

        public String toString() {
            return "" + this.valueKey;
        }
    }
}

