/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.atlassian.plugin.webresource.WebResourceManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.PathNotFoundException;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchManager;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseAction {
    public static final int MOD_ALWAYS_SEND = -1;
    private FishEyePathInfo mPI;
    private HttpServletRequest mReq;
    private HttpServletResponse mRes;
    private ServletContext mServletContext;
    private RevisionCache mRepositoryCache;
    private String mRepName;
    protected WaybackSpec mWB;

    public String getBranchConstraint(Path physicalPath) {
        String br;
        String string = br = this.mWB == null ? null : this.mWB.getBranch();
        if (br == null) {
            br = this.mRepositoryCache.getImpliedBranch(physicalPath);
        }
        return br;
    }

    public FishEyePathInfo getPathInfo() {
        return this.mPI;
    }

    public HttpServletRequest getRequest() {
        return this.mReq;
    }

    public HttpServletResponse getResponse() {
        return this.mRes;
    }

    public ServletContext getServletContext() {
        return this.mServletContext;
    }

    public WebResourceManager getWebResourceManager() {
        return (WebResourceManager)SpringContext.getComponent("webResourceManager");
    }

    public boolean requiresAuth() {
        return !AppConfig.getsConfig().getConfig().getSecurity().getAllowAnon() || !this.getPathInfo().getRepository().isAnonAccessAllowed();
    }

    final void setupInternal(FishEyePathInfo pi, HttpServletRequest req, HttpServletResponse res, ServletContext sctx) {
        this.mPI = pi;
        this.mReq = req;
        this.mRes = res;
        this.mServletContext = sctx;
        this.mRepositoryCache = pi.getEngine().getRevisionCache();
        this.mRepName = pi.getEngine().getName();
        this.mReq.setAttribute("isWatchesEnabled", (Object)(this.isMailerConfigured() && pi.getRepository().isWatchesEnabled() ? 1 : 0));
    }

    public void setup() {
    }

    public RevisionCache getRepositoryCache() {
        return this.mRepositoryCache;
    }

    protected CookiePreferences getUserPreferences() {
        return PreferenceManager.getPreferences(this.getRequest());
    }

    protected boolean handleWaybackJump(String mmodeUrl) throws IOException {
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("wbjump") != null) {
            WaybackSpec wbSpec = WaybackSpec.fromRequest(req);
            String url = req.getContextPath() + mmodeUrl + wbSpec.getUrlCommand() + "/" + ExpressionUtil.urlEncode(pi.getFullPath().getPath());
            this.getResponse().sendRedirect(url);
            return true;
        }
        return false;
    }

    protected void parseWaybackSpec() {
        WaybackSpec wbSpec = WaybackSpec.fromPathInfo(this.getPathInfo());
        if (wbSpec != null) {
            this.getRequest().setAttribute("wbSpec", (Object)wbSpec);
            this.mWB = wbSpec;
        }
    }

    public long computeLastModified() throws DbException {
        return -1L;
    }

    protected long computeRepositoryLastModified() throws DbException {
        return this.mPI.getHandle().getLastModified();
    }

    protected void setupWaybackDropdowns() throws DbException {
        Path lpath = this.getPathInfo().getLocalPath();
        RevisionCache crep = this.getPathInfo().getEngine().getRevisionCache();
        HttpServletRequest req = this.getRequest();
        List<String> branches = crep.findBranches(lpath);
        List<String> authors = crep.findAuthors(lpath);
        if (this.mWB != null) {
            if (this.mWB.getBranch() != null && !branches.contains(this.mWB.getBranch())) {
                branches.add(0, this.mWB.getBranch());
            }
            if (this.mWB.getAuthor() != null && !authors.contains(this.mWB.getAuthor())) {
                authors.add(0, this.mWB.getAuthor());
            }
        }
        req.setAttribute("availableBranches", branches);
        req.setAttribute("availableAuthors", authors);
    }

    public BaseAction processRequest() throws IOException, DbException, ServletException, RCSParser.ParseException {
        try {
            return this.handleRequest();
        }
        catch (PathNotFoundException e2) {
            this.send404(e2.getMessage());
            return null;
        }
    }

    public abstract BaseAction handleRequest() throws ServletException, IOException, DbException, RCSParser.ParseException;

    protected void send404(String msg) throws IOException {
        ServletUtils.send404(this.getRequest(), this.getResponse(), msg);
    }

    protected void sendFileDeleted(FileRevision rev) throws IOException, ServletException {
        Logs.APP_LOG.info((Object)("404: " + rev.getPath() + " of revision " + rev.getRevision() + " deleted. Referer=" + this.getRequest().getHeader("Referer")));
        this.getRequest().setAttribute("fileRevision", (Object)rev);
        this.getResponse().setStatus(404);
        this.getRequest().getRequestDispatcher("/WEB-INF/jsp/annotate_not_found.jsp").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
    }

    protected boolean isMailerConfigured() {
        Mailer mailer = AppConfig.getsConfig().getMailer();
        return mailer != null && mailer.isConfigured();
    }

    protected boolean handleWatches(String mmodeUrl) throws IOException {
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        HttpServletResponse res = this.getResponse();
        Path lPath = pi.getLocalPath();
        UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser(req);
        if (user != null) {
            WatchManager wm = AppConfig.getsConfig().getWatchManager();
            String watchParam = req.getParameter("watch");
            if (watchParam != null) {
                boolean toggled = false;
                if ("on".equals(watchParam)) {
                    try {
                        wm.deleteWatch(user.getUsername(), this.mRepName, lPath);
                        wm.addWatch(user.getUsername(), this.mRepName, lPath, this.mWB);
                    }
                    catch (DbException e2) {
                        Logs.APP_LOG.error((Object)"Error adding watch", (Throwable)e2);
                    }
                    PreferenceManager.touchCookie(req, res);
                    toggled = true;
                } else if ("off".equals(watchParam)) {
                    try {
                        wm.deleteWatch(user.getUsername(), this.mRepName, lPath);
                    }
                    catch (DbException e3) {
                        Logs.APP_LOG.error((Object)"Error deleting watch", (Throwable)e3);
                    }
                    PreferenceManager.touchCookie(req, res);
                    toggled = true;
                }
                if (toggled) {
                    String url = req.getContextPath() + mmodeUrl + (this.mWB != null ? this.mWB.getUrlCommand() : "") + "/" + ExpressionUtil.urlEncode(pi.getFullPath().getPath());
                    this.getResponse().sendRedirect(url);
                    return true;
                }
            }
            try {
                Watch pathWatch = wm.getWatch(user.getUsername(), this.mRepName, lPath);
                if (pathWatch != null) {
                    req.setAttribute("watching", (Object)Boolean.TRUE);
                }
            }
            catch (DbException e4) {
                Logs.APP_LOG.error((Object)"Error accessing watch", (Throwable)e4);
            }
        }
        return false;
    }
}

