/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.vis.ImageMapUtils;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartLine;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.vis.TimeframeVisualiser;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.ChangelogExplorer;
import com.cenqua.fisheye.web.ConfigRssAction;
import com.cenqua.fisheye.web.DirTreeFragmentAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.RepositoryExplorer;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.util.ParamUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;

public class ChangelogServlet
extends BaseAction {
    public long computeLastModified() throws DbException {
        return this.computeRepositoryLastModified();
    }

    public BaseAction handleRequest() throws ServletException, IOException, DbException {
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("dirtreefragrender") != null) {
            return new DirTreeFragmentAction("changelog");
        }
        if (this.handleWaybackJump("/changelog")) {
            return null;
        }
        this.parseWaybackSpec();
        FishEyePathInfo pi = this.getPathInfo();
        if ("rss".equals(pi.getCommandWord())) {
            this.doRssRequest();
            return null;
        }
        String csidStr = req.getParameter("cs");
        String lineGraphParam = this.getRequest().getParameter("linegraph");
        String timelineParam = this.getRequest().getParameter("timeline");
        String timelineClickParam = this.getRequest().getParameter("timelineclick.x");
        String imageMapParam = this.getRequest().getParameter("imageMap");
        String revid = this.getRequest().getParameter("revid");
        if (csidStr != null) {
            this.doViewChangeset(csidStr);
        } else if (revid != null) {
            this.doViewFileRevision(revid);
        } else if (lineGraphParam != null) {
            this.doLineHistory(true);
        } else if (timelineParam != null) {
            this.doTimelineImage();
        } else if (timelineClickParam != null) {
            this.doTimelineClick();
        } else if (imageMapParam != null) {
            this.doImageMap(req, imageMapParam);
        } else {
            this.doViewDir();
        }
        return null;
    }

    private void doImageMap(HttpServletRequest req, String mapName) {
        try {
            CalculatedBucketGraphXY graphs = this.doLineHistory(false);
            req.setAttribute("noData", (Object)graphs.noGraphData());
            String imageMap = "";
            if (!graphs.noGraphData()) {
                imageMap = ImageMapUtils.getImageMapForSubplots(mapName, graphs);
            }
            this.getResponse().getOutputStream().write(imageMap.getBytes());
            this.getResponse().getOutputStream().flush();
        }
        catch (IOException e2) {
            Logs.APP_LOG.warn((Object)("could not create image map for " + req.getRequestURL()), (Throwable)e2);
        }
        catch (DbException e3) {
            Logs.APP_LOG.warn((Object)("could not create image map for " + req.getRequestURL()), (Throwable)e3);
        }
        catch (Throwable e4) {
            Logs.APP_LOG.warn((Object)("could not create image map for " + req.getRequestURL()), e4);
        }
    }

    private void doRssRequest() throws IOException, ServletException, DbException {
        long t0 = System.currentTimeMillis();
        RepositoryEngine rcfg = this.getPathInfo().getEngine();
        RevisionCache crep = rcfg.getRevisionCache();
        HttpServletRequest req = this.getRequest();
        FishEyePathInfo pi = this.getPathInfo();
        Path fpath = pi.getFullPath();
        if ("rss.xml".equals(fpath.getName())) {
            fpath = fpath.trimLast();
        }
        Path lpath = fpath.trimFirst();
        Interval spanVal = ParamUtils.parseSpan(pi.getCommandParam("feedspan"), ConfigRssAction.DEFAULT_SPAN);
        int maxReturn = ParamUtils.parseInt(pi.getCommandParam("feedmax"), 1000);
        long span = Math.min(spanVal.getValueInMillis(), ConfigRssAction.MAX_SPAN.getValueInMillis());
        maxReturn = Math.min(maxReturn, 3000);
        long now = System.currentTimeMillis();
        RecentChangesParams params = new RecentChangesParams();
        params.setMaxReturn(maxReturn);
        params.setMinDate(now - span);
        if (crep.isDir(lpath)) {
            params.setPath(lpath);
        } else {
            params.setPath(lpath.getParent());
            params.setFile(lpath);
        }
        if (this.mWB != null) {
            params.setConstraint(this.mWB.getConstraintQuery3(false));
        }
        if (pi.getCommandParam("norecurse") != null) {
            params.setRecursive(false);
        }
        List revs = crep.findRecentChangeSets(params);
        req.setAttribute("path", (Object)lpath);
        req.setAttribute("fpath", (Object)fpath);
        req.setAttribute("changes", (Object)revs);
        long t1 = System.currentTimeMillis();
        req.getRequestDispatcher("/WEB-INF/jsp/recent-changes-rss-feed.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        long t2 = System.currentTimeMillis();
        if (Logs.PERF_LOG.isDebugEnabled()) {
            Logs.PERF_LOG.debug((Object)("changelogViewDir-rss for /" + lpath + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
        }
    }

    private void doViewDir() throws IOException, ServletException, DbException {
        Long[] d2;
        long t0 = System.currentTimeMillis();
        if (this.handleWatches("/changelog")) {
            return;
        }
        RevisionCache crep = this.getRepositoryCache();
        RepositoryEngine engine = this.getPathInfo().getEngine();
        Path lpath = this.getPathInfo().getLocalPath();
        int changesetsPerPage = 30;
        int filesPerChangeset = 5;
        UserLogin user = AppConfig.getsConfig().getUserManager().getCurrentUser(this.getRequest());
        if (user != null) {
            try {
                UserProfile profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                changesetsPerPage = profile.getChangesetsPerPage();
                filesPerChangeset = profile.getMaxFilesPerChangeset();
            }
            catch (DbException e2) {
                // empty catch block
            }
        }
        ChangelogExplorer clogExplorer = new ChangelogExplorer(lpath, crep, this.mWB);
        String fromId = this.parseChangeSetFromRequest("fromid");
        String toId = this.parseChangeSetFromRequest("toid");
        boolean idBoundInclusive = this.parseBooleanFromRequest("inc", false);
        String showId = this.parseChangeSetFromRequest("showid");
        if (fromId != null) {
            clogExplorer.setFromChangeSetId(fromId);
            clogExplorer.setFromChangeSetIdInc(idBoundInclusive);
        } else if (toId != null) {
            clogExplorer.setToChangeSetId(toId);
            clogExplorer.setToChangeSetIdInc(idBoundInclusive);
        } else if (showId != null) {
            clogExplorer.setShowChangeSetId(showId);
        }
        Long toDate = this.parseLongFromRequest("todate");
        String toFromDate = this.getRequest().getParameter("tofromdate");
        if (toFromDate != null && (d2 = this.parseTwoLongs(toFromDate))[1] != null) {
            toDate = d2[1];
        }
        if (toDate != null) {
            clogExplorer.setToDate(toDate);
        }
        clogExplorer.computeData(changesetsPerPage);
        HttpServletRequest req = this.getRequest();
        req.setAttribute("repository", (Object)new RepositoryExplorer(engine, lpath, this.mWB, this.getUserPreferences()));
        req.setAttribute("changelog", (Object)clogExplorer);
        req.setAttribute("path", (Object)lpath);
        req.setAttribute("fpath", (Object)this.getPathInfo().getFullPath());
        req.setAttribute("maxFilesPerChangeset", (Object)filesPerChangeset);
        this.setupWaybackDropdowns();
        long t1 = System.currentTimeMillis();
        req.getRequestDispatcher("/WEB-INF/jsp/changelogdir.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        long t2 = System.currentTimeMillis();
        if (Logs.PERF_LOG.isDebugEnabled()) {
            Logs.PERF_LOG.debug((Object)("changelogViewDir-page for /" + lpath + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
        }
    }

    private Long[] parseTwoLongs(String s) {
        Long a2 = null;
        Long b2 = null;
        int idx = s.indexOf(45);
        if (idx != -1) {
            try {
                a2 = Long.valueOf(s.substring(0, idx));
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
            try {
                b2 = Long.valueOf(s.substring(idx + 1));
            }
            catch (NumberFormatException e3) {
                // empty catch block
            }
        }
        return new Long[]{a2, b2};
    }

    private CalculatedBucketGraphXY doLineHistory(boolean render) throws IOException, DbException {
        BucketGraph bucketGraph;
        CalculatedBucketGraphXY graphs;
        XYSeries dataset;
        String reqAuthor;
        Path lpath = this.getPathInfo().getLocalPath();
        String br = this.getBranchConstraint(lpath);
        Color thisPageColour = new Color(4, 255, 4, 96);
        long start = this.parseLongFromRequest("sstart", System.currentTimeMillis());
        long end = this.parseLongFromRequest("send", System.currentTimeMillis());
        Dimension d2 = ParamUtils.getDimension(this.getRequest(), 300, 220);
        LineCountChartLine chart = new LineCountChartLine();
        this.getResponse().setContentType(LineCountChartUtils.getImageContentType());
        String extn = "__ALL_EXTENSIONS__";
        String author = "__ALL_AUTHORS__";
        if (this.getPathInfo().getEngine().getRevisionCache().showAuthorLinecount() && this.mWB != null && (reqAuthor = this.mWB.getAuthor()) != null && !reqAuthor.equals("")) {
            author = reqAuthor;
        }
        if ((dataset = (graphs = (bucketGraph = this.getPathInfo().getEngine().getBucketGraph()).getXYSeries(new ParameterSetRetrieve(lpath, br, extn, author, bucketGraph.isCaseSensitive()), d2.width)).getSeriesLinecount()).getItemCount() > 0) {
            start = Math.max(dataset.getDataItem(0).getX().longValue(), start);
        }
        chart.addDateRangeMarker(start, end, thisPageColour);
        XYURLGenerator urlGenerator = new XYURLGenerator(){

            public String generateURL(XYDataset dataset, int series, int item) {
                boolean islast = dataset.getItemCount(series) - 1 == item;
                return islast ? "?" : "?todate=" + dataset.getX(series, item).longValue();
            }
        };
        BufferedImage image = chart.renderPathHistoryImage(graphs, d2.width, d2.height, urlGenerator, LineCountChart.getGraphTimeZone(this.getRequest()), true);
        if (render) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.getResponse().getOutputStream(), (BufferedImage)image);
        }
        return graphs;
    }

    private void doTimelineImage() throws IOException {
        long start = this.parseLongFromRequest("start", System.currentTimeMillis());
        long end = this.parseLongFromRequest("end", System.currentTimeMillis());
        long sstart = this.parseLongFromRequest("sstart", System.currentTimeMillis());
        long send = this.parseLongFromRequest("send", System.currentTimeMillis());
        int width = (int)this.parseLongFromRequest("w", 300L);
        int height = (int)this.parseLongFromRequest("h", 15L);
        TimeframeVisualiser vis = new TimeframeVisualiser(start, end, sstart, send);
        this.getResponse().setContentType(vis.getImageContentType());
        vis.renderTimeline(width, height, (OutputStream)this.getResponse().getOutputStream());
    }

    private void doTimelineClick() throws IOException {
        long start = this.parseLongFromRequest("start", System.currentTimeMillis());
        long end = this.parseLongFromRequest("end", System.currentTimeMillis());
        int width = (int)this.parseLongFromRequest("w", 300L);
        String url = this.getUrlToDir();
        Long l = this.parseLongFromRequest("timelineclick.x");
        if (l == null) {
            this.getResponse().sendRedirect(url);
        } else {
            int x = l.intValue();
            long date = (long)x * (end - start) / (long)width + start;
            this.getResponse().sendRedirect(url + "?todate=" + date);
        }
    }

    private String getUrlToDir() {
        String wb = this.mWB == null ? "" : this.mWB.getUrlCommand();
        return this.getRequest().getContextPath() + "/changelog" + wb + "/" + this.getPathInfo().getFullPath();
    }

    private long parseLongFromRequest(String paramName, long defaultVal) {
        Long l = this.parseLongFromRequest(paramName);
        if (l == null) {
            return defaultVal;
        }
        return l;
    }

    private boolean parseBooleanFromRequest(String name, boolean defaultValue) {
        String val = this.getRequest().getParameter(name);
        return StringUtil.nullOrEmpty(name) ? defaultValue : "true".equalsIgnoreCase(val);
    }

    private String parseChangeSetFromRequest(String paramName) {
        return this.getRequest().getParameter(paramName);
    }

    private Long parseLongFromRequest(String paramName) {
        String str = this.getRequest().getParameter(paramName);
        if (str != null) {
            try {
                return Long.valueOf(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private void doViewFileRevision(String revidParam) throws DbException, ServletException, IOException {
        RevisionCache crep = this.getRepositoryCache();
        try {
            FileRevision info = crep.getFileRevision(Integer.parseInt(revidParam));
            HttpServletRequest req = this.getRequest();
            req.setAttribute("info", (Object)info);
            req.getRequestDispatcher("/WEB-INF/jsp/changeset_showfile.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        }
        catch (NumberFormatException e2) {
            Logs.APP_LOG.warn((Object)("Could not parse revid param to int. " + e2.getMessage()));
        }
    }

    private void doViewChangeset(String csidStr) throws DbException, ServletException, IOException {
        List<String> partialIds;
        long t0 = System.currentTimeMillis();
        HttpServletRequest req = this.getRequest();
        RevisionCache crep = this.getRepositoryCache();
        ChangeSet cs = crep.getChangeSet(csidStr);
        if (cs != null && cs.getRevisionInfosCount() == 0) {
            cs = null;
        }
        boolean isPartial = false;
        if (cs == null && !(partialIds = crep.findSimilarPartialChangeSetIds(csidStr)).isEmpty()) {
            isPartial = true;
            ArrayList<ChangeSet> partialChangesets = new ArrayList<ChangeSet>(partialIds.size());
            Iterator<String> i$ = partialIds.iterator();
            while (i$.hasNext()) {
                String partialId;
                String id = partialId = i$.next();
                partialChangesets.add(crep.getChangeSet(id));
            }
            if (partialChangesets.size() == 1) {
                cs = (ChangeSet)partialChangesets.get(0);
            } else {
                req.setAttribute("partialChangeSetMatches", partialChangesets);
            }
        }
        req.setAttribute("isPartialMatch", (Object)isPartial);
        req.setAttribute("path", (Object)this.getPathInfo().getLocalPath());
        req.setAttribute("fpath", (Object)this.getPathInfo().getFullPath());
        if (cs != null) {
            req.setAttribute("changeset", (Object)cs);
            List<String> similarIds = crep.getSimilarChangeSetIds(cs.getId());
            if (similarIds.size() > 1) {
                req.setAttribute("similarChangeSetIds", similarIds);
            }
            Path lpath = this.getPathInfo().getLocalPath();
            ChangeSet laterCs = this.selectLaterCs(cs, crep, lpath);
            ChangeSet earlierCs = this.selectEarlierCs(cs, crep, lpath);
            req.setAttribute("laterCs", (Object)laterCs);
            req.setAttribute("earlierCs", (Object)earlierCs);
        }
        long t1 = System.currentTimeMillis();
        req.getRequestDispatcher("/WEB-INF/jsp/changeset.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        long t2 = System.currentTimeMillis();
        if (Logs.PERF_LOG.isDebugEnabled()) {
            Logs.PERF_LOG.debug((Object)("changelogViewDir-changeset for " + csidStr + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
        }
    }

    private ChangeSet selectLaterCs(ChangeSet cs, RevisionCache crep, Path path) throws DbException {
        RecentChangesParams params = this.createSimpleParams(path);
        params.setSearchDirection(1);
        params.setMinChangeset(cs, false);
        return this.findFirstChangeSet(params, crep);
    }

    private ChangeSet selectEarlierCs(ChangeSet cs, RevisionCache crep, Path path) throws DbException {
        RecentChangesParams params = this.createSimpleParams(path);
        params.setSearchDirection(0);
        params.setMaxChangeset(cs, false);
        return this.findFirstChangeSet(params, crep);
    }

    private RecentChangesParams createSimpleParams(Path path) {
        RecentChangesParams params = new RecentChangesParams();
        params.setPath(path);
        params.setMaxReturn(1);
        return params;
    }

    private ChangeSet findFirstChangeSet(RecentChangesParams params, RevisionCache crep) throws DbException {
        List changeSets = crep.findRecentChangeSets(params);
        return changeSets.size() > 0 ? changeSets.get(0) : null;
    }
}

