/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import com.cenqua.fisheye.web.util.ParamUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ConfigRssAction
extends BaseAction {
    public static final Interval MAX_SPAN = new Interval("6 months");
    public static final Interval DEFAULT_SPAN = new Interval("1 month");
    public static final int MAX_MAX_RETURN = 3000;
    public static final int DEFAULT_MAX_RETURN = 1000;

    public BaseAction handleRequest() throws ServletException, IOException, DbException, RCSParser.ParseException {
        String params;
        Integer maxret;
        boolean authAllowed;
        HttpServletRequest req = this.getRequest();
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(req);
        boolean resubmitted = req.getParameter("submitted") != null;
        boolean bl = authAllowed = user != null;
        boolean isPreCooked = this.requiresAuth() ? true : req.getParameter("isPreCooked") != null;
        Interval span = ParamUtils.parseSpan(req.getParameter("span"), null);
        if (span != null) {
            if (span.getValueInMillis() > MAX_SPAN.getValueInMillis()) {
                span = MAX_SPAN;
            }
            req.setAttribute("span", (Object)span.toString());
        }
        if ((maxret = ParamUtils.parseInteger(req.getParameter("maxret"), null)) != null) {
            if (maxret.longValue() > 3000L) {
                maxret = 3000;
            }
            req.setAttribute("maxret", (Object)maxret);
        }
        boolean recurse = true;
        if (resubmitted) {
            recurse = req.getParameter("recurse") != null;
            this.mWB = WaybackSpec.fromRequest(req);
        } else {
            this.mWB = WaybackSpec.fromPathInfo(this.getPathInfo());
        }
        if (this.mWB != null) {
            this.getRequest().setAttribute("wbSpec", (Object)this.mWB);
        }
        Path fpath = this.getPathInfo().getFullPath();
        String cpath = req.getParameter("cpath");
        if (cpath == null) {
            cpath = fpath.getPath();
        }
        StringBuffer feeduri = new StringBuffer("changelog/~rss");
        String sep = ",";
        if (this.mWB != null && (params = this.mWB.getUrlCommandParams()).length() > 0) {
            feeduri.append(sep).append(params);
        }
        if (!recurse) {
            feeduri.append(sep).append("norecurse");
        }
        if (span != null) {
            feeduri.append(sep).append("feedspan=").append(span.toString(true));
        }
        if (maxret != null) {
            feeduri.append(sep).append("feedmax=").append(maxret.toString());
        }
        feeduri.append("/").append(ExpressionUtil.urlEncode(cpath)).append("/rss.xml");
        String feedqs = "";
        if (isPreCooked) {
            LoginCookie lc = um.preCookUrl(req, "/" + feeduri, false);
            if (lc == null) {
                isPreCooked = false;
            } else {
                feedqs = "?FEAUTH=" + lc.encode();
            }
        }
        String siteurl = (String)req.getAttribute("siteurl");
        String feedUrl = siteurl + feeduri.toString() + feedqs;
        req.setAttribute("path", (Object)this.getPathInfo().getLocalPath());
        req.setAttribute("fpath", (Object)fpath);
        req.setAttribute("cpath", (Object)cpath);
        req.setAttribute("feedUrl", (Object)feedUrl);
        req.setAttribute("authAllowed", (Object)authAllowed);
        req.setAttribute("requiresAuth", (Object)this.requiresAuth());
        req.setAttribute("isPreCooked", (Object)isPreCooked);
        req.setAttribute("recurse", (Object)recurse);
        req.setAttribute("defaultSpan", (Object)DEFAULT_SPAN);
        req.setAttribute("defaultMaxret", (Object)1000);
        this.setupWaybackDropdowns();
        req.getRequestDispatcher("/WEB-INF/jsp/feedconfig.jsp").forward((ServletRequest)req, (ServletResponse)this.getResponse());
        return null;
    }
}

