/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.RepositoryExplorer;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirTreeFragmentAction
extends BaseAction {
    private final String targetCommand;

    public DirTreeFragmentAction(String targetCommand) {
        this.targetCommand = targetCommand;
    }

    public long computeLastModified() throws DbException {
        return this.computeRepositoryLastModified();
    }

    public BaseAction handleRequest() throws ServletException, IOException, DbException {
        FishEyePathInfo pi = this.getPathInfo();
        Path lPath = pi.getLocalPath();
        this.parseWaybackSpec();
        RevisionCache rep = this.getRepositoryCache();
        if (rep.isDir(lPath)) {
            return this.handleDirRequest();
        }
        Logs.APP_LOG.info((Object)("AJAX dirtree fragment was not a directory: " + lPath));
        PrintWriter writer = this.getResponse().getWriter();
        writer.write("<b>error</b>");
        writer.close();
        return null;
    }

    private BaseAction handleDirRequest() throws IOException, ServletException, DbException {
        long t0 = System.currentTimeMillis();
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        HttpServletResponse resp = this.getResponse();
        Path lpath = pi.getLocalPath();
        HashMap params = new HashMap(req.getParameterMap());
        params.remove("dirtreefragrender");
        req.setAttribute("targetCommand", (Object)this.targetCommand);
        req.setAttribute("queryStrSuffix", (Object)this.parameterMapToString(params));
        req.setAttribute("repository", (Object)new RepositoryExplorer(pi.getEngine(), lpath, this.mWB, this.getUserPreferences()));
        long t1 = System.currentTimeMillis();
        req.getRequestDispatcher("/WEB-INF/jsp/dirtreefrag.jsp").forward((ServletRequest)req, (ServletResponse)resp);
        long t2 = System.currentTimeMillis();
        if (Logs.PERF_LOG.isDebugEnabled()) {
            Logs.PERF_LOG.debug((Object)("handleDirRequest-dirtreefrag for /" + lpath + " in " + (t1 - t0) + "ms then " + (t2 - t1) + "ms for render"));
        }
        return null;
    }

    private String parameterMapToString(Map params) {
        StringBuffer qs = new StringBuffer();
        String sep = "";
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (values == null) continue;
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                qs.append(ExpressionUtil.urlEncode(key)).append("=").append(ExpressionUtil.urlEncode(value));
                qs.append(sep);
                sep = "&";
            }
        }
        return qs.toString();
    }
}

