/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.WaybackSpec;
import com.cenqua.fisheye.web.dirtree.DirTree;
import java.util.ArrayList;
import java.util.List;

public class RepositoryExplorer {
    public final RepositoryEngine mEngine;
    public final RevisionCache mCRep;
    private final Path mLPath;
    public final WaybackSpec mWB;
    public final LuceneConnection mConn;
    public final CookiePreferences mUP;
    private final boolean mHideDeletedFiles;
    private int mDeletedFilesCount = 0;
    private int mNumRecentChangeSets = 10;
    private List mCachedFiles = null;
    private int mWbSkippedCount = 0;
    private DirTree mDirTree;

    public RepositoryExplorer(RepositoryEngine eng, Path aLocalPath, WaybackSpec wb, CookiePreferences up) throws DbException {
        this.mEngine = eng;
        this.mLPath = aLocalPath;
        this.mCRep = this.mEngine.getRevisionCache();
        this.mConn = eng.getLuceneConnection();
        this.mWB = wb;
        this.mUP = up;
        this.mHideDeletedFiles = this.mUP.getPreference("hideDeletedFiles").equals("Y");
        this.mDirTree = new DirTree(this);
    }

    public int getNumRecentChangeSets() {
        return this.mNumRecentChangeSets;
    }

    public boolean isCaseSensitive() {
        return this.mCRep.isCaseSensitive();
    }

    public String getName() {
        return this.mEngine.getName();
    }

    public void setNumRecentChangeSets(int numRecentChangeSets) {
        this.mNumRecentChangeSets = numRecentChangeSets;
    }

    public DirTree getDirTree() {
        return this.mDirTree;
    }

    public FileRevision getDirRevision() throws DbException {
        return this.mCRep.getLatestFileRevision(this.mLPath);
    }

    public boolean isHideDeletedFiles() {
        return this.mHideDeletedFiles;
    }

    public boolean isShowChangelogCalendar() {
        return this.mEngine.getCfg().getRepositoryProperties().isShowChangelogCalendar();
    }

    public boolean isLineHistoryEnabled() {
        return this.mEngine.getCfg().getRepositoryProperties().isLineHistoryEnabled();
    }

    public int getDeletedFilesCount() throws DbException {
        this.getFiles();
        return this.mDeletedFilesCount;
    }

    public List getRecentChangeSets() {
        try {
            RecentChangesParams params = new RecentChangesParams();
            params.setPath(this.getLocalPath());
            params.setMaxReturn(this.mNumRecentChangeSets);
            if (this.mWB != null) {
                params.setConstraint(this.mWB.getConstraintQuery3(false));
            }
            return this.mCRep.findRecentChangeSets(params);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"could not compute recent changed", (Throwable)e2);
            return null;
        }
    }

    public List getFiles() throws DbException {
        if (this.mCachedFiles == null) {
            Path[] paths = this.mCRep.listFiles(this.getLocalPath());
            ArrayList<FileExplorerInfo> files = new ArrayList<FileExplorerInfo>(paths.length);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                Path path = paths[i2];
                FileHistory hist = this.mCRep.getFileHistory(path);
                if (hist == null) {
                    files.add(new FileExplorerInfo(path));
                    continue;
                }
                FileRevision bestMatch = null;
                for (FileRevision ri : hist.getRevisions()) {
                    if (this.mWB != null && !this.mWB.matches(ri, true)) continue;
                    if (bestMatch == null) {
                        bestMatch = ri;
                        continue;
                    }
                    if (ri.getDate() <= bestMatch.getDate()) continue;
                    bestMatch = ri;
                }
                if (bestMatch == null && this.mWB != null) {
                    ++this.mWbSkippedCount;
                    continue;
                }
                if (bestMatch != null) {
                    boolean skip = false;
                    if (bestMatch.isDead()) {
                        ++this.mDeletedFilesCount;
                        if (this.mHideDeletedFiles) {
                            skip = true;
                        }
                    }
                    if (skip) continue;
                    boolean isMain = bestMatch.getBranch().equals(hist.getMainBranch());
                    files.add(new FileExplorerInfo(path, bestMatch, isMain));
                    continue;
                }
                files.add(new FileExplorerInfo(path));
            }
            this.mCachedFiles = files;
        }
        return this.mCachedFiles;
    }

    public int getWaybackSkippedCount() throws DbException {
        this.getFiles();
        return this.mWbSkippedCount;
    }

    public Path getLocalPath() {
        return this.mLPath;
    }

    public String toString() {
        return "RepositoryExplorer[" + this.getName() + "/" + this.getLocalPath() + "]";
    }

    static class BestMatch {
        final RevInfoKey rkey;
        final long date;

        public BestMatch(RevInfoKey rkey, long date) {
            this.rkey = rkey;
            this.date = date;
        }
    }

    public class FileExplorerInfo {
        private final Path mPath;
        private final FileRevision mLatestRevision;
        private final boolean isTrunk;

        public FileExplorerInfo(Path path) {
            this.mPath = path;
            this.mLatestRevision = null;
            this.isTrunk = true;
        }

        public FileExplorerInfo(Path path, FileRevision latestRevision, boolean isTrunk) {
            this.mPath = path;
            this.mLatestRevision = latestRevision;
            this.isTrunk = isTrunk;
        }

        public Path getPath() {
            return this.mPath;
        }

        public FileRevision getLatestRevision() {
            return this.mLatestRevision;
        }

        public boolean isLatestBranchNeedsExplaining() {
            if (this.mLatestRevision == null) {
                return false;
            }
            if (RepositoryExplorer.this.mWB != null && RepositoryExplorer.this.mWB.getBranch() != null) {
                return !this.mLatestRevision.getBranch().equals(RepositoryExplorer.this.mWB.getBranch());
            }
            return !this.isTrunk;
        }
    }
}

