/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cvsrep.search.query.AndClause;
import com.cenqua.fisheye.cvsrep.search.query.AuthorsClause;
import com.cenqua.fisheye.cvsrep.search.query.Clause;
import com.cenqua.fisheye.cvsrep.search.query.DateRangeClause;
import com.cenqua.fisheye.cvsrep.search.query.OnBranchClause;
import com.cenqua.fisheye.cvsrep.search.query.TaggedClause;
import com.cenqua.fisheye.infinitydb.query3.AndQuery3;
import com.cenqua.fisheye.infinitydb.query3.AnyLongRangeQuery3;
import com.cenqua.fisheye.infinitydb.query3.OrQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermLookupQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.MultiMap;
import com.cenqua.fisheye.web.CommandString;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaybackSpec {
    private String mBranch;
    private String mTag;
    private String mDateStr;
    private String mAuthor;
    private long mDate;

    public String getAuthor() {
        return this.mAuthor;
    }

    public void setAuthor(String author) {
        this.mAuthor = author;
    }

    public String getBranch() {
        return this.mBranch;
    }

    public String getTag() {
        return this.mTag;
    }

    public String getDateStr() {
        return this.mDateStr;
    }

    public void setBranch(String branch) {
        this.mBranch = branch;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public void setDateStr(String dateStr) {
        this.mDateStr = dateStr;
    }

    public void setDate(long date) {
        this.mDate = date;
    }

    public Clause getEyeQLWhereClause(boolean considerBranchPointOnBranch) {
        AndClause and = null;
        if (this.mBranch != null) {
            and = WaybackSpec.createIfNull(and);
            and.addClause(new OnBranchClause(this.mBranch, !considerBranchPointOnBranch, false, false));
        }
        if (this.mAuthor != null) {
            and = WaybackSpec.createIfNull(and);
            and.addClause(new AuthorsClause(this.mAuthor.toLowerCase(Locale.US)));
        }
        if (this.mDateStr != null) {
            and = WaybackSpec.createIfNull(and);
            and.addClause(new DateRangeClause(Long.MIN_VALUE, true, this.mDate, true));
        }
        if (this.mTag != null) {
            and = WaybackSpec.createIfNull(and);
            and.addClause(new TaggedClause(this.mTag, 1));
        }
        return and;
    }

    public AndQuery3 getConstraintQuery3(boolean considerBranchPointOnBranch) {
        AndQuery3 bq = null;
        if (this.mBranch != null) {
            bq = WaybackSpec.createIfNull(bq);
            if (considerBranchPointOnBranch) {
                OrQuery3 q = new OrQuery3();
                q.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, this.mBranch, null));
                q.addClause(new TermQuery3(CommonSchema.E_UNMOD_ON_BRANCH_TO_REVID, this.mBranch, null));
                q.addClause(new TermQuery3(CommonSchema.E_BP_ON_BRANCH_TO_REVID, this.mBranch, null));
                bq.addClause(q);
            } else {
                bq.addClause(new TermQuery3(CommonSchema.E_MOD_ON_BRANCH_TO_REVID, this.mBranch, null));
            }
        }
        if (this.mAuthor != null) {
            bq = WaybackSpec.createIfNull(bq);
            bq.addClause(new TermQuery3(CommonSchema.E_AUTHOR_TO_REVID, this.mAuthor.toLowerCase(Locale.US), null));
        }
        if (this.mDateStr != null) {
            bq = WaybackSpec.createIfNull(bq);
            bq.addClause(new AnyLongRangeQuery3(CommonSchema.E_DATE_TO_REVID, Long.MIN_VALUE, true, this.mDate, true));
        }
        if (this.mTag != null) {
            bq = WaybackSpec.createIfNull(bq);
            bq.addClause(new TermLookupQuery3(CommonSchema.E_TAGS, CommonSchema.E_TAG_TO_REVID, this.mTag, null));
        }
        return bq;
    }

    private static AndQuery3 createIfNull(AndQuery3 bq) {
        if (bq == null) {
            bq = new AndQuery3();
        }
        return bq;
    }

    private static AndClause createIfNull(AndClause clause) {
        if (clause == null) {
            clause = new AndClause();
        }
        return clause;
    }

    public boolean matches(FileRevision info, boolean considerBranchPointOnBranch) {
        boolean matches = true;
        if (this.mBranch != null) {
            matches &= this.mBranch.equals(info.getBranch()) || considerBranchPointOnBranch && info.getBranches().contains(this.mBranch);
        }
        if (this.mAuthor != null) {
            matches &= this.mAuthor.equals(info.getAuthor());
        }
        if (this.mTag != null) {
            matches &= info.getTags().contains(this.mTag);
        }
        if (this.mDateStr != null) {
            matches &= info.getDate() <= this.mDate;
        }
        return matches;
    }

    public String getUrlCommandBrowse() {
        String params = this.getUrlCommandParamsBrowse();
        if (params.length() == 0) {
            return "";
        }
        return "/~" + params;
    }

    public String getUrlCommand() {
        String params = this.getUrlCommandParams();
        if (params.length() == 0) {
            return "";
        }
        return "/~" + params;
    }

    public String getUrlCommandParams2() {
        return "," + this.getUrlCommandParams();
    }

    public String getUrlCommandParamsChart2() {
        return "," + this.getUrlCommandParams();
    }

    public String getUrlCommandParams() {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        if (this.mBranch != null) {
            buf.append(sep);
            buf.append("br=").append(ExpressionUtil.urlEncode(this.mBranch));
            sep = ",";
        }
        if (this.mAuthor != null) {
            buf.append(sep);
            buf.append("author=").append(ExpressionUtil.urlEncode(this.mAuthor));
            sep = ",";
        }
        if (this.mTag != null) {
            buf.append(sep);
            buf.append("tag=").append(ExpressionUtil.urlEncode(this.mTag));
            sep = ",";
        }
        if (this.mDateStr != null) {
            buf.append(sep);
            buf.append("date=").append(ExpressionUtil.urlEncode(this.mDateStr));
            sep = ",";
        }
        return buf.toString();
    }

    public String getUrlCommandParamsBrowse() {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        if (this.mBranch != null) {
            buf.append(sep);
            buf.append("br=").append(ExpressionUtil.urlEncode(this.mBranch));
            sep = ",";
        }
        if (this.mAuthor != null) {
            buf.append(sep);
            buf.append("author=").append(ExpressionUtil.urlEncode(this.mAuthor));
            sep = ",";
        }
        if (this.mTag != null) {
            buf.append(sep);
            buf.append("tag=").append(ExpressionUtil.urlEncode(this.mTag));
            sep = ",";
        }
        if (this.mDateStr != null) {
            buf.append(sep);
            buf.append("date=").append(ExpressionUtil.urlEncode(this.mDateStr));
            sep = ",";
        }
        return buf.toString();
    }

    public String toString() {
        return this.getUrlCommandParams();
    }

    public boolean isNoOp() {
        return this.mBranch == null && this.mAuthor == null && this.mTag == null && this.mDateStr == null;
    }

    public String getDisplayString() {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        if (this.mBranch != null) {
            buf.append(sep);
            buf.append("branch=").append(ExpressionUtil.escapeString(this.mBranch));
            sep = ",";
        }
        if (this.mAuthor != null) {
            buf.append(sep);
            buf.append("author=").append(ExpressionUtil.escapeString(this.mAuthor));
            sep = ",";
        }
        if (this.mTag != null) {
            buf.append(sep);
            buf.append("tag=").append(ExpressionUtil.escapeString(this.mTag));
            sep = ",";
        }
        if (this.mDateStr != null) {
            buf.append(sep);
            buf.append("date=").append(ExpressionUtil.escapeString(this.mDateStr));
            sep = ",";
        }
        return buf.toString();
    }

    public static WaybackSpec fromRequest(HttpServletRequest req) {
        return WaybackSpec.fromRequest(req, new WaybackSpec());
    }

    public static WaybackSpec fromRequest(HttpServletRequest req, WaybackSpec wb) {
        TimeZone tz;
        long now;
        Long d2;
        String wbdate;
        String wbtag;
        String wbAuth;
        String wbbr = req.getParameter("wbbr");
        if (!WaybackSpec.isEmpty(wbbr)) {
            wb.setBranch(wbbr.trim());
        }
        if (!WaybackSpec.isEmpty(wbAuth = req.getParameter("wbauthor"))) {
            wb.setAuthor(wbAuth.trim());
        }
        if (!WaybackSpec.isEmpty(wbtag = req.getParameter("wbtag"))) {
            wb.setTag(wbtag.trim());
        }
        if (!WaybackSpec.isEmpty(wbdate = req.getParameter("wbdate")) && (d2 = DateHelper.parseDate(wbdate = wbdate.trim(), now = System.currentTimeMillis(), tz = AppConfig.getsConfig().getTimezone())) != null) {
            wb.setDateStr(wbdate);
            wb.setDate(d2);
        }
        return wb;
    }

    protected static boolean isEmpty(String wbbr) {
        return wbbr == null || wbbr.trim().length() == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaybackSpec that = (WaybackSpec)o;
        if (this.mAuthor != null ? !this.mAuthor.equals(that.mAuthor) : that.mAuthor != null) {
            return false;
        }
        if (this.mBranch != null ? !this.mBranch.equals(that.mBranch) : that.mBranch != null) {
            return false;
        }
        if (this.mDateStr != null ? !this.mDateStr.equals(that.mDateStr) : that.mDateStr != null) {
            return false;
        }
        return !(this.mTag != null ? !this.mTag.equals(that.mTag) : that.mTag != null);
    }

    public int hashCode() {
        int result = this.mBranch != null ? this.mBranch.hashCode() : 0;
        result = 29 * result + (this.mTag != null ? this.mTag.hashCode() : 0);
        result = 29 * result + (this.mDateStr != null ? this.mDateStr.hashCode() : 0);
        result = 29 * result + (this.mAuthor != null ? this.mAuthor.hashCode() : 0);
        return result;
    }

    public static WaybackSpec fromPathInfo(FishEyePathInfo pi) {
        return WaybackSpec.fromCommandString(pi.getCommandString());
    }

    public static WaybackSpec fromCommandString(CommandString cs) {
        TimeZone tz;
        long now;
        Long d2;
        if (cs == null) {
            return null;
        }
        WaybackSpec wb = new WaybackSpec();
        boolean okay = false;
        String s = cs.getCommandParam("br");
        if (s != null) {
            wb.setBranch(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("author")) != null) {
            wb.setAuthor(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("tag")) != null) {
            wb.setTag(s);
            okay = true;
        }
        if ((s = cs.getCommandParam("date")) != null && (d2 = DateHelper.parseDate(s, now = System.currentTimeMillis(), tz = AppConfig.getsConfig().getTimezone())) != null) {
            wb.setDateStr(s);
            wb.setDate(d2);
            okay = true;
        }
        return okay ? wb : null;
    }

    public CommandString toCommandString() {
        return new CommandString(null, this.getCommandParams());
    }

    public MultiMap<String, String> getCommandParams() {
        MultiMap<String, String> params = new MultiMap<String, String>(new LinkedHashMap());
        if (this.mBranch != null) {
            params.add("br", this.mBranch);
        }
        if (this.mAuthor != null) {
            params.add("author", this.mAuthor);
        }
        if (this.mTag != null) {
            params.add("tag", this.mTag);
        }
        if (this.mDateStr != null) {
            params.add("date", this.mDateStr);
        }
        return params;
    }
}

