/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public abstract class AbstractAddAllowAction
extends BaseRepositoryAction {
    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        AllowType allow = null;
        if (this.isDefault()) {
            allow = cfg.getRepositoryDefaults().getAllow();
        } else {
            try {
                RepositoryType repository = cfg.getRepositoryArray(this.getRep());
                if (!repository.isSetAllow()) {
                    allow = AllowType.Factory.newInstance();
                    repository.setAllow(allow);
                }
                allow = repository.getAllow();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
        }
        try {
            this.addAllow(allow);
            this.saveCfg();
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad allow index " + this.getIdx() + ", rep=" + this.getRep() + ",def=" + this.isDefault());
            return "error";
        }
        return "success";
    }

    public String doDefault() throws Exception {
        return "success";
    }

    protected abstract void addAllow(AllowType var1);
}

