/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.TarballType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class AddTarballExcludeAction
extends BaseRepositoryAction {
    private boolean subdirs;
    private String basedir;

    public boolean isSubdirs() {
        return this.subdirs;
    }

    public void setSubdirs(boolean subdirs) {
        this.subdirs = subdirs;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        TarballType.Exclude saving = TarballType.Exclude.Factory.newInstance();
        int idx = 0;
        if (this.subdirs) {
            saving.setTree(this.basedir);
        } else {
            saving.setDir(this.basedir);
        }
        try {
            TarballType tarball;
            if (this.isDefault()) {
                tarball = cfg.getRepositoryDefaults().getTarball();
            } else {
                try {
                    RepositoryType repository = cfg.getRepositoryArray(this.getRep());
                    tarball = repository.getTarball();
                }
                catch (IndexOutOfBoundsException e2) {
                    this.addActionError("Bad repository index " + this.getRep());
                    return "error";
                }
            }
            idx = tarball.getExcludeArray().length;
            tarball.insertNewExclude(idx);
            tarball.setExcludeArray(idx, saving);
            this.saveCfg();
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad tarball exclude index " + idx + ", rep=" + this.getRep() + ",def=" + this.isDefault());
            return "error";
        }
        return "success";
    }

    public String doDefault() throws Exception {
        return "success";
    }
}

