/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.web.admin.actions.AbstractLinkerAction;

public class DeleteLinkerAction
extends AbstractLinkerAction {
    private String type;
    private static final String TYPE_SIMPLE = "simple";
    private static final String TYPE_ADVANCED = "advanced";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String execute() throws Exception {
        block8: {
            ConfigDocument.Config cfg = this.getCfg();
            LinkerType linker = null;
            if (this.isDefault()) {
                linker = cfg.getRepositoryDefaults().getLinker();
            } else {
                try {
                    linker = cfg.getRepositoryArray(this.getRep()).getLinker();
                }
                catch (IndexOutOfBoundsException e2) {
                    this.addActionError("Bad repository index " + this.getRep());
                    return "error";
                }
            }
            try {
                if (TYPE_SIMPLE.equals(this.type)) {
                    linker.removeSimple(this.getIdx());
                    break block8;
                }
                if (TYPE_ADVANCED.equals(this.type)) {
                    linker.removeAdvanced(this.getIdx());
                    break block8;
                }
                this.addActionError("Unknown linker type '" + this.type + "'");
                return "error";
            }
            catch (IndexOutOfBoundsException e3) {
                this.addActionError("Bad linker index " + this.getIdx() + ", rep=" + this.getRep());
                return "error";
            }
        }
        this.updateLinkers();
        return "success";
    }
}

