/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.Ajp13ServerType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import com.opensymphony.xwork.ActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;

public class EditServerSettingsAction
extends ActionSupport {
    private HttpServerType http = this.getCfg().getWebServer().isSetHttp() ? (HttpServerType)this.getCfg().getWebServer().getHttp().copy() : HttpServerType.Factory.newInstance();
    private Ajp13ServerType ajp13 = this.getCfg().getWebServer().isSetAjp13() ? (Ajp13ServerType)this.getCfg().getWebServer().getAjp13().copy() : Ajp13ServerType.Factory.newInstance();
    private String context;
    private boolean apiEnabled;
    private String timezone;
    private String siteUrl;

    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public HttpServerType getHttp() {
        return this.http;
    }

    public Ajp13ServerType getAjp13() {
        return this.ajp13;
    }

    public boolean isApiEnabled() {
        return this.apiEnabled;
    }

    public void setApiEnabled(boolean apiEnabled) {
        this.apiEnabled = apiEnabled;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getDefaultTimezone() {
        return AppConfig.getsConfig().getTimezone().getID();
    }

    public String getSiteUrl() {
        return this.siteUrl;
    }

    public void setSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
    }

    public Collection getTimezones() {
        ArrayList<String> l = new ArrayList<String>(DateHelper.AVAILABLE_TIMEZONE_IDS.size() + 1);
        l.add("");
        l.addAll(DateHelper.AVAILABLE_TIMEZONE_IDS);
        return l;
    }

    public boolean isDebugMode() {
        return Logs.isDebugMode();
    }

    public String toggleDebug() {
        if (this.isDebugMode()) {
            Logs.APP_LOG.info((Object)("Disabling DEBUG, log level was " + Logs.ROOT.getLevel() + " but will now be set to WARN"));
            Logs.disableDebugMode();
        } else {
            String previousLevel = Logs.ROOT.getLevel().toString();
            Logs.setupDebugMode();
            Logs.APP_LOG.info((Object)("Turning ON DEBUG, log level was " + previousLevel + " but will now be set to INFO"));
        }
        return "success";
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        WebServerType ws = cfg.getWebServer();
        this.configureHttp(ws);
        this.configureAjp13(ws);
        if (!ws.isSetAjp13() && !ws.isSetHttp()) {
            throw new ConfigException("Neither ajp13 nor http Bind Address set.");
        }
        if (EditServerSettingsAction.nullOrEmpty(this.context)) {
            if (ws.isSetContext()) {
                ws.unsetContext();
            }
        } else {
            ws.setContext(this.context);
        }
        cfg.getApi().setEnabled(this.apiEnabled);
        if (this.timezone == null || this.timezone.trim().length() == 0) {
            if (cfg.isSetTimezone()) {
                cfg.unsetTimezone();
            }
        } else {
            TimeZone tz = TimeZone.getTimeZone(this.timezone);
            cfg.setTimezone(tz.getID());
        }
        if (EditServerSettingsAction.nullOrEmpty(this.siteUrl)) {
            if (ws.isSetSiteUrl()) {
                ws.unsetSiteUrl();
            }
        } else {
            ws.setSiteUrl(this.siteUrl);
        }
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().reload();
        return "success";
    }

    private void configureAjp13(WebServerType ws) {
        if (EditServerSettingsAction.nullOrEmpty(this.ajp13.getBind())) {
            if (ws.isSetAjp13()) {
                ws.unsetAjp13();
            }
            return;
        }
        ws.setAjp13(this.ajp13);
    }

    private void configureHttp(WebServerType ws) {
        if (EditServerSettingsAction.nullOrEmpty(this.http.getBind())) {
            if (ws.isSetHttp()) {
                ws.unsetHttp();
            }
            return;
        }
        if (this.http.isSetProxyHost() && EditServerSettingsAction.nullOrEmpty(this.http.getProxyHost())) {
            this.http.unsetProxyHost();
        }
        if (this.http.isSetProxyScheme() && EditServerSettingsAction.nullOrEmpty(this.http.getProxyScheme())) {
            this.http.unsetProxyScheme();
        }
        if (this.http.isSetProxyPort() && this.http.getProxyPort() == null) {
            this.http.unsetProxyPort();
        }
        ws.setHttp(this.http);
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public String doDefault() throws Exception {
        this.http = this.getCfg().getWebServer().getHttp();
        this.context = this.getCfg().getWebServer().getContext();
        this.apiEnabled = this.getCfg().getApi().getEnabled();
        this.timezone = this.getCfg().getTimezone();
        this.siteUrl = "";
        if (this.getCfg().getWebServer().isSetSiteUrl()) {
            this.siteUrl = this.getCfg().getWebServer().getSiteUrl();
        }
        return "success";
    }
}

