/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.SvnConfigType;
import com.opensymphony.xwork.ActionSupport;
import java.io.File;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class EditSvnConfigAction
extends ActionSupport {
    private SvnConfigType svnConfig;

    public SvnConfigType getSvnConfig() {
        if (this.svnConfig == null) {
            ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
            if (!cfg.isSetSvnConfig()) {
                cfg.addNewSvnConfig();
            }
            this.svnConfig = (SvnConfigType)cfg.getSvnConfig().copy();
        }
        return this.svnConfig;
    }

    public String execute() throws Exception {
        SvnConfigType editing = this.getSvnConfig();
        if (editing.isSetJar() && EditSvnConfigAction.nullOrEmpty(editing.getJar())) {
            editing.unsetJar();
        } else {
            try {
                String interfaceName;
                JarFile jarFile;
                JarEntry entry;
                if (this.checkFileExists(editing.getJar()) && (entry = (jarFile = new JarFile(editing.getJar())).getJarEntry(interfaceName = "org/tigris/subversion/javahl/SVNClientInterface.class")) == null) {
                    this.addActionMessage("The jar " + editing.getJar() + " does not appear to be a SVN jar as it does not contain the " + interfaceName + " interface.");
                }
            }
            catch (Exception e2) {
                this.addActionMessage("Error loading jar - " + editing.getJar());
            }
        }
        if (editing.isSetJnilib() && EditSvnConfigAction.nullOrEmpty(editing.getJnilib())) {
            editing.unsetJnilib();
        } else {
            this.checkFileExists(editing.getJnilib());
        }
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        cfg.setSvnConfig(editing);
        AppConfig.getsConfig().saveConfig();
        return this.hasActionMessages() ? "input" : "success";
    }

    private boolean checkFileExists(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
            this.addActionMessage(file.getAbsolutePath() + " does not exist or can not be accessed.");
            return false;
        }
        catch (Exception e2) {
            this.addActionMessage("Could not load file - " + path + ". " + e2.getMessage());
            return false;
        }
    }

    private static boolean nullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

