/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.CvsUpdaterType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class EditUpdaterCvsAction
extends BaseRepositoryAction {
    private CvsUpdaterType.Historyfile history = CvsUpdaterType.Historyfile.Factory.newInstance();
    private String verify;

    public void setVerify(String verify) {
        this.verify = verify;
    }

    public CvsUpdaterType.Historyfile getHistory() {
        return this.history;
    }

    public RepositoryType getRepository() {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        try {
            return cfg.getRepositoryArray(this.getRep());
        }
        catch (IndexOutOfBoundsException e2) {
            Logs.APP_LOG.info((Object)"admin error: ", (Throwable)e2);
            this.addActionError("Bad repository index " + this.getRep());
            return null;
        }
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        try {
            CvsRepType cvs = cfg.getRepositoryArray(this.getRep()).getCvs();
            if (this.history.isSetStripPrefix() && this.history.getStripPrefix().length() == 0) {
                this.history.unsetStripPrefix();
            }
            CvsUpdaterType updater = CvsUpdaterType.Factory.newInstance();
            updater.setHistoryfile(this.history);
            cvs.setUpdater(updater);
            this.saveCfg();
        }
        catch (IndexOutOfBoundsException e2) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        return this.verify != null ? "verify" : "success";
    }

    public String doDefault() throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        try {
            CvsRepType cvs = cfg.getRepositoryArray(this.getRep()).getCvs();
            if (cvs.isSetUpdater()) {
                CvsUpdaterType.Historyfile editing = cvs.getUpdater().getHistoryfile();
                this.history.setFile(editing.getFile());
                this.history.setFullScanPeriod(editing.getFullScanPeriod());
                if (editing.isSetStripPrefix()) {
                    this.history.setStripPrefix(editing.getStripPrefix());
                }
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        try {
            new Interval(this.history.getFullScanPeriod());
        }
        catch (NumberFormatException ex) {
            this.addFieldError("history.fullScanPeriod", "Invalid interval format. Use something like \"15 minutes\",\"15m\",\"2 hours\",\"2h\",\"1 day\",\"1d\"");
        }
    }
}

