/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.PolledUpdaterType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class EditUpdaterPolledAction
extends BaseRepositoryAction {
    private PolledUpdaterType updater = PolledUpdaterType.Factory.newInstance();

    public RepositoryType getRepository() {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        try {
            return cfg.getRepositoryArray(this.getRep());
        }
        catch (IndexOutOfBoundsException e2) {
            Logs.APP_LOG.info((Object)"admin error: ", (Throwable)e2);
            this.addActionError("Bad repository index " + this.getRep());
            return null;
        }
    }

    public PolledUpdaterType getUpdater() {
        return this.updater;
    }

    public PolledUpdaterType getRepoUpdater(RepositoryType repository, boolean createIfRequired) {
        if (repository.isSetSvn()) {
            SvnRepType svn = repository.getSvn();
            if (!svn.isSetUpdater() && createIfRequired) {
                svn.addNewUpdater();
            }
            return svn.getUpdater();
        }
        if (repository.isSetPerforce()) {
            P4RepType p4 = repository.getPerforce();
            if (!p4.isSetUpdater() && createIfRequired) {
                p4.addNewUpdater();
            }
            return p4.getUpdater();
        }
        return null;
    }

    public String execute() throws Exception {
        try {
            PolledUpdaterType repoUpdater = this.getRepoUpdater(this.getRepository(), true);
            if (repoUpdater != null) {
                repoUpdater.setPollPeriod(this.updater.getPollPeriod());
                this.saveCfg();
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        return "success";
    }

    public String doDefault() throws Exception {
        try {
            PolledUpdaterType repoUpdater = this.getRepoUpdater(this.getRepository(), false);
            if (repoUpdater != null) {
                this.updater = repoUpdater;
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.addActionError("Bad repository index " + this.getRep());
            return "error";
        }
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        try {
            if (!this.updater.getPollPeriod().trim().equalsIgnoreCase("never")) {
                new Interval(this.updater.getPollPeriod());
            }
        }
        catch (NumberFormatException ex) {
            this.addFieldError("updater.pollPeriod", "Invalid interval format. Use something like \"15 minutes\",\"15m\",\"2 hours\",\"2h\",\"1 day\",\"1d\"");
        }
    }
}

