/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.BaseAuth;
import com.cenqua.fisheye.user.CustomAuth;
import com.cenqua.fisheye.user.ldap.LDAPAuth;
import com.cenqua.fisheye.user.os.HostAuth;
import com.opensymphony.xwork.ActionSupport;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class AuthTestAction
extends ActionSupport {
    private String username;
    private String password;
    protected TestResults results;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public TestResults getResults() {
        return this.results;
    }

    protected void addResult(String msg, boolean success) {
        this.results.results.add(new Result(msg, success));
    }

    protected void addResult(String msg) {
        this.results.results.add(new Result(msg, true));
    }

    public boolean getHasResults() {
        return this.results != null;
    }

    protected void doTests(BaseAuth auth) {
        BaseAuth.AuthTok authTok = auth.checkPassword(this.getUsername(), this.getPassword(), null, null);
        if (authTok == null) {
            this.addResult("username/password check failed", false);
            return;
        }
        this.addResult("username/password succeeded");
        if (authTok instanceof LDAPAuth.LdapAuthTok) {
            this.addResult("user's DN is " + ((LDAPAuth.LdapAuthTok)authTok).getDn());
        }
        this.addResult("Checking per-repository access");
        this.testRepositories(auth, authTok);
        this.addResult("Checking per-repository a second time (tests the permission cache)");
        this.testRepositories(auth, authTok);
    }

    private void testRepositories(BaseAuth auth, BaseAuth.AuthTok authTok) {
        RepositoryManager repositoryManager = AppConfig.getsConfig().getRepositoryManager();
        for (RepositoryHandle rep : repositoryManager.getHandles()) {
            boolean access = auth.hasPermissionToAccess(authTok, true, rep);
            this.addResult("- can " + this.getUsername() + " access repository " + rep.getName() + ": " + (access ? "YES" : "NO"), access);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        this.results = new TestResults();
        Logger logger = Logs.makeAnonymousLogger();
        String ndc = "auth-test-" + System.currentTimeMillis();
        Appender appender = Logs.makeTestAppender(this.results.debug, ndc, new HashMap());
        try {
            logger.addAppender(appender);
            logger.debug((Object)"debug output follows");
            NDC.push((String)ndc);
            BaseAuth auth = this.makeAuth(logger);
            if (auth != null) {
                this.doTests(auth);
                auth.close();
            }
        }
        catch (Exception e2) {
            this.addResult("unexpected error: " + e2.getMessage(), false);
        }
        finally {
            logger.removeAppender(appender);
            NDC.pop();
        }
        return "success";
    }

    protected BaseAuth makeAuth(Logger logger) {
        SecurityType sec = AppConfig.getsConfig().getConfig().getSecurity();
        if (sec.isSetLdap()) {
            return new LDAPAuth(sec.getLdap(), logger, logger);
        }
        if (sec.isSetHostAuth()) {
            return new HostAuth(sec.getHostAuth(), logger, logger);
        }
        if (sec.isSetCustom()) {
            return new CustomAuth(sec.getCustom(), logger, logger);
        }
        this.addResult("no specific authentication configured", false);
        return null;
    }

    public static class Result {
        final boolean success;
        final String message;

        public Result(String message, boolean success) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class TestResults {
        final StringWriter debug = new StringWriter();
        final List results = new LinkedList();

        public List getResults() {
            return this.results;
        }

        public String getDebug() {
            this.debug.flush();
            return this.debug.getBuffer().toString();
        }
    }
}

