/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CrowdAuthConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.util.PropertiesUtil;
import com.cenqua.fisheye.util.StringUtil;
import com.opensymphony.xwork.ActionSupport;
import java.util.Properties;

public class CrowdAuthEditAction
extends ActionSupport {
    private static final String EXAMPLE_CROWD_PROPERTIES = "application.name=fisheye\ncrowd.server.url=http://localhost:8095/crowd/services/";
    private CrowdAuthConfigType crowdAuth;
    private String applicationName;
    private String applicationPassword;
    private String crowdUrl;

    public CrowdAuthEditAction() {
        SecurityType sec = this.getCfg().getSecurity();
        if (sec.isSetCrowd()) {
            this.crowdAuth = sec.getCrowd();
        } else {
            this.crowdAuth = CrowdAuthConfigType.Factory.newInstance();
            this.crowdAuth.setAutoAdd(true);
            this.crowdAuth.setCrowdProperties(EXAMPLE_CROWD_PROPERTIES);
        }
        Properties p = PropertiesUtil.loadFromString(this.crowdAuth.getCrowdProperties());
        this.applicationName = p.getProperty("application.name");
        this.crowdUrl = p.getProperty("crowd.server.url");
    }

    public CrowdAuthConfigType getCrowdAuth() {
        return this.crowdAuth;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public void setApplicationPassword(String applicationPassword) {
        this.applicationPassword = applicationPassword;
    }

    public String getCrowdUrl() {
        return this.crowdUrl;
    }

    public void setCrowdUrl(String crowdUrl) {
        this.crowdUrl = crowdUrl;
    }

    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public String execute() throws Exception {
        Properties props = PropertiesUtil.loadFromString(this.crowdAuth.getCrowdProperties());
        props.setProperty("application.name", this.applicationName);
        if (!StringUtil.nullOrEmpty(this.applicationPassword)) {
            props.setProperty("application.password", this.applicationPassword);
        }
        props.setProperty("crowd.server.url", this.crowdUrl);
        this.crowdAuth.setCrowdProperties(PropertiesUtil.saveToString(props));
        this.getCfg().getSecurity().setCrowd(this.crowdAuth);
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().getUserManager().reload(this.getCfg());
        return "success";
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
    }
}

