/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.user;

import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.user.BaseUserAction;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUserGroupsAction
extends BaseUserAction {
    private String uname;
    private List<String> availableGroups;
    private String[] addGroups = new String[0];
    private String[] deleteGroups = new String[0];
    private String join;
    private String leave;

    public void setJoin(String join) {
        this.join = join;
    }

    public void setLeave(String leave) {
        this.leave = leave;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public void setAddGroups(String[] addGroups) {
        this.addGroups = addGroups;
    }

    public void setDeleteGroups(String[] deleteGroups) {
        this.deleteGroups = deleteGroups;
    }

    public List<String> getAvailableGroups() {
        if (this.availableGroups == null) {
            this.availableGroups = new LinkedList<String>(this.getGroupNames());
            this.availableGroups.removeAll(this.getUserGroups());
        }
        return this.availableGroups;
    }

    public String execute() throws Exception {
        this.user = this.loadUser(this.uname);
        UserManager um = EditUserGroupsAction.getUserManager();
        if (!StringUtil.nullOrEmpty(this.join)) {
            for (String group : this.addGroups) {
                um.addUserToBuiltInGroup(group, this.uname);
            }
        }
        if (!StringUtil.nullOrEmpty(this.leave)) {
            for (String group : this.deleteGroups) {
                um.removeUserFromBuiltInGroup(group, this.uname);
            }
        }
        return "success";
    }
}

