/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.jetty;

import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.nio.SelectChannelConnector;

public class ProxyPassingSelectChannelConnector
extends SelectChannelConnector {
    private final String mProxyScheme;
    private final String mProxyHost;
    private final int mProxyPort;

    public ProxyPassingSelectChannelConnector(String proxyScheme, String proxyHost, int proxyPort) {
        this.mProxyHost = proxyHost;
        this.mProxyPort = proxyPort;
        this.mProxyScheme = proxyScheme;
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        String scheme = this.mProxyScheme == null ? request.getScheme() : this.mProxyScheme;
        String host = request.getServerName();
        int port = request.getServerPort();
        try {
            String hostInfo = request.getHeader("X-Forwarded-Host");
            if (hostInfo != null) {
                int index = hostInfo.indexOf(58);
                if (index == -1) {
                    host = hostInfo;
                    port = ProxyPassingSelectChannelConnector.getDefaultPort(scheme);
                } else {
                    host = hostInfo.substring(0, index);
                    try {
                        port = Integer.parseInt(hostInfo.substring(index + 1));
                    }
                    catch (NumberFormatException e2) {
                        port = ProxyPassingSelectChannelConnector.getDefaultPort(scheme);
                    }
                }
            }
        }
        catch (RuntimeException e3) {
            Logs.APP_LOG.warn((Object)"unexpected error parsing http header", (Throwable)e3);
        }
        if (this.mProxyPort > 0) {
            port = this.mProxyPort;
        }
        if (this.mProxyHost != null) {
            host = this.mProxyHost;
        }
        request.setScheme(scheme);
        request.setServerName(host);
        request.setServerPort(port);
    }

    private static int getDefaultPort(String scheme) {
        return scheme.equalsIgnoreCase("https") ? 443 : 80;
    }
}

