/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigUtil;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EditUserSettingsAction
extends AbstractProfileAction {
    private CookiePreferences prefs;
    private List watches = Collections.EMPTY_LIST;
    private int watchID = -1;
    private String email;
    private String displayName;

    public int getWatchID() {
        return this.watchID;
    }

    public void setWatchID(int watchID) {
        this.watchID = watchID;
    }

    public List getWatches() {
        return this.watches;
    }

    public CookiePreferences getPrefs() {
        return this.prefs;
    }

    public Collection getTimezones() {
        return DateHelper.AVAILABLE_TIMEZONE_IDS;
    }

    public String getDefaultTimezone() {
        return ConfigUtil.getDefaultTimezone();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String execute() throws Exception {
        this.prefs = PreferenceManager.getPreferences(this.request);
        this.profile.setCookiePrefs(this.prefs.asCookieValue());
        UserLogin user = this.getUserLogin();
        try {
            if (user != null) {
                this.configChangePasswordEnabled(user.getUsername());
                UserProfile current = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                this.profile.setWatchMode(current.getWatchMode());
                this.profile.setEmailFormat(current.getEmailFormat());
                this.profile.setAuthorMapping(current.getAuthorMappings());
                AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), this.profile);
                return "success";
            }
            this.addActionError("User not found");
        }
        catch (DbException e2) {
            this.addActionError("Database error loading user profile");
        }
        return "error";
    }

    public String doDefault() throws Exception {
        this.prefs = PreferenceManager.getPreferences(this.request);
        UserLogin user = this.getUserLogin();
        try {
            if (user != null) {
                this.configChangePasswordEnabled(user.getUsername());
                this.profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                return "success";
            }
            this.addActionError("User not found");
        }
        catch (DbException e2) {
            this.addActionError("Database error loading user profile");
        }
        return "error";
    }

    public String loadEmail() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FEUser feu = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
                this.configChangePasswordEnabled(feu);
                this.email = feu.getEmail();
                this.displayName = feu.getDisplayName();
                this.profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                return "success";
            }
            catch (DbException e2) {
                this.addActionError("Database error loading user profile");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String updateEmail() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FEUser local = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
                this.configChangePasswordEnabled(local);
                local.setEmail(this.email);
                local.setDisplayName(this.displayName);
                AppConfig.getsConfig().getUserManager().updateUser(local);
            }
            catch (DbException e2) {
                this.addActionError("Database error updating user settings");
                return "error";
            }
            try {
                UserProfile userProf = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                userProf.setEmailFormat(this.profile.getEmailFormat());
                AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), userProf);
                this.profile = userProf;
                return "success";
            }
            catch (DbException e3) {
                this.addActionError("Database error updating user profile");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String loadWatches() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                this.watches = AppConfig.getsConfig().getWatchManager().getWatchesForUser(user.getUsername());
            }
            catch (DbException e2) {
                this.addActionError("Database error loading user watches");
                return "error";
            }
            try {
                FEUser feu = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
                this.configChangePasswordEnabled(feu);
                this.email = feu.getEmail();
            }
            catch (DbException e3) {
                this.addActionError("Database error loading user information");
                return "error";
            }
            try {
                this.profile = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
            }
            catch (DbException e4) {
                this.addActionError("Database error loading profile");
                return "error";
            }
            return "success";
        }
        this.addActionError("User not found");
        return "error";
    }

    public String updateWatchSettings() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                this.configChangePasswordEnabled(user.getUsername());
                UserProfile userProf = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                userProf.setWatchMode(this.profile.getWatchMode());
                AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), userProf);
                this.profile = userProf;
                return "success";
            }
            catch (DbException e2) {
                this.addActionError("Database error updating profile");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String deleteWatch() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FEUser feu = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
                this.configChangePasswordEnabled(feu);
                if (AppConfig.getsConfig().getWatchManager().deleteWatch(this.watchID)) {
                    PreferenceManager.touchCookie(this.request, this.response);
                    this.email = feu.getEmail();
                    return this.loadWatches();
                }
            }
            catch (DbException e2) {
                this.addActionError("Database error deleting watch '" + this.watchID + "'");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }
}

