/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.Path;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public class FishEyeURLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    private FishEyeURLEncoder() {
    }

    public static String encode(Path p) {
        String str = null;
        try {
            str = FishEyeURLEncoder.encode(p.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(String s) {
        String str = null;
        try {
            str = FishEyeURLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c2 = s.charAt(i2);
            if (dontNeedEncoding.get(c2)) {
                out.append(c2);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d2;
                if (wroteUnencodedChar) {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)buf, enc));
                    wroteUnencodedChar = false;
                }
                writer.write(c2);
                if (c2 >= '\ud800' && c2 <= '\udbff' && i2 + 1 < s.length() && (d2 = s.charAt(i2 + 1)) >= '\udc00' && d2 <= '\udfff') {
                    writer.write(d2);
                    ++i2;
                }
                writer.flush();
            }
            catch (IOException e2) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    static {
        int i2;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (i2 = 97; i2 <= 122; ++i2) {
            dontNeedEncoding.set(i2);
        }
        for (i2 = 65; i2 <= 90; ++i2) {
            dontNeedEncoding.set(i2);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            dontNeedEncoding.set(i2);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(47);
        dfltEncName = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }
}

