<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%--
*  home.jsp
*  Home view of the Budget Category in the marketing hierarchy.
*
*@author     Vignesh.A.D
*@version
*@since
--%>
<head>
	<meta http-equiv="Content-Type" content="text/html">
	<title><spring:message code="apptitle"/></title>

	<c:set var="css"><spring:theme code="css"/></c:set>
	<c:if test="${not empty css}">
		<link rel="stylesheet" href="<c:url value='${css}'/>" type="text/css" />
    </c:if>

    <script type="text/javascript" src="<c:url value='/scripts/menu.js'/>"></script>
	<script type="text/javascript" src="<c:url value='/scripts/global.js'/>" ></script>
	<script type="text/javascript" src="<c:url value='/scripts/cookie.js'/>"></script>
	<script type="text/javascript">

	/* This function is used to open a pop-up window */
	function openWindow(url, winTitle, winParams) {
		winName = window.open(url, winTitle, winParams);
	    winName.focus();
	};

    function CallParentWindowFunction()
    {
       window.close();

    }
    </script>



</head>


<%--
*  budgetCategoryForm.jsp
*  budget edit / update
*
*@author     Vignesh.A.D
*@version
*@since
--%>

<table width='75%'>
<tr>
<td><img src='<c:url value="/img/spacer.gif"/>' width='10' height='1' border='0' style='margin-top: 3px;'></td>
<td>

<table width='100%' cellpadding='0' cellspacing='0' border='0' class='moduleTitle'>
	<tr>
	<td valign='top'>
		<img src='<c:url value="/img/CreateQuotes.gif"/>' width='16' height='16' border='0' style='margin-top: 3px;' alt='Budget'>&nbsp;
	</td>
	<td width='100%'><h2><spring:message code="newbudgetcategory"/></h2></td>
	<td valign='top' align='right' nowrap style='padding-top:3px; padding-left: 5px;'>
		&nbsp;<A href='<c:out value = "${sessionScope.propValue}"/>' target='_blank' class='utilsLink'><img src='<c:url value="/img/help.gif"/>' width='13' height='13' alt='Help' border='0' align='absmiddle'></a>&nbsp;<A href='<c:out value = "${sessionScope.propValue}"/>' target='_blank' class='utilsLink'>Help</A>
	</td>
	</tr>
</table>

</p>

<table width="100%" cellpadding="0" cellspacing="0" border="0">
<tr>
	<td align="right" nowrap><span class="required">*</span> Indicates required field</td>
	<td align='right'></td>
    <input type="hidden" name="hiddenvalue" value=""/>
</tr>
</table>

<form method="POST">
<spring:bind path="budgetcategory.createUser">
	<c:if test="${offer.createUser==null}">
		<input type="hidden" name="<c:out value="${status.expression}"/>" value="<authz:authentication operation="principal"/>">
	</c:if>
</spring:bind>
<spring:bind path="budgetcategory.updateUser">
	<input type="hidden" name="<c:out value="${status.expression}"/>" value="<authz:authentication operation="principal"/>">
</spring:bind>
<spring:bind path="budgetcategory.organizationId">
	<input type="hidden" name="<c:out value="${status.expression}"/>" value="<c:out value="${status.value}"/>">
</spring:bind>


<table class="tabForm" width="100%" cellspacing="0" cellpadding="0" border="0">
<tr style="background-image : url(<c:url value="/img/header_bg_orange.gif"/>);">
	<tr>
		<td>
		<table width="50%" border="0" cellspacing="0" cellpadding="0">
            <tr>
				<spring:bind path="budgetcategory.bcparentCategoryId">
					<td class="dataLabel"><spring:message code="parentcategory"/>:<span class="required">*</span>&nbsp</td>
					<td class="dataField">
						<SELECT name="parentCategoryId">
                          <OPTION value=""><spring:message code="unspecified"/></OPTION>
                          <c:forEach var="budgetcategory" items="${budgetcategorylist}">
                              <OPTION value="<c:out value="${budgetcategory.budgetCategoryId}"/>"><c:out value="${budgetcategory.budgetCategoryName}"/></OPTION>
                          </c:forEach>
						</SELECT>
					</td>
				</spring:bind>
		    </tr>
           <tr>
				<spring:bind path="budgetcategory.budgetCategoryName">
                    <td class="dataLabel"><spring:message code="categoryname"/>:<span class="required">*</span>&nbsp</td>
					<td class="dataField"><input type="text" name="<c:out value="${status.expression}"/>" value="<c:out value="${status.value}"/>" maxlength="100" size="35"></td>
                </spring:bind>
		    </tr>
            <tr>
				<spring:bind path="budgetcategory.budgetCategoryDescription">
                    <td class="dataLabel"><spring:message code="categorydescription"/>:&nbsp</td>
					<td class="dataField">
                        <textarea name="<c:out value="${status.expression}"/>" rows="3" cols="60"><c:out value="${status.value}"/></textarea>
                    </td>
                </spring:bind>
		   </tr>
            <tr>
			<td>
				<c:choose>
					<c:when test="${budgetcategory.budgetCategoryId==null}">
						<input title="Save [Alt+S]" accessKey="S" onClick="CallParentWindowFunction()" class="button" type="submit" name="button" value="  Save  " >
					</c:when>
					<c:otherwise>
						<input title="Save [Alt+S]" accessKey="S" onClick="CallParentWindowFunction()" class="button" type="submit" name="button" value="  Update  " >
				    </c:otherwise>
				</c:choose>
			</td>
	    </tr>
		</table>
	</td>
</tr>
</table>
</form>
</td>
</tr>
</table>
