<%--
	Header file that defines the header section of the UI MAP-Marketin Application Platform
	Derrick Kittler
	Customer Portfolios, LLC
--%>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<jsp:useBean id="now" class="java.util.Date"/>
<%@ taglib uri="/WEB-INF/tlds/DemoTags.tld" prefix="workbenchTag" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD html 4.01 Transitional//EN">
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html">


	<c:set var="css"><spring:theme code="css"/></c:set>
	<c:if test="${not empty css}">
		<link rel="stylesheet" href="<c:url value='${css}'/>" type="text/css" />
    </c:if>
    <c:if test= "${sessionScope.pid == null}">
       <c:set var= "pid" scope="session" value= "1"/>
    </c:if>
    <c:if test= "${not empty param.pid}">
	   <c:set var= "pid" scope="session" value= "${param.pid}"/>
    </c:if>

    <c:set var= "pid" value ='${sessionScope.pid}'/>
    <c:set var="currentOrganizationId" value="${sessionScope.userpreference.currentOrganizationId}"/>
    <c:set var="currentPortfolioId" value="${sessionScope.userpreference.currentPortfolioId}"/>
    <title><c:choose><c:when test="${currentOrganizationId == 20}">PartnersFirst Marketing Workbench</c:when><c:otherwise><spring:message code="apptitle"/></c:otherwise></c:choose></title>
    
    <script type="text/javascript" src="<c:url value='/scripts/menu.js'/>"></script>
    <script type="text/javascript" src="<c:url value='/scripts/global.js'/>"></script>
    <script type="text/javascript" src="<c:url value='/scripts/cookie.js'/>"></script>
    <script type="text/javascript" src="<c:url value='/scripts/common.js'/>"></script>
    <script type="text/javascript">

        var currenttime = "<fmt:formatDate value="${now}" pattern="MMMMM dd,yyyy HH:mm:ss z"/>";
        var montharray = new Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
        var serverdate = new Date(currenttime);
        window.onload = function() {            
            setInterval("displaytime()", 1000);
        };

        function hideLeftCol(id)
        {
            if (this.document.getElementById(id).style.display == 'none')
            {
                this.document.getElementById(id).style.display = 'inline';

                Set_Cookie('showLeftCol', 'true', 30, '/', '', '');
                var show = Get_Cookie('showLeftCol');
                document['HideHandle'].src = '<c:url value="/img/hide.gif"/>';
            }
            else
            {
                this.document.getElementById(id).style.display = 'none';

                Set_Cookie('showLeftCol', 'false', 30, '/', '', '');
                var show = Get_Cookie('showLeftCol');
                document['HideHandle'].src = '<c:url value="/img/show.gif"/>';
            }
        };

        function showSubMenu(id)
        {
            if (this.document.getElementById(id).style.display == 'none')
            {
                tbButtonMouseOver('HideHandle', 122, '', 10);
            }
        };

        function checkOrganization(id)
        {
            var orgId = id;
            var tid = '<c:out value='${sessionScope.pid}'/>';
            var theURL = document.getElementById("campurl").value;
            if (tid == 1) {
                theURL = document.getElementById("campurl").value;
            }
            if (tid == 3) {
                theURL = document.getElementById("lstUrl").value;
            }
            if (tid == 4) {
                theURL = document.getElementById("rprtUrl").value;
            }
            if (tid == 5) {
                theURL = document.getElementById("adminUrl").value;
            }
            document.getElementById("corgid").value=orgId;    
            document.forms["UnifiedSearch"].action=theURL;
            document.forms["UnifiedSearch"].submit();
        }
        
        function checkPortfolio(id)
        {
            //alert(" this is the id "+id);
            var ids = id.split('//');
            var portId = ids[0];
            var orgId  = ids[1];
            var tid = '<c:out value='${sessionScope.pid}'/>';
            var theURL = document.getElementById("campurl").value;
            if (tid == 1) {
                theURL = document.getElementById("campurl").value;
            }
            if (tid == 3) {
                theURL = document.getElementById("lstUrl").value;
            }
            if (tid == 4) {
                theURL = document.getElementById("rprtUrl").value;
            }
            if (tid == 5) {
                theURL = document.getElementById("adminUrl").value;
            }
            document.getElementById("prtflioid").value=portId;
            document.getElementById("corgid").value=orgId;
            document.forms["UnifiedSearch"].action=theURL;
            document.forms["UnifiedSearch"].submit();
        }
        
        function postUrl(uniqueid , url) {                
		   document.UnifiedSearch.id.value=uniqueid; 	
		   document.UnifiedSearch.action=url;
		   document.UnifiedSearch.method="post";
		   document.UnifiedSearch.submit();
        }       

    </script>
</head>
<body onMouseOut="closeMenus();">
<form name='UnifiedSearch' method="post">
  <input type="hidden" name="goid"        id="corgid"    value="0"/>
  <input type="hidden" name="poid"        id="prtflioid" value="0"/>
  <input type="hidden" name="campaignUrl" id="campurl"   value='<c:url value="/home.htm"/>'/>
  <input type="hidden" name="listUrl"     id="lstUrl"    value='<c:url value="/list/home.htm"/>'/>
  <input type="hidden" name="reportUrl"   id="rprtUrl"   value='<c:url value="/report/home.htm"/>'/>
  <input type="hidden" name="adminUrl"    id="adminUrl"  value='<c:url value="/administration/home.htm"/>'/>
  <input type="hidden" name="id" 		  id="id"        value="0"/>


   <!-- Added by BCT for bug fixing 3317 -->
  <c:set var="etUserName" value="${sessionScope.OrganizationProperties.mailExportUsername}"/>
  <c:set var="etPassword" value="${sessionScope.OrganizationProperties.mailExportPassword}"/>
  <!-- End of Addition by BCT for bug fixing 3317 -->
  <%--
  Added by BCT for fixing the bug id #278 (Tabs at the top of the page do not change color to indicate current page)
  --%>

  <c:set var= "class_cmpgMgmtT"  value= "otherTab"/>
  <c:set var= "class_cmpgMgmtL"  value= "/img/otherTab_left.gif"/>
  <c:set var= "class_cmpgMgmtM"  value= "/img/otherTab_middle.gif"/>
  <c:set var= "class_cmpgMgmtR"  value= "/img/otherTab_right.gif"/>

  <c:set var= "class_prtfMgmtT"  value= "otherTab"/>
  <c:set var= "class_prtfMgmtL"  value= "/img/otherTab_left.gif"/>
  <c:set var= "class_prtfMgmtM"  value= "/img/otherTab_middle.gif"/>
  <c:set var= "class_prtfMgmtR"  value= "/img/otherTab_right.gif"/>

  <c:set var= "class_listMgmtT"  value= "otherTab"/>
  <c:set var= "class_listMgmtL"  value= "/img/otherTab_left.gif"/>
  <c:set var= "class_listMgmtM"  value= "/img/otherTab_middle.gif"/>
  <c:set var= "class_listMgmtR"  value= "/img/otherTab_right.gif"/>

  <c:set var= "class_rprtMgmtT"  value= "otherTab"/>
  <c:set var= "class_rprtMgmtL"  value= "/img/otherTab_left.gif"/>
  <c:set var= "class_rprtMgmtM"  value= "/img/otherTab_middle.gif"/>
  <c:set var= "class_rprtMgmtR"  value= "/img/otherTab_right.gif"/>

  <c:set var= "class_admnMgmtT"  value= "otherTab"/>
  <c:set var= "class_admnMgmtL"  value= "/img/otherTab_left.gif"/>
  <c:set var= "class_admnMgmtM"  value= "/img/otherTab_middle.gif"/>
  <c:set var= "class_admnMgmtR"  value= "/img/otherTab_right.gif"/>


<c:if test= '${pid == "1"}'>
    <c:set var= "class_cmpgMgmtT"  value="currentTab"/>
    <c:set var= "class_cmpgMgmtL"  value= "/img/currentTab_left.gif"/>
    <c:set var= "class_cmpgMgmtM"  value= "/img/currentTab_middle.gif"/>
    <c:set var= "class_cmpgMgmtR"  value= "/img/currentTab_right.gif"/>
</c:if>

<c:if test= '${pid == "2"}'>
    <c:set var= "class_prtfMgmtT"  value="currentTab"/>
    <c:set var= "class_prtfMgmtL"  value= "/img/currentTab_left.gif"/>
    <c:set var= "class_prtfMgmtM"  value= "/img/currentTab_middle.gif"/>
    <c:set var= "class_prtfMgmtR"  value= "/img/currentTab_right.gif"/>
</c:if>

<c:if  test= '${pid == "3"}'>
    <c:set var= "class_listMgmtT"  value="currentTab"/>
    <c:set var= "class_listMgmtL"  value= "/img/currentTab_left.gif"/>
    <c:set var= "class_listMgmtM"  value= "/img/currentTab_middle.gif"/>
    <c:set var= "class_listMgmtR"  value= "/img/currentTab_right.gif"/>
</c:if>

<c:if test= '${pid == "4"}'>
    <c:set var= "class_rprtMgmtT"  value="currentTab" />
    <c:set var= "class_rprtMgmtL"  value= "/img/currentTab_left.gif"/>
    <c:set var= "class_rprtMgmtM"  value= "/img/currentTab_middle.gif"/>
    <c:set var= "class_rprtMgmtR"  value= "/img/currentTab_right.gif"/>
</c:if>

<c:if test= '${pid == "5"}'>
    <c:set var= "class_admnMgmtT"  value="currentTab" />
    <c:set var= "class_admnMgmtL"  value= "/img/currentTab_left.gif"/>
    <c:set var= "class_admnMgmtM"  value= "/img/currentTab_middle.gif"/>
    <c:set var= "class_admnMgmtR"  value= "/img/currentTab_right.gif"/>
</c:if>


  <%-- ******************************** END of Addition by BCT ****************************** --%>


<table width="100%" cellspacing="0" cellpadding="0" border="0">
<tr>
    <td colspan="2" style="background-image : url(<c:url value="/img/header_bg.gif"/>);">
		<table cellspacing="0" cellpadding="0" border="0" width="100%">
		<tr height="50">
		
        <td><img src="<c:choose><c:when test="${currentOrganizationId == 20}"><c:url value="/img/PF-Marketing-Workbench.gif"/></c:when><c:otherwise><c:url value="/img/CP-Marketing-Workbench.gif"/></c:otherwise></c:choose>" width="240" height="47" alt="Customer Portfolios" border="0" style="margin-left: 10px;"></td>
        <td class="myArea" align="right" nowrap="nowrap">
			<table border="0" cellpadding="0" cellspacing="3">
			
			<tr>
				<td>
				<c:set var="etlMessage"><workbenchTag:etlcustomtag orgId="${currentOrganizationId}"/></c:set>
					<c:if test="${not empty etlMessage}">
						<FONT color="red" >Last ETL Complete Date : ${etlMessage}</FONT>	
   	 				</c:if>
			
				</td>
				<td style="padding-right: 10px;" align="right" nowrap="nowrap"><span class="myArea"><spring:message code="welcome"/>:&nbsp;</span><authz:authentication operation="principal"/></td>
                <td class="myArea"><a href="<c:url value="/logoff.jsp"/>" class="myAreaLink" style="padding-right: 10px;">&nbsp; <spring:message code="logout"/></a></td>
			</tr>
			
			<c:if test= '${pid != "5"}'> 		
            <tr>
            	<td></td>
				<td colspan="3" style="padding-right: 10px;" align="right" nowrap="nowrap">
                    <span class="myArea">Organization:&nbsp;</span>
                    <c:if test="${results.organizations ==null}">
                        <c:out value="${organization.organizationNm}"/>
                    </c:if>
                    <c:if test="${results.organizations !=null}">
                    <c:choose>
                    <c:when test="${fn:length(results.organizations) == 1}">
                      <c:forEach items="${results.organizations}" var="organization">
                           <c:out value="${organization.organizationNm}"/>
                      </c:forEach>
                    </c:when>
                    <c:otherwise>
                    <SELECT name="orgSelect" onchange="checkOrganization(this.value)">
                    <c:forEach items="${results.organizations}" var="organization">
						<c:if test="${currentOrganizationId == organization.organizationId}">
							<OPTION selected value="<c:out value="${organization.organizationId}"/>"><c:out value="${organization.organizationNm}"/></OPTION>
						</c:if>
						<c:if test="${currentOrganizationId != organization.organizationId}">
							<OPTION value="<c:out value="${organization.organizationId}"/>"><c:out value="${organization.organizationNm}"/></OPTION>
						</c:if>
				    </c:forEach>
                    </SELECT>
                   </c:otherwise>
                   </c:choose>
                   </c:if>
                </td>
			</tr>			    
            <tr>
            	<td></td>
				<td colspan="3" style="padding-right: 10px;" align="right" nowrap="nowrap">
                    <span class="myArea">Portfolio:&nbsp;</span>
                       <c:if test="${results.portfolios ==null}">
                       <c:if test="${portfolio != null}">  
                          <c:out value="${portfolio.portfolioNm}"/>  
                       </c:if>                            
                       <c:if test="${currPortfolio != null}">  
                          <c:out value="${currPortfolio.portfolioNm}"/>  
                       </c:if>     
                       <c:if test="${portfolio == null}">  
                          <spring:message code="allmyportfolios"/>  
                       </c:if>                              
                    </c:if>                                            
                    <c:if test="${results.portfolios != null}">
                    <c:choose>
                    <c:when test="${fn:length(results.portfolios) == 1}">
                      <c:forEach items="${results.portfolios}" var="portfolio">
                           <c:out value="${portfolio.portfolioNm}"/>
                      </c:forEach>
                    </c:when>
                    <c:otherwise>
                    <SELECT name="portSelect" onchange="checkPortfolio(this.value)">
                    <option value='0//<c:out value="${currentOrganizationId}"/>'>
                    <spring:message code="allmyportfolios"/></option>
                    <c:forEach items="${results.portfolios}" var="portfolio">
						<c:if test="${currentPortfolioId == portfolio.portfolioId}">
							<OPTION selected value="<c:out value="${portfolio.portfolioId}"/>"><c:out value="${portfolio.portfolioNm}"/></OPTION>
						</c:if>
						<c:if test="${currentPortfolioId != portfolio.portfolioId}">
							<OPTION value="<c:out value="${portfolio.portfolioId}"/>//<c:out value="${portfolio.organization.organizationId}"/>"><c:out value="${portfolio.portfolioNm}"/></OPTION>
						</c:if>
				    </c:forEach>
                    </SELECT>
                   </c:otherwise>
                   </c:choose>
                   </c:if>                   
                </td>
			</tr>
		  </c:if>   
			
			
						
			</table>
		  </td>
        </tr>   
		<%-- Navagation --%>
		
		
		<tr>
		    <td colspan="2">
			<table cellspacing="0" cellpadding="0" border="0" width="100%">
			   <tr height="20">
			     <td style="padding-left:7px; background-image :url(<c:url value="/img/emptyTabSpace.gif"/>);">&nbsp;</td>
				 <td>
				 <table cellspacing="0" cellpadding="0" border="0" width="100%" style="background-color: #E5E5E5;" >
			        <tr height="20">
					   <td style="background-image : url( <c:url value="${class_cmpgMgmtL}"/>);" ><img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="Campaign Management"></td>
					   <td style="background-image : url( <c:url value="${class_cmpgMgmtM}"/>);" class="<c:out value="${class_cmpgMgmtT}"/>"  nowrap> <a class="<c:out value="${class_cmpgMgmtT}"/>" href="<c:url value="/home.htm?pid=1"/>"> Campaign Management</a></td>
					   <td style="background-image : url( <c:url value="${class_cmpgMgmtR}"/>);"> <img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="Campaign Management"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"><img src="<c:url value="/img/blank.gif"/>" width="1" height="1" border="0" alt=""></td>
					</tr>
	   			 </table>
			     </td>
				 <td>
				 <table cellspacing="0" cellpadding="0" border="0" width="100%" style="background-color: #E5E5E5;">
				    <tr height="20">
					   <td style="background-image : url( <c:url value="${class_listMgmtL}"/> );" ><img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="List Management"></td>
					   <td style="background-image : url( <c:url value="${class_listMgmtM}"/> );" class="<c:out value="${class_listMgmtT}"/>" nowrap> <a class="<c:out value="${class_listMgmtT}"/>" href="<c:url value="/list/home.htm?pid=3"/>"> List Management </a> </td>
					   <td style="background-image : url( <c:url value="${class_listMgmtR}"/> );"> <img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="List Management"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"><img src="<c:url value="/img/blank.gif"/>" width="1" height="1" border="0" alt=""></td>
                    </tr>
			     </table>
			     </td>
				 <td>
				 <table cellspacing="0" cellpadding="0" border="0" width="100%" style="background-color: #E5E5E5;">
				    <tr height="20">
					   <td style="background-image : url( <c:url value="${class_rprtMgmtL}"/> );" ><img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="Report Management"></td>
					   <td style="background-image : url( <c:url value="${class_rprtMgmtM}"/> );" class="<c:out value="${class_rprtMgmtT}"/>" nowrap> <a class="<c:out value="${class_rprtMgmtT}"/>" href="<c:url value="/report/home.htm?pid=4"/>"> Report Management </a> </td>
					   <td style="background-image : url( <c:url value="${class_rprtMgmtR}"/> );"> <img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="Report Management"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"><img src="<c:url value="/img/blank.gif"/>" width="1" height="1" border="0" alt=""></td>
                    </tr>
			     </table>
			     </td>

				 <authz:authorize ifAllGranted="ROLE_ADMIN">
				 <td>
				 <table cellspacing="0" cellpadding="0" border="0" width="100%" style="background-color: #E5E5E5;">
				    <tr height="20">
					   <td style="background-image : url( <c:url value="${class_admnMgmtL}"/> );" ><img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="Administration"></td>
					   <td style="background-image : url( <c:url value="${class_admnMgmtM}"/> );" class="<c:out value="${class_admnMgmtT}"/>" nowrap> <a class="<c:out value="${class_admnMgmtT}"/>" href="<c:url value="/administration/home.htm?pid=5"/>"> Administration </a> </td>
					   <td style="background-image : url( <c:url value="${class_admnMgmtR}"/> );"> <img src="<c:url value="/img/blank.gif"/>" width="8" height="1" border="0" alt="Administration"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"></td>
					   <td style="background-image : url( <c:url value="/img/emptyTabSpace.gif"/>);"><img src="<c:url value="/img/blank.gif"/>" width="1" height="1" border="0" alt=""></td>
                    </tr>
			     </table>
			     </td>
				 </authz:authorize>
                 <td style="background-image: url(<c:url value="/img/emptyTabSpace.gif"/>);" width="99%" align="right" nowrap="nowrap"><span id="servertime"></span>&nbsp;</td>
                </tr>
            </table>
    	</td>
		</tr>


        <tr height="20">
        <%--      <input type="hidden" name="action" value="UnifiedSearch">
				  <input type="hidden" name="module" value="Home">
				  <input type="hidden" name="search_form" value="false">     --%>
		    <td class="subTabBar" colspan="2">
			<table width="100%" cellspacing="0" cellpadding="0" border="0" height="20">			
            <tr>            
			    <td class="welcome" style="padding-right: 10px;" width="100%" align="right">
			    <authz:authorize ifAllGranted="ROLE_EXACTTARGET_USER">
<c:choose>
<c:when test="${currentOrganizationId == 17}"><a href="https://login5.silverpop.com/login.do?username=<c:out value="${etUserName}"/>&password=<c:out value="${etPassword}"/>&service=https%3A%2F%2Fengage5.silverpop.com%2FmailingsManagementTemplate.do" target="_blank" class="myAreaLink" style="color: white">SilverPop</a></c:when>
<c:when test="${(currentOrganizationId == 39) || (currentOrganizationId == 41) || (currentOrganizationId == 42)}"><a href="https://em.smart-login.net/Login.aspx" target="_blank" class="myAreaLink" style="color: white">SmartSource</a></c:when>
<c:when test="${(currentOrganizationId == 1) || (currentOrganizationId == 37) || (currentOrganizationId == 38) || (currentOrganizationId == 22) || (currentOrganizationId == 25)}"><a href="https://members.exacttarget.com" target="_blank" class="myAreaLink" style="color: white">ExactTarget</a></c:when>
<c:when test="${(currentOrganizationId == 24)}"><a href="https://members.exacttarget.com" target="_blank" class="myAreaLink" style="color: white">ExactTarget</a></c:when>
<c:when test="${(currentOrganizationId == 43)}"><a href="https://pc7.e-dialog.com" target="_blank" class="myAreaLink" style="color: white">e-Dialog</a></c:when>
<c:otherwise><a href="https://members.exacttarget.com" target="_blank" class="myAreaLink" style="color: white"><spring:message code="exacttarget"/></a></c:otherwise>
</c:choose>

                </authz:authorize>
                </td>
			</tr>
			</table>
			</td>
			</form>
      </body>
        </tr>
		</table>
	</td>

    <!--	Added by BCT for bug fixing 4919	-->
    <%
    Cookie[] cookies = request.getCookies();
    if ((cookies == null) || (cookies.length == 0)) {
        System.out.println("Cookie not found");
    }
    else {
		for (int i = 0; i < cookies.length; i++) {
			if ("ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE".equals(cookies[i].getName())) {
	%>
 <tr height="11">
	<td colspan="3" style="padding-left: 10px;"><iframe style="display:none" src='<c:url value="/loginSessionManager.jsp"/>' width="100%"></iframe></td>
 </tr>
	<%
			}
		}
	}
    %>
	<!-- End of Addition by BCT for bug fixing 4919 -->
</table>
