/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.io.FastBufferedReader;
import electric.util.lex.Lex;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.Reader;

public class NodeReader {
    protected Reader reader;
    protected Lex lex;
    protected boolean strip;
    protected StringBuffer lastWhitespace;

    public NodeReader(Reader reader) {
        this(reader, 0);
    }

    public NodeReader(Reader reader, int n) {
        this.reader = reader.markSupported() ? reader : new FastBufferedReader(reader);
        this.strip = (n & 1) == 0;
        this.lex = new Lex(this.reader, "<>=/:", 1);
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getLocation() {
        return this.lex.getLocation();
    }

    public boolean isStrip() {
        return this.strip;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Node node) throws ParseException {
        try {
            try {
                this.read(node);
            }
            catch (Exception exception) {
                throw new ParseException(exception.getClass().getName() + ": " + exception.getMessage() + "\n" + this.getLocation());
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                this.reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        this.reader.close();
        return;
    }

    public void read(Node node) throws IOException, NamespaceException {
        node.read(this);
    }

    public final int read() throws IOException {
        return this.lex.read();
    }

    public final StringBuffer readWhitespace() throws IOException {
        this.lastWhitespace = this.lex.readWhitespace();
        return this.lastWhitespace;
    }

    public final StringBuffer getLastWhitespace() {
        return this.lastWhitespace;
    }

    public final void skipWhitespace() throws IOException {
        this.lex.skipWhitespace();
    }

    public final void mark(int n) throws IOException {
        this.lex.mark(n);
    }

    public final int peekRead() throws IOException {
        return this.lex.peekRead();
    }

    public final void reset() throws IOException {
        this.lex.reset();
    }

    public final boolean peekString(String string) throws IOException {
        return this.lex.peekString(string);
    }

    public final void skip(int n) throws IOException {
        this.lex.skip(n);
    }

    public final String readToPattern(String string, int n) throws IOException {
        return this.lex.readToPattern(string, n);
    }

    public final void readToken(String string) throws IOException {
        this.lex.readToken(string);
    }

    public final String readToDelimiter(String string) throws IOException {
        return this.lex.readToDelimiter(string);
    }

    public final String readToDelimiter(String string, int n) throws IOException {
        return this.lex.readToDelimiter(string, n);
    }

    public final String readToken() throws IOException {
        return this.lex.readToken();
    }

    public final void readChar(int n) throws IOException {
        this.lex.readChar(n);
    }

    public final int peek() throws IOException {
        return this.lex.peek();
    }

    public final void peek(int[] nArray) throws IOException {
        this.lex.peek(nArray);
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

