/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.Node;
import java.io.IOException;
import java.io.Writer;

public class NodeWriter {
    protected static int defaultStep = 2;
    protected static String defaultEOL = "\r\n";
    protected Writer writer;
    protected int indent;
    protected int step;
    protected boolean expandEmptyElements;
    protected String eol;

    public NodeWriter(Writer writer) {
        this(writer, 0, false, defaultStep, defaultEOL);
    }

    public NodeWriter(Writer writer, int n, boolean bl) {
        this(writer, n, bl, defaultStep, defaultEOL);
    }

    public NodeWriter(Writer writer, int n, boolean bl, int n2, String string) {
        this.writer = writer;
        this.indent = n;
        this.expandEmptyElements = bl;
        this.step = n2;
        this.eol = string;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public final boolean isIndenting() {
        return this.indent <= 0;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final void setIndent(int n) {
        this.indent = n;
    }

    public final int getStep() {
        return this.step;
    }

    public final void setStep(int n) {
        this.step = n;
    }

    public final void increaseIndent() {
        this.indent += this.step;
    }

    public final void decreaseIndent() {
        this.indent -= this.step;
    }

    public static final void setDefaultStep(int n) {
        defaultStep = n;
    }

    public static final int getDefaultStep() {
        return defaultStep;
    }

    public final String getEOL() {
        return this.eol;
    }

    public final void setEOL(String string) {
        this.eol = string;
    }

    public static final void setDefaultEOL(String string) {
        defaultEOL = string;
    }

    public static final String getDefaultEOL() {
        return defaultEOL;
    }

    public final boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public final void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public void write(Node node) throws IOException {
        node.write(this);
    }

    public final void write(String string) throws IOException {
        this.writer.write(string);
    }

    public final void write(String string, int n, int n2) throws IOException {
        this.writer.write(string, n, n2);
    }

    public final void write(char c) throws IOException {
        this.writer.write(c);
    }

    public final void write(char[] cArray, int n, int n2) throws IOException {
        this.writer.write(cArray, n, n2);
    }

    public final void writeIndent() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.writer.write(32);
            ++n;
        }
    }

    public final void writeEOL() throws IOException {
        this.writer.write(this.eol);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

