/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.xpath;

import electric.util.lex.Lex;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.XPathException;
import electric.xml.xpath.AllAttributesNode;
import electric.xml.xpath.AllNode;
import electric.xml.xpath.AttributeNode;
import electric.xml.xpath.AttributePredicate;
import electric.xml.xpath.CurrentNode;
import electric.xml.xpath.IndexPredicate;
import electric.xml.xpath.NameNode;
import electric.xml.xpath.ParentNode;
import electric.xml.xpath.RootNode;
import electric.xml.xpath.TextPredicate;
import electric.xml.xpath.WildNode;
import java.io.IOException;

public final class XPathNodeFactory {
    public static synchronized NodeList newNodes(String string) throws XPathException {
        try {
            NodeList nodeList = new NodeList();
            Lex lex = new Lex(string, "/", 19);
            if (lex.peek() == 47) {
                nodeList.append(new RootNode());
                lex.read();
            }
            if (!lex.eof()) {
                String string2 = lex.readToken();
                nodeList.append(XPathNodeFactory.newNode(string2));
                while (!lex.eof()) {
                    if (!string2.equals("/")) {
                        lex.readChar(47);
                    }
                    string2 = lex.readToken();
                    nodeList.append(XPathNodeFactory.newNode(string2));
                }
            }
            return nodeList;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException.toString());
        }
    }

    private static Node newNode(String string) throws XPathException {
        if (string.equals("..")) {
            return new ParentNode();
        }
        if (string.equals(".")) {
            return new CurrentNode();
        }
        if (string.equals("/")) {
            return new WildNode();
        }
        if (string.equals("*")) {
            return new AllNode();
        }
        if (string.equals("@*")) {
            return new AllAttributesNode();
        }
        if (string.startsWith("@")) {
            return new AttributeNode(string);
        }
        if (string.indexOf("[@") != -1) {
            return new AttributePredicate(string);
        }
        if (string.indexOf("[text") != -1) {
            return new TextPredicate(string);
        }
        if (string.indexOf("[") != -1) {
            return new IndexPredicate(string);
        }
        return new NameNode(string);
    }
}

