/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.util.Comparator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionalCache
implements CacheConcurrencyStrategy {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$TransactionalCache == null ? (class$net$sf$hibernate$cache$TransactionalCache = TransactionalCache.class$("net.sf.hibernate.cache.TransactionalCache")) : class$net$sf$hibernate$cache$TransactionalCache));
    private Cache cache;
    private boolean minimalPuts;
    static /* synthetic */ Class class$net$sf$hibernate$cache$TransactionalCache;

    public Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("cache lookup: " + key));
        }
        Object result = this.cache.get(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)(result == null ? "cache miss" : "cache hit"));
        }
        return result;
    }

    public boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator) throws CacheException {
        if (this.minimalPuts && this.cache.get(key) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("item already cached: " + key));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("caching: " + key));
        }
        this.cache.put(key, value);
        return true;
    }

    public CacheConcurrencyStrategy.SoftLock lock(Object key, Object version) throws CacheException {
        return null;
    }

    public void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + key));
        }
        this.cache.put(key, value);
    }

    public void insert(Object key, Object value) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("inserting: " + key));
        }
        this.cache.put(key, value);
    }

    public void evict(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void remove(Object key) throws CacheException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing: " + key));
        }
        this.cache.remove(key);
    }

    public void clear() throws CacheException {
        log.debug((Object)"clearing");
        this.cache.clear();
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void afterInsert(Object key, Object value, Object version) throws CacheException {
    }

    public void afterUpdate(Object key, Object value, Object version, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        this.minimalPuts = minimalPuts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

