/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.collection.CompositeElementPropertyMapping;
import net.sf.hibernate.collection.ElementPropertyMapping;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.collection.QueryableCollection;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.exception.JDBCExceptionHelper;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.mapping.Array;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.IdentifierCollection;
import net.sf.hibernate.mapping.IndexedCollection;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.metadata.CollectionMetadata;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.persister.PropertyMapping;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.sql.SelectFragment;
import net.sf.hibernate.sql.Template;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractCollectionPersister
implements CollectionMetadata,
QueryableCollection {
    private final String sqlDeleteString;
    private final String sqlInsertRowString;
    private final String sqlUpdateRowString;
    private final String sqlDeleteRowString;
    private final String sqlOrderByString;
    protected final String sqlWhereString;
    private final String sqlOrderByStringTemplate;
    private final String sqlWhereStringTemplate;
    private final boolean hasOrder;
    protected final boolean hasWhere;
    private final boolean hasOrphanDelete;
    private final Type keyType;
    private final Type indexType;
    protected final Type elementType;
    protected final String[] keyColumnNames;
    protected final String[] indexColumnNames;
    protected final String[] elementColumnNames;
    protected final String[] rowSelectColumnNames;
    protected final String[] indexColumnAliases;
    protected final String[] elementColumnAliases;
    protected final String[] keyColumnAliases;
    private final Type rowSelectType;
    private final boolean primitiveArray;
    private final boolean array;
    protected final String qualifiedTableName;
    protected final boolean hasIndex;
    private final boolean isLazy;
    private final boolean isInverse;
    protected final int batchSize;
    private final Class elementClass;
    private final CacheConcurrencyStrategy cache;
    private final PersistentCollectionType collectionType;
    private final int enableJoinedFetch;
    private final Class ownerClass;
    private final IdentifierGenerator identifierGenerator;
    private final String unquotedIdentifierColumnName;
    private final Type identifierType;
    protected final boolean hasIdentifier;
    protected final String identifierColumnName;
    private final String identifierColumnAlias;
    private final Dialect dialect;
    private final SQLExceptionConverter sqlExceptionConverter;
    private final PropertyMapping elementPropertyMapping;
    protected final ClassPersister elementPersister;
    private final CollectionInitializer initializer;
    private final String role;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$collection$BasicCollectionPersister == null ? (class$net$sf$hibernate$collection$BasicCollectionPersister = AbstractCollectionPersister.class$("net.sf.hibernate.collection.BasicCollectionPersister")) : class$net$sf$hibernate$collection$BasicCollectionPersister));
    static /* synthetic */ Class class$net$sf$hibernate$collection$BasicCollectionPersister;

    public AbstractCollectionPersister(Collection collection, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        ClassPersister persister;
        Type selectColumns;
        String[] selectType;
        this.dialect = factory.getDialect();
        this.sqlExceptionConverter = factory.getSQLExceptionConverter();
        this.collectionType = collection.getCollectionType();
        this.role = collection.getRole();
        this.ownerClass = collection.getOwnerClass();
        Alias alias = new Alias("__");
        this.sqlOrderByString = collection.getOrderBy();
        this.hasOrder = this.sqlOrderByString != null;
        this.sqlOrderByStringTemplate = this.hasOrder ? Template.renderOrderByStringTemplate(this.sqlOrderByString, this.dialect) : null;
        this.sqlWhereString = collection.getWhere();
        this.hasWhere = this.sqlWhereString != null;
        this.sqlWhereStringTemplate = this.hasWhere ? Template.renderWhereStringTemplate(this.sqlWhereString, this.dialect) : null;
        this.hasOrphanDelete = collection.hasOrphanDelete();
        this.batchSize = collection.getBatchSize();
        this.cache = collection.getCache();
        this.keyType = collection.getKey().getType();
        Iterator iter = collection.getKey().getColumnIterator();
        int keySpan = collection.getKey().getColumnSpan();
        this.keyColumnNames = new String[keySpan];
        String[] keyAliases = new String[keySpan];
        int k = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.keyColumnNames[k] = col.getQuotedName(this.dialect);
            keyAliases[k] = col.getAlias();
            ++k;
        }
        this.keyColumnAliases = alias.toAliasStrings(keyAliases);
        HashSet distinctColumns = new HashSet();
        this.checkColumnDuplication(distinctColumns, collection.getKey().getColumnIterator());
        this.primitiveArray = collection.isPrimitiveArray();
        this.array = collection.isArray();
        int elementSpan = collection.getElement().getColumnSpan();
        iter = collection.getElement().getColumnIterator();
        Table table = collection.getCollectionTable();
        this.enableJoinedFetch = collection.getElement().getOuterJoinFetchSetting();
        this.elementType = collection.getElement().getType();
        if (!collection.isOneToMany()) {
            this.checkColumnDuplication(distinctColumns, collection.getElement().getColumnIterator());
        }
        this.elementPersister = this.elementType.isEntityType() ? factory.getPersister(((EntityType)this.elementType).getAssociatedClass()) : null;
        this.qualifiedTableName = table.getQualifiedName(this.dialect, factory.getDefaultSchema());
        String[] aliases = new String[elementSpan];
        this.elementColumnNames = new String[elementSpan];
        int j = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.elementColumnNames[j] = col.getQuotedName(this.dialect);
            aliases[j] = col.getAlias();
            ++j;
        }
        this.elementColumnAliases = alias.toAliasStrings(aliases);
        this.hasIndex = collection.isIndexed();
        if (this.hasIndex) {
            IndexedCollection indexedCollection = (IndexedCollection)collection;
            this.indexType = indexedCollection.getIndex().getType();
            int indexSpan = indexedCollection.getIndex().getColumnSpan();
            iter = indexedCollection.getIndex().getColumnIterator();
            this.indexColumnNames = new String[indexSpan];
            String[] indexAliases = new String[indexSpan];
            int i = 0;
            while (iter.hasNext()) {
                Column indexCol = (Column)iter.next();
                indexAliases[i] = indexCol.getAlias();
                this.indexColumnNames[i] = indexCol.getQuotedName(this.dialect);
                ++i;
            }
            selectType = this.indexColumnNames;
            selectColumns = this.indexType;
            this.indexColumnAliases = alias.toAliasStrings(indexAliases);
            this.checkColumnDuplication(distinctColumns, indexedCollection.getIndex().getColumnIterator());
        } else {
            this.indexType = null;
            this.indexColumnNames = null;
            this.indexColumnAliases = null;
            selectType = this.elementColumnNames;
            selectColumns = this.elementType;
        }
        this.hasIdentifier = collection.isIdentified();
        if (this.hasIdentifier) {
            if (collection.isOneToMany()) {
                throw new MappingException("one-to-many collections with identifiers are not supported");
            }
            IdentifierCollection idColl = (IdentifierCollection)collection;
            this.identifierType = idColl.getIdentifier().getType();
            iter = idColl.getIdentifier().getColumnIterator();
            Column col = (Column)iter.next();
            this.identifierColumnName = col.getQuotedName(this.dialect);
            selectType = new String[]{this.identifierColumnName};
            selectColumns = this.identifierType;
            this.unquotedIdentifierColumnName = this.identifierColumnAlias = alias.toAliasString(col.getAlias());
            this.identifierGenerator = idColl.getIdentifier().createIdentifierGenerator(factory.getDialect());
            this.checkColumnDuplication(distinctColumns, idColl.getIdentifier().getColumnIterator());
        } else {
            this.identifierType = null;
            this.identifierColumnName = null;
            this.identifierColumnAlias = null;
            this.unquotedIdentifierColumnName = null;
            this.identifierGenerator = null;
        }
        this.rowSelectColumnNames = selectType;
        this.rowSelectType = selectColumns;
        this.sqlDeleteString = this.generateDeleteString();
        this.sqlInsertRowString = this.generateInsertRowString();
        this.sqlUpdateRowString = this.generateUpdateRowString();
        this.sqlDeleteRowString = this.generateDeleteRowString();
        this.isLazy = collection.isLazy();
        this.isInverse = collection.isInverse();
        this.elementClass = collection.isArray() ? ((Array)collection).getElementClass() : null;
        this.initializer = this.createCollectionInitializer(factory);
        this.elementPropertyMapping = this.elementType.isComponentType() ? new CompositeElementPropertyMapping(this.elementColumnNames, (AbstractComponentType)this.elementType, factory) : (!this.elementType.isEntityType() ? new ElementPropertyMapping(this.elementColumnNames, this.elementType) : ((persister = factory.getPersister(((EntityType)this.elementType).getAssociatedClass())) instanceof PropertyMapping ? (PropertyMapping)((Object)persister) : new ElementPropertyMapping(this.elementColumnNames, this.elementType)));
    }

    public void initialize(Serializable key, SessionImplementor session) throws HibernateException {
        try {
            this.initializer.initialize(key, session);
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "could not initialize collection: " + MessageHelper.infoString(this, key));
        }
    }

    protected abstract CollectionInitializer createCollectionInitializer(SessionFactoryImplementor var1) throws MappingException;

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public PersistentCollectionType getCollectionType() {
        return this.collectionType;
    }

    public String getSQLWhereString(String alias) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", alias);
    }

    public String getSQLOrderByString(String alias) {
        return StringHelper.replace(this.sqlOrderByStringTemplate, "$PlaceHolder$", alias);
    }

    public int enableJoinedFetch() {
        return this.enableJoinedFetch;
    }

    public boolean hasOrdering() {
        return this.hasOrder;
    }

    public boolean hasWhere() {
        return this.hasWhere;
    }

    protected String getSQLDeleteString() {
        return this.sqlDeleteString;
    }

    protected String getSQLInsertRowString() {
        return this.sqlInsertRowString;
    }

    protected String getSQLUpdateRowString() {
        return this.sqlUpdateRowString;
    }

    protected String getSQLDeleteRowString() {
        return this.sqlDeleteRowString;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public Object readElement(ResultSet rs, Object owner, SessionImplementor session) throws HibernateException, SQLException {
        Object element = this.getElementType().nullSafeGet(rs, this.elementColumnAliases, session, owner);
        return element;
    }

    public Object readIndex(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object index = this.getIndexType().nullSafeGet(rs, this.indexColumnAliases, session, null);
        if (index == null) {
            throw new HibernateException("null index column for collection: " + this.role);
        }
        return index;
    }

    public Object readIdentifier(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        Object id = this.getIdentifierType().nullSafeGet(rs, this.unquotedIdentifierColumnName, session, null);
        if (id == null) {
            throw new HibernateException("null identifier column for collection: " + this.role);
        }
        return id;
    }

    public Object readKey(ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        return this.getKeyType().nullSafeGet(rs, this.keyColumnAliases, session, null);
    }

    public void writeElement(PreparedStatement st, Object elt, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getElementType().nullSafeSet(st, elt, 1 + (writeOrder ? 0 : this.keyColumnNames.length + (this.hasIndex ? this.indexColumnNames.length : 0) + (this.hasIdentifier ? 1 : 0)), session);
    }

    public void writeIndex(PreparedStatement st, Object idx, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getIndexType().nullSafeSet(st, idx, 1 + this.keyColumnNames.length + (writeOrder ? this.elementColumnNames.length : 0), session);
    }

    public void writeIdentifier(PreparedStatement st, Object idx, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierType().nullSafeSet(st, idx, 1 + (writeOrder ? this.elementColumnNames.length : this.keyColumnNames.length), session);
    }

    private void writeRowSelect(PreparedStatement st, Object idx, SessionImplementor session) throws HibernateException, SQLException {
        this.rowSelectType.nullSafeSet(st, idx, 1 + (this.hasIdentifier ? 0 : this.keyColumnNames.length), session);
    }

    public void writeKey(PreparedStatement st, Serializable id, boolean writeOrder, SessionImplementor session) throws HibernateException, SQLException {
        if (id == null) {
            throw new NullPointerException("null key for collection: " + this.role);
        }
        this.getKeyType().nullSafeSet(st, id, 1 + (writeOrder ? this.elementColumnNames.length : 0), session);
    }

    public boolean isPrimitiveArray() {
        return this.primitiveArray;
    }

    public boolean isArray() {
        return this.array;
    }

    public String selectFragment(String alias) {
        SelectFragment frag = new SelectFragment().setSuffix("").addColumns(alias, this.keyColumnNames, this.keyColumnAliases).addColumns(alias, this.elementColumnNames, this.elementColumnAliases);
        if (this.hasIndex) {
            frag.addColumns(alias, this.indexColumnNames, this.indexColumnAliases);
        }
        if (this.hasIdentifier) {
            frag.addColumn(alias, this.identifierColumnName, this.identifierColumnAlias);
        }
        return frag.toFragmentString().substring(2);
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames;
    }

    public String[] getElementColumnNames() {
        return this.elementColumnNames;
    }

    public String[] getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getTableName() {
        return this.qualifiedTableName;
    }

    public void remove(Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Deleting collection: " + MessageHelper.infoString(this, id)));
            }
            try {
                PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteString());
                try {
                    this.writeKey(st, id, false, session);
                    session.getBatcher().addToBatch(-1);
                }
                catch (SQLException sqle) {
                    session.getBatcher().abortBatch(sqle);
                    throw sqle;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"done deleting collection");
                }
            }
            catch (SQLException sqle) {
                throw this.convert(sqle, "could not delete collection: " + MessageHelper.infoString(this, id));
            }
        }
    }

    public void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        block11: {
            if (!this.isInverse) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Inserting collection: " + MessageHelper.infoString(this, id)));
                }
                try {
                    Iterator entries = collection.entries();
                    if (entries.hasNext()) {
                        try {
                            collection.preInsert(this);
                            int i = 0;
                            int count = 0;
                            while (entries.hasNext()) {
                                Object entry = entries.next();
                                if (collection.entryExists(entry, i)) {
                                    PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                                    this.writeKey(st, id, false, session);
                                    collection.writeTo(st, this, entry, i, false);
                                    session.getBatcher().addToBatch(1);
                                    collection.afterRowInsert(this, entry, i);
                                    ++count;
                                }
                                ++i;
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("done inserting collection: " + count + " rows inserted"));
                            }
                            break block11;
                        }
                        catch (SQLException sqle) {
                            session.getBatcher().abortBatch(sqle);
                            throw sqle;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"collection was empty");
                    }
                }
                catch (SQLException sqle) {
                    throw this.convert(sqle, "could not insert collection: " + MessageHelper.infoString(this, id));
                }
            }
        }
    }

    public void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        block11: {
            if (!this.isInverse) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting rows of collection: " + MessageHelper.infoString(this, id)));
                }
                try {
                    Iterator entries = collection.getDeletes(this.elementType);
                    if (entries.hasNext()) {
                        int count = 0;
                        PreparedStatement st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                        try {
                            while (entries.hasNext()) {
                                if (!this.hasIdentifier) {
                                    this.writeKey(st, id, false, session);
                                }
                                this.writeRowSelect(st, entries.next(), session);
                                session.getBatcher().addToBatch(-1);
                                ++count;
                            }
                        }
                        catch (SQLException sqle) {
                            session.getBatcher().abortBatch(sqle);
                            throw sqle;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("done deleting collection rows: " + count + " deleted"));
                        }
                        break block11;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"no rows to delete");
                    }
                }
                catch (SQLException sqle) {
                    throw this.convert(sqle, "could not delete collection rows: " + MessageHelper.infoString(this, id));
                }
            }
        }
    }

    public void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Inserting rows of collection: " + MessageHelper.infoString(this, id)));
            }
            try {
                Iterator entries = collection.entries();
                try {
                    collection.preInsert(this);
                    int i = 0;
                    int count = 0;
                    while (entries.hasNext()) {
                        Object entry = entries.next();
                        PreparedStatement st = null;
                        if (collection.needsInserting(entry, i, this.elementType)) {
                            if (st == null) {
                                st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                            }
                            this.writeKey(st, id, false, session);
                            collection.writeTo(st, this, entry, i, false);
                            session.getBatcher().addToBatch(1);
                            collection.afterRowInsert(this, entry, i);
                            ++count;
                        }
                        ++i;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("done inserting rows: " + count + " inserted"));
                    }
                }
                catch (SQLException sqle) {
                    session.getBatcher().abortBatch(sqle);
                    throw sqle;
                }
            }
            catch (SQLException sqle) {
                throw this.convert(sqle, "could not insert collection rows: " + MessageHelper.infoString(this, id));
            }
        }
    }

    public String getRole() {
        return this.role;
    }

    public Class getOwnerClass() {
        return this.ownerClass;
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public boolean hasOrphanDelete() {
        return this.hasOrphanDelete;
    }

    private void checkColumnDuplication(Set distinctColumns, Iterator columns) throws MappingException {
        while (columns.hasNext()) {
            Column col = (Column)columns.next();
            if (distinctColumns.add(col.getName())) continue;
            throw new MappingException("Repeated column in mapping for collection: " + this.role + " column: " + col.getName());
        }
    }

    public Type toType(String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            return this.indexType;
        }
        return this.elementPropertyMapping.toType(propertyName);
    }

    public String[] toColumns(String alias, String propertyName) throws QueryException {
        if ("index".equals(propertyName)) {
            if (this.isManyToMany()) {
                throw new QueryException("index() function not supported for many-to-many association");
            }
            return StringHelper.qualify(alias, this.indexColumnNames);
        }
        return this.elementPropertyMapping.toColumns(alias, propertyName);
    }

    public Type getType() {
        return this.elementPropertyMapping.getType();
    }

    public String[] getJoinKeyColumnNames() {
        return this.getKeyColumnNames();
    }

    public String getName() {
        return this.getRole();
    }

    public ClassPersister getElementPersister() {
        if (this.elementPersister == null) {
            throw new AssertionFailure("not an association");
        }
        return (Loadable)this.elementPersister;
    }

    public boolean isCollection() {
        return true;
    }

    public Serializable getCollectionSpace() {
        return this.getTableName();
    }

    protected abstract String generateDeleteString();

    protected abstract String generateDeleteRowString();

    protected abstract String generateUpdateRowString();

    protected abstract String generateInsertRowString();

    public void updateRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Updating rows of collection: " + this.role + "#" + id));
            }
            int count = this.doUpdateRows(id, collection, session);
            if (log.isDebugEnabled()) {
                log.debug((Object)("done updating rows: " + count + " updated"));
            }
        }
    }

    protected abstract int doUpdateRows(Serializable var1, PersistentCollection var2, SessionImplementor var3) throws HibernateException;

    public CollectionMetadata getCollectionMetadata() {
        return this;
    }

    protected JDBCException convert(SQLException sqlException, String message) {
        return JDBCExceptionHelper.convert(this.sqlExceptionConverter, sqlException, message);
    }

    public String toString() {
        return StringHelper.root(this.getClass().getName()) + '(' + this.role + ')';
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

