/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.connection.C3P0ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.DBCPConnectionProvider;
import net.sf.hibernate.connection.DatasourceConnectionProvider;
import net.sf.hibernate.connection.DriverManagerConnectionProvider;
import net.sf.hibernate.connection.ProxoolConnectionProvider;
import net.sf.hibernate.connection.UserSuppliedConnectionProvider;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ConnectionProviderFactory {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$connection$ConnectionProviderFactory == null ? (class$net$sf$hibernate$connection$ConnectionProviderFactory = ConnectionProviderFactory.class$("net.sf.hibernate.connection.ConnectionProviderFactory")) : class$net$sf$hibernate$connection$ConnectionProviderFactory));
    private static final Set SPECIAL_PROPERTIES = new HashSet();
    static /* synthetic */ Class class$net$sf$hibernate$connection$ConnectionProviderFactory;

    public static ConnectionProvider newConnectionProvider() throws HibernateException {
        return ConnectionProviderFactory.newConnectionProvider(Environment.getProperties());
    }

    public static ConnectionProvider newConnectionProvider(Properties properties) throws HibernateException {
        ConnectionProvider connections;
        String providerClass = properties.getProperty("hibernate.connection.provider_class");
        if (providerClass != null) {
            try {
                log.info((Object)("Initializing connection provider: " + providerClass));
                connections = (ConnectionProvider)ReflectHelper.classForName(providerClass).newInstance();
            }
            catch (Exception e) {
                log.fatal((Object)"Could not instantiate connection provider", (Throwable)e);
                throw new HibernateException("Could not instantiate connection provider: " + providerClass);
            }
        } else {
            connections = properties.getProperty("hibernate.connection.datasource") != null ? new DatasourceConnectionProvider() : (properties.getProperty("hibernate.c3p0.max_size") != null ? new C3P0ConnectionProvider() : (properties.getProperty("hibernate.dbcp.maxActive") != null ? new DBCPConnectionProvider() : (properties.getProperty("hibernate.proxool.xml") != null || properties.getProperty("hibernate.proxool.properties") != null || properties.getProperty("hibernate.proxool.existing_pool") != null ? new ProxoolConnectionProvider() : (properties.getProperty("hibernate.connection.url") != null ? new DriverManagerConnectionProvider() : new UserSuppliedConnectionProvider()))));
        }
        connections.configure(properties);
        return connections;
    }

    private ConnectionProviderFactory() {
        throw new UnsupportedOperationException();
    }

    public static Properties getConnectionProperties(Properties properties) {
        Iterator<Object> iter = properties.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            String prop = (String)iter.next();
            if (prop.indexOf("hibernate.connection") <= -1 || SPECIAL_PROPERTIES.contains(prop)) continue;
            result.setProperty(prop.substring("hibernate.connection".length() + 1), properties.getProperty(prop));
        }
        String userName = properties.getProperty("hibernate.connection.username");
        if (userName != null) {
            result.setProperty("user", userName);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SPECIAL_PROPERTIES.add("hibernate.connection.datasource");
        SPECIAL_PROPERTIES.add("hibernate.connection.url");
        SPECIAL_PROPERTIES.add("hibernate.connection.provider_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.pool_size");
        SPECIAL_PROPERTIES.add("hibernate.connection.isolation");
        SPECIAL_PROPERTIES.add("hibernate.connection.driver_class");
        SPECIAL_PROPERTIES.add("hibernate.connection.username");
    }
}

