/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.expression.AbstractCriterion;

public class Order {
    private boolean ascending;
    private String propertyName;
    private static final Map EMPTY_MAP = new HashMap();

    protected Order(String propertyName, boolean ascending) {
        this.propertyName = propertyName;
        this.ascending = ascending;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        String[] columns = AbstractCriterion.getColumns(sessionFactory, persistentClass, this.propertyName, alias, EMPTY_MAP);
        if (columns.length != 1) {
            throw new HibernateException("Cannot order by multi-column property: " + this.propertyName);
        }
        return columns[0] + (this.ascending ? " asc" : " desc");
    }

    public static Order asc(String propertyName) {
        return new Order(propertyName, true);
    }

    public static Order desc(String propertyName) {
        return new Order(propertyName, false);
    }
}

