/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.UUIDGenerator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.PropertiesHelper;

public class UUIDHexGenerator
extends UUIDGenerator
implements Configurable {
    private String sep = "";

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    public Serializable generate(SessionImplementor cache, Object obj) {
        return new StringBuffer(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty("separator", "/");
        UUIDHexGenerator gen = new UUIDHexGenerator();
        ((Configurable)gen).configure(Hibernate.STRING, props, null);
        UUIDHexGenerator gen2 = new UUIDHexGenerator();
        ((Configurable)gen2).configure(Hibernate.STRING, props, null);
        for (int i = 0; i < 10; ++i) {
            String id = (String)((Object)gen.generate(null, null));
            System.out.println(id + ": " + id.length());
            String id2 = (String)((Object)gen2.generate(null, null));
            System.out.println(id2 + ": " + id2.length());
        }
    }

    public void configure(Type type, Properties params, Dialect d) {
        this.sep = PropertiesHelper.getString("separator", params, "");
    }
}

