/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.SessionImpl;

abstract class ScheduledCollectionAction
implements SessionImpl.Executable,
Serializable {
    private transient CollectionPersister persister;
    private Serializable id;
    private SessionImplementor session;
    private CacheConcurrencyStrategy.SoftLock lock;
    private String collectionRole;

    public ScheduledCollectionAction(CollectionPersister persister, Serializable id, SessionImplementor session) throws CacheException {
        this.persister = persister;
        this.session = session;
        this.id = id;
        this.collectionRole = persister.getRole();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.persister = this.session.getFactory().getCollectionPersister(this.collectionRole);
        }
        catch (MappingException e) {
            throw new IOException("Unable to resolve collection persister on deserialization");
        }
    }

    public void afterTransactionCompletion(boolean success) throws CacheException {
        if (this.persister.hasCache()) {
            this.persister.getCache().release(this.id, this.lock);
        }
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache();
    }

    public Serializable[] getPropertySpaces() {
        return new Serializable[]{this.persister.getCollectionSpace()};
    }

    protected final CollectionPersister getPersister() {
        return this.persister;
    }

    protected final Serializable getId() {
        return this.id;
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    public final void beforeExecutions() throws CacheException {
        if (this.persister.hasCache()) {
            this.lock = this.persister.getCache().lock(this.id, null);
        }
    }

    protected final void evict() throws CacheException {
        if (this.persister.hasCache()) {
            this.persister.getCache().evict(this.id);
        }
    }
}

