/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

abstract class ScheduledEntityAction
implements SessionImpl.Executable,
Serializable {
    private SessionImplementor session;
    private Serializable id;
    private Object instance;
    private transient ClassPersister persister;

    protected ScheduledEntityAction(SessionImplementor session, Serializable id, Object instance, ClassPersister persister) {
        this.session = session;
        this.id = id;
        this.persister = persister;
        this.instance = instance;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        try {
            this.persister = this.session.getPersister(this.instance);
        }
        catch (MappingException e) {
            throw new IOException("Unable to resolve class persister on deserialization");
        }
    }

    public final Serializable[] getPropertySpaces() {
        return this.persister.getPropertySpaces();
    }

    protected final SessionImplementor getSession() {
        return this.session;
    }

    protected final Serializable getId() {
        return this.id;
    }

    protected final ClassPersister getPersister() {
        return this.persister;
    }

    protected final Object getInstance() {
        return this.instance;
    }

    public boolean hasAfterTransactionCompletion() {
        return this.persister.hasCache();
    }

    public void beforeExecutions() {
        throw new AssertionFailure("beforeExecutions() called for non-collection action");
    }
}

